/*
 * Decompiled with CFR 0.152.
 */
package com.live2d.cubism.doc.model.deformer.warp.bezier;

import com.live2d.core.IBlendable;
import com.live2d.core.ICopyable;
import com.live2d.core.a;
import com.live2d.cubism.doc.model.deformer.warp.grid.ACGrid;
import com.live2d.cubism.doc.model.deformer.warp.grid.ICGrid;
import com.live2d.cubism.doc.model.deformer.warp.grid.d;
import com.live2d.doc.selection.IPointRef;
import com.live2d.graphics3d.type.GRectF;
import com.live2d.graphics3d.type.GVector2;
import com.live2d.util.j;
import java.util.Arrays;
import java.util.List;
import jp.noids.util.L;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020'H\u0016J\"\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u0007H\u0016J*\u0010:\u001a\u0004\u0018\u00010\u00072\u0006\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020.2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00109\u001a\u00020\u0007J*\u0010=\u001a\u0004\u0018\u00010\u00072\u0006\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020.2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00109\u001a\u00020\u0007J\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020\u000fH\u0016J\b\u0010C\u001a\u00020\u001fH\u0016J\u0018\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020@2\u0006\u0010A\u001a\u00020)H\u0016J \u0010F\u001a\u00020@2\u0006\u0010E\u001a\u00020<2\u0006\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020\u000fH\u0016J \u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020.2\u0006\u0010I\u001a\u00020.2\u0006\u00109\u001a\u00020\u0007H\u0016J\u0010\u0010J\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u0015H\u0016J\u0018\u0010L\u001a\u00020'2\u0006\u0010+\u001a\u00020M2\u0006\u00103\u001a\u000204H\u0016J\b\u0010N\u001a\u00020'H\u0016J\b\u0010O\u001a\u00020'H\u0016R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000b\"\u0004\b%\u0010\r\u00a8\u0006P"}, d2={"Lcom/live2d/cubism/doc/model/deformer/warp/bezier/CSimpleGrid;", "Lcom/live2d/cubism/doc/model/deformer/warp/grid/ACGrid;", "()V", "col", "", "row", "points", "", "(II[F)V", "<set-?>", "getCol", "()I", "setCol$cubism", "(I)V", "dirty", "", "getDirty$cubism", "()Z", "setDirty$cubism", "(Z)V", "lastUpdated", "", "getLastUpdated$cubism", "()J", "setLastUpdated$cubism", "(J)V", "getPoints", "()[F", "setPoints$cubism", "([F)V", "rect", "Lcom/live2d/graphics3d/type/GRectF;", "getRect$cubism", "()Lcom/live2d/graphics3d/type/GRectF;", "setRect$cubism", "(Lcom/live2d/graphics3d/type/GRectF;)V", "getRow", "setRow$cubism", "applyTransform", "", "t", "Lcom/live2d/doc/selection/ICTransform;", "blend", "that", "Lcom/live2d/core/IBlendable;", "weightOfThat", "", "canInterpolate", "target", "Lcom/live2d/cubism/doc/model/deformer/warp/grid/ICGrid;", "deepCopy", "cp", "Lcom/live2d/core/CopyParam;", "dump", "get01", "px", "py", "ret", "get01_ex", "colRowPoint01", "Lcom/live2d/graphics3d/type/GVector2;", "get01_ex_quad", "getAllPointRef", "", "Lcom/live2d/doc/selection/IPointRef;", "localToDst", "selected", "getBoundsRect", "getCompatiblePointRef", "pt", "getNearestPointRef", "getPt", "s01", "t01", "isUpdated", "time", "reinit", "Lcom/live2d/core/ICopyable;", "setDirty", "verify", "cubism"})
public final class CSimpleGrid
extends ACGrid {
    private int col;
    private int row;
    @NotNull
    private float[] points;
    private boolean dirty;
    @Nullable
    private transient GRectF rect;
    private long lastUpdated;

    public final int getCol() {
        return this.col;
    }

    public final void setCol$cubism(int n2) {
        this.col = n2;
    }

    public final int getRow() {
        return this.row;
    }

    public final void setRow$cubism(int n2) {
        this.row = n2;
    }

    @NotNull
    public final float[] getPoints() {
        return this.points;
    }

    public final void setPoints$cubism(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this.points = fArray;
    }

    public final boolean getDirty$cubism() {
        return this.dirty;
    }

    public final void setDirty$cubism(boolean bl2) {
        this.dirty = bl2;
    }

    @Nullable
    public final GRectF getRect$cubism() {
        return this.rect;
    }

    public final void setRect$cubism(@Nullable GRectF gRectF) {
        this.rect = gRectF;
    }

    public CSimpleGrid() {
        this.dirty = true;
        this.points = j.a.a();
    }

    public CSimpleGrid(int n2, int n3, @NotNull float[] fArray) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this.dirty = true;
        this.col = n2;
        this.row = n3;
        this.points = fArray;
        boolean bl3 = bl2 = (n2 + 1) * (n3 + 1) * 2 == fArray.length;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void applyTransform(@NotNull com.live2d.doc.selection.d d2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        d2.transform(this.points, this.points);
        this.setDirty();
    }

    @Override
    @Nullable
    public float[] get01(float f2, float f3, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return this.get01_ex(f2, f3, null, fArray);
    }

    @Nullable
    public final float[] get01_ex(float f2, float f3, @Nullable GVector2 gVector2, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        int n2 = this.col + 1;
        GRectF gRectF = this.getBoundsRect();
        if (!gRectF.contains(f2, f3)) {
            return null;
        }
        float f4 = Float.NaN;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n3 = 0;
        int n4 = this.row - 1;
        if (n3 <= n4) {
            while (true) {
                int n5;
                int n6;
                if ((n6 = 0) <= (n5 = this.col - 1)) {
                    while (true) {
                        float f7;
                        float f8;
                        float f9;
                        float f10;
                        float f11;
                        float f12;
                        float f13;
                        float f14;
                        float[] fArray2;
                        if ((fArray2 = d.a.a(f2, f3, f14 = this.points[2 * (n6 + n3 * n2)], f13 = this.points[2 * (n6 + n3 * n2) + 1], f12 = this.points[2 * (n6 + 1 + n3 * n2)], f11 = this.points[2 * (n6 + 1 + n3 * n2) + 1], f10 = this.points[2 * (n6 + (n3 + 1) * n2)], f9 = this.points[2 * (n6 + (n3 + 1) * n2) + 1], f8 = this.points[2 * (n6 + 1 + (n3 + 1) * n2)], f7 = this.points[2 * (n6 + 1 + (n3 + 1) * n2) + 1], fArray)) != null) {
                            fArray2[0] = ((float)n6 + fArray2[0]) / (float)this.col;
                            fArray2[1] = ((float)n3 + fArray2[1]) / (float)this.row;
                            if (gVector2 == null) {
                                return fArray2;
                            }
                            if (Float.isNaN(f4)) {
                                f4 = fArray2[0];
                                f5 = fArray2[1];
                                GVector2 gVector22 = gVector2;
                                float f15 = fArray2[0];
                                var25_27 = fArray2[1];
                                boolean bl2 = false;
                                f6 = (gVector22.getX() - f15) * (gVector22.getX() - f15) + (gVector22.getY() - var25_27) * (gVector22.getY() - var25_27);
                            } else {
                                GVector2 gVector23 = gVector2;
                                var25_27 = fArray2[0];
                                float f16 = fArray2[1];
                                boolean bl3 = false;
                                float f17 = (gVector23.getX() - var25_27) * (gVector23.getX() - var25_27) + (gVector23.getY() - f16) * (gVector23.getY() - f16);
                                if (f6 > f17) {
                                    f4 = fArray2[0];
                                    f5 = fArray2[1];
                                    f6 = f17;
                                }
                            }
                        }
                        if (n6 == n5) break;
                        ++n6;
                    }
                }
                if (n3 == n4) break;
                ++n3;
            }
        }
        if (Float.isNaN(f4)) {
            return null;
        }
        fArray[0] = f4;
        fArray[1] = f5;
        return fArray;
    }

    @Nullable
    public final float[] get01_ex_quad(float f2, float f3, @Nullable GVector2 gVector2, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        int n2 = this.col + 1;
        GRectF gRectF = this.getBoundsRect();
        if (!gRectF.contains(f2, f3)) {
            return null;
        }
        float f4 = Float.NaN;
        float f5 = 0.0f;
        float f6 = 0.0f;
        GVector2 gVector22 = new GVector2();
        GVector2 gVector23 = new GVector2();
        GVector2 gVector24 = new GVector2();
        GVector2 gVector25 = new GVector2();
        GVector2 gVector26 = new GVector2(f2, f3);
        int n3 = 0;
        int n4 = this.row - 1;
        if (n3 <= n4) {
            while (true) {
                int n5;
                int n6;
                if ((n6 = 0) <= (n5 = this.col - 1)) {
                    while (true) {
                        gVector22.setX(this.points[2 * (n6 + n3 * n2)]);
                        gVector22.setY(this.points[2 * (n6 + n3 * n2) + 1]);
                        gVector23.setX(this.points[2 * (n6 + 1 + n3 * n2)]);
                        gVector23.setY(this.points[2 * (n6 + 1 + n3 * n2) + 1]);
                        gVector24.setX(this.points[2 * (n6 + (n3 + 1) * n2)]);
                        gVector24.setY(this.points[2 * (n6 + (n3 + 1) * n2) + 1]);
                        gVector25.setX(this.points[2 * (n6 + 1 + (n3 + 1) * n2)]);
                        gVector25.setY(this.points[2 * (n6 + 1 + (n3 + 1) * n2) + 1]);
                        float[] fArray2 = d.a.a(gVector22, gVector23, gVector24, gVector25, gVector26, fArray);
                        if (fArray2 != null) {
                            fArray2[0] = ((float)n6 + fArray2[0]) / (float)this.col;
                            fArray2[1] = ((float)n3 + fArray2[1]) / (float)this.row;
                            if (gVector2 == null) {
                                return fArray2;
                            }
                            if (Float.isNaN(f4)) {
                                f4 = fArray2[0];
                                f5 = fArray2[1];
                                GVector2 gVector27 = gVector2;
                                float f7 = fArray2[0];
                                var22_24 = fArray2[1];
                                boolean bl2 = false;
                                f6 = (gVector27.getX() - f7) * (gVector27.getX() - f7) + (gVector27.getY() - var22_24) * (gVector27.getY() - var22_24);
                            } else {
                                GVector2 gVector28 = gVector2;
                                var22_24 = fArray2[0];
                                float f8 = fArray2[1];
                                boolean bl3 = false;
                                float f9 = (gVector28.getX() - var22_24) * (gVector28.getX() - var22_24) + (gVector28.getY() - f8) * (gVector28.getY() - f8);
                                if (f6 > f9) {
                                    f4 = fArray2[0];
                                    f5 = fArray2[1];
                                    f6 = f9;
                                }
                            }
                        }
                        if (n6 == n5) break;
                        ++n6;
                    }
                }
                if (n3 == n4) break;
                ++n3;
            }
        }
        if (Float.isNaN(f4)) {
            return null;
        }
        fArray[0] = f4;
        fArray[1] = f5;
        return fArray;
    }

    @Override
    @NotNull
    public float[] getPt(float f2, float f3, @NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        int n2 = (int)(f2 * (float)this.col);
        int n3 = (int)(f3 * (float)this.row);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.col - 1) {
            n2 = this.col - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.row - 1) {
            n3 = this.row - 1;
        }
        float f4 = f2 * (float)this.col - (float)n2;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        float f5 = f3 * (float)this.row - (float)n3;
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        int n4 = this.col + 1;
        if (f4 + f5 < 1.0f) {
            float f6 = this.points[2 * (n2 + n3 * n4)];
            float f7 = this.points[2 * (n2 + n3 * n4) + 1];
            float f8 = this.points[2 * (n2 + 1 + n3 * n4)];
            float f9 = this.points[2 * (n2 + 1 + n3 * n4) + 1];
            float f10 = this.points[2 * (n2 + (n3 + 1) * n4)];
            float f11 = this.points[2 * (n2 + (n3 + 1) * n4) + 1];
            fArray[0] = f6 + f4 * (f8 - f6) + f5 * (f10 - f6);
            fArray[1] = f7 + f4 * (f9 - f7) + f5 * (f11 - f7);
        } else {
            float f12 = this.points[2 * (n2 + 1 + n3 * n4)];
            float f13 = this.points[2 * (n2 + 1 + n3 * n4) + 1];
            float f14 = this.points[2 * (n2 + (n3 + 1) * n4)];
            float f15 = this.points[2 * (n2 + (n3 + 1) * n4) + 1];
            float f16 = this.points[2 * (n2 + 1 + (n3 + 1) * n4)];
            float f17 = this.points[2 * (n2 + 1 + (n3 + 1) * n4) + 1];
            fArray[0] = f16 + (1.0f - f4) * (f14 - f16) + (1.0f - f5) * (f12 - f16);
            fArray[1] = f17 + (1.0f - f4) * (f15 - f17) + (1.0f - f5) * (f13 - f17);
        }
        return fArray;
    }

    @Override
    @NotNull
    public GRectF getBoundsRect() {
        if (this.rect == null) {
            int n2 = this.points.length;
            float f2 = Float.POSITIVE_INFINITY;
            float f3 = Float.POSITIVE_INFINITY;
            float f4 = Float.NEGATIVE_INFINITY;
            float f5 = Float.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < n2; i2 += 2) {
                float f6 = this.points[i2];
                float f7 = this.points[i2 + 1];
                if (f6 > f4) {
                    f4 = f6;
                }
                if (f7 > f5) {
                    f5 = f7;
                }
                if (f6 < f2) {
                    f2 = f6;
                }
                if (!(f7 < f3)) continue;
                f3 = f7;
            }
            this.rect = new GRectF(f2, f3, f4 - f2, f5 - f3);
        }
        GRectF gRectF = this.rect;
        Intrinsics.checkNotNull((Object)gRectF);
        return gRectF;
    }

    @Override
    public void blend(@NotNull IBlendable iBlendable, float f2) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)iBlendable, (String)"");
        CSimpleGrid cfr_ignored_0 = (CSimpleGrid)iBlendable;
        int n3 = n2 = this.col == ((CSimpleGrid)iBlendable).col ? 1 : 0;
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int n4 = n2 = this.row != ((CSimpleGrid)iBlendable).row ? 1 : 0;
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int n5 = n2 = this.points.length != ((CSimpleGrid)iBlendable).points.length ? 1 : 0;
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int n6 = ((CSimpleGrid)iBlendable).points.length;
        for (n2 = 0; n2 < n6; ++n2) {
            float[] fArray = this.points;
            int n7 = n2;
            fArray[n7] = fArray[n7] + ((CSimpleGrid)iBlendable).points[n2] * f2;
        }
    }

    @Override
    public boolean canInterpolate(@NotNull ICGrid iCGrid) {
        Intrinsics.checkNotNullParameter((Object)iCGrid, (String)"");
        if (!(iCGrid instanceof CSimpleGrid)) {
            return false;
        }
        return this.col == ((CSimpleGrid)iCGrid).col && this.row == ((CSimpleGrid)iCGrid).row;
    }

    @Override
    @NotNull
    public CSimpleGrid deepCopy(@NotNull a a2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"");
        ICopyable iCopyable = super.deepCopy(a2);
        Intrinsics.checkNotNull((Object)iCopyable);
        return (CSimpleGrid)iCopyable;
    }

    @Override
    public void reinit(@NotNull ICopyable iCopyable, @NotNull a a2) {
        Intrinsics.checkNotNullParameter((Object)iCopyable, (String)"");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"");
        if (!(iCopyable instanceof CSimpleGrid)) {
            return;
        }
        this.col = ((CSimpleGrid)iCopyable).col;
        this.row = ((CSimpleGrid)iCopyable).row;
        float[] fArray = ((CSimpleGrid)iCopyable).points;
        boolean bl2 = false;
        float[] fArray2 = Arrays.copyOf(fArray, fArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"");
        this.points = fArray2;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.rect = null;
        this.lastUpdated = System.currentTimeMillis();
    }

    public final long getLastUpdated$cubism() {
        return this.lastUpdated;
    }

    public final void setLastUpdated$cubism(long l2) {
        this.lastUpdated = l2;
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    @Override
    public void dump() {
        Object[] objectArray = new Object[]{this.col, this.row, L.a(this.points)};
        System.out.printf("SimpleGrid %d,%d = { %s }\n", objectArray);
    }

    @Override
    @NotNull
    public IPointRef getNearestPointRef(@NotNull GVector2 gVector2, @NotNull com.live2d.doc.selection.d d2, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)gVector2, (String)"");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        throw new RuntimeException("Not supported _");
    }

    @Override
    @NotNull
    public List<IPointRef> getAllPointRef(@NotNull com.live2d.doc.selection.d d2, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        throw new RuntimeException("Not supported _");
    }

    @Override
    @NotNull
    public IPointRef getCompatiblePointRef(@NotNull IPointRef iPointRef, @NotNull com.live2d.doc.selection.d d2) {
        Intrinsics.checkNotNullParameter((Object)iPointRef, (String)"");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"");
        throw new RuntimeException("Not supported _");
    }

    @Override
    public void verify() {
    }
}

