/*
 * Decompiled with CFR 0.152.
 */
package com.live2d.graphics.filter;

import com.live2d.graphics.filter.AStaticFilterDef;
import com.live2d.graphics.filter.concreteFilter.ClippingFilterDef;
import com.live2d.graphics.filter.concreteFilter.ColorInvertFilterDef;
import com.live2d.graphics.filter.concreteFilter.OpaqueFilterDef;
import com.live2d.serialize.DontObfuscate;
import com.live2d.type.FilterDefGuid;
import com.live2d.type.StaticFilterDefGuid;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontObfuscate
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/live2d/graphics/filter/StaticFilterLibrary;", "", "()V", "filterMap", "Ljava/util/LinkedHashMap;", "Lcom/live2d/type/FilterDefGuid;", "Lcom/live2d/graphics/filter/AStaticFilterDef;", "addStaticFilter", "", "f", "getStaticFilter", "guid", "Lcom/live2d/type/StaticFilterDefGuid;", "core"})
public final class StaticFilterLibrary {
    @NotNull
    public static final StaticFilterLibrary INSTANCE = new StaticFilterLibrary();
    @NotNull
    private static final LinkedHashMap<FilterDefGuid, AStaticFilterDef> filterMap = new LinkedHashMap();

    private StaticFilterLibrary() {
    }

    public final void addStaticFilter(@NotNull AStaticFilterDef aStaticFilterDef) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)aStaticFilterDef, (String)"");
        boolean bl3 = bl2 = !Intrinsics.areEqual((Object)aStaticFilterDef.getFilterDefGuid(), (Object)FilterDefGuid.Companion.a());
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl2 = !filterMap.containsKey(aStaticFilterDef.getFilterDefGuid());
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        filterMap.put(aStaticFilterDef.getFilterDefGuid(), aStaticFilterDef);
    }

    @Nullable
    public final AStaticFilterDef getStaticFilter(@NotNull StaticFilterDefGuid staticFilterDefGuid) {
        Intrinsics.checkNotNullParameter((Object)staticFilterDefGuid, (String)"");
        AStaticFilterDef aStaticFilterDef = filterMap.get(staticFilterDefGuid);
        AStaticFilterDef aStaticFilterDef2 = AStaticFilterDef.Companion.a().get(staticFilterDefGuid);
        boolean bl2 = Intrinsics.areEqual((Object)aStaticFilterDef, (Object)aStaticFilterDef2);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return filterMap.get(staticFilterDefGuid);
    }

    static {
        INSTANCE.addStaticFilter(OpaqueFilterDef.INSTANCE);
        INSTANCE.addStaticFilter(ClippingFilterDef.INSTANCE);
        INSTANCE.addStaticFilter(ColorInvertFilterDef.INSTANCE);
    }
}

