/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.cubism.ui.avatarColorSetting;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import jp.live2d.cubism.ui.avatarColorSetting.ColorConvert;
import jp.live2d.cubism.ui.avatarColorSetting.ColorGroup;
import jp.live2d.cubism.ui.avatarColorSetting.a.a;
import jp.live2d.type_editor.LDColor;
import jp.noids.design.jogl.ac;
import jp.noids.graphics.f;
import jp.noids.graphics.interpolate.b;
import jp.noids.util.C;
import jp.noids.util.ap;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class ColorConvert_ColorList
extends ColorConvert {
    private static final long serialVersionUID = 1L;
    private static final int LIGHT_STEP = 256;
    private int lastTexName = -1;
    private GL2 lastGL = null;
    private boolean dirtyTex = true;
    private BufferedImage imageLUT = new BufferedImage(256, 1, 2);
    private Texture texture = null;
    private TextureData textureData = null;
    private IntBuffer nativeIntBuffer = null;

    public ColorConvert_ColorList() {
    }

    public ColorConvert_ColorList(String string, String string2, LDColor[] lDColorArray) {
        super(string, string2, lDColorArray);
    }

    public static ColorConvert_ColorList deriveFrom(ColorConvert colorConvert, ColorGroup colorGroup, ColorGroup colorGroup2) {
        LDColor[] lDColorArray;
        LDColor[] lDColorArray2 = colorGroup.getBaseColors();
        LDColor[] lDColorArray3 = colorGroup2.getBaseColors();
        LDColor[] lDColorArray4 = colorConvert.getTargetColorsRef();
        int n2 = lDColorArray3.length;
        if (lDColorArray2.length == n2) {
            lDColorArray = lDColorArray4;
        } else {
            int n3;
            LDColor lDColor;
            boolean bl2 = false;
            int[] nArray = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                lDColor = lDColorArray3[n4];
                nArray[n4] = n3 = ColorConvert_ColorList.getIndex(lDColorArray2, lDColor);
                ++n4;
            }
            lDColorArray = new LDColor[n2];
            n4 = 0;
            while (n4 < n2) {
                int n5 = nArray[n4];
                if (n5 >= 0 && n5 < lDColorArray4.length) {
                    lDColorArray[n4] = lDColorArray4[n5];
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n2) {
                if (lDColorArray[n4] == null) {
                    LDColor lDColor2;
                    LDColor lDColor3;
                    lDColor = n4 == 0 ? LDColor.WHITE : lDColorArray[n4 - 1];
                    n3 = -1;
                    int n6 = n4 + 1;
                    while (n6 < n2) {
                        if (lDColorArray[n6] != null) {
                            n3 = n6;
                            break;
                        }
                        ++n6;
                    }
                    LDColor lDColor4 = lDColor3 = n3 == -1 ? LDColor.BLACK : lDColorArray[n3];
                    if (n3 == -1) {
                        n3 = lDColorArray.length;
                    }
                    double d2 = 1.0 / (double)(n3 - (n4 - 1));
                    lDColorArray[n4] = lDColor2 = b.a(lDColor, lDColor3, d2);
                }
                ++n4;
            }
        }
        ColorConvert_ColorList colorConvert_ColorList = new ColorConvert_ColorList(colorConvert.convertName, colorConvert.convertID, lDColorArray);
        return colorConvert_ColorList;
    }

    private static int getIndex(LDColor[] lDColorArray, LDColor lDColor) {
        int n2 = 0;
        while (n2 < lDColorArray.length) {
            LDColor lDColor2 = lDColorArray[n2];
            if (lDColor2.equals(lDColor)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public ColorConvert_ColorList deepClone() {
        ColorConvert_ColorList colorConvert_ColorList = new ColorConvert_ColorList();
        colorConvert_ColorList.init(this);
        return colorConvert_ColorList;
    }

    @Override
    public void init(Object object) {
        ColorConvert_ColorList colorConvert_ColorList = (ColorConvert_ColorList)object;
        super.init(colorConvert_ColorList);
    }

    @Override
    public void setGroup_notForClient(ColorGroup colorGroup) {
        super.setGroup_notForClient(colorGroup);
        LDColor[] lDColorArray = colorGroup.getBaseColors();
    }

    @Override
    public void write(l l2, Element element) {
        super.write(l2, l2.a(element));
    }

    @Override
    public void read(g g2, Element element) {
        super.read(g2, g2.b(element));
    }

    @Override
    public void setDirty() {
        super.setDirty();
        this.dirtyTex = true;
    }

    public int getLUTTextureName(GL2 gL2) {
        if (gL2 != this.lastGL || this.dirtyTex) {
            LDColor[] lDColorArray;
            if (this.group == null) {
                if (C.e()) {
                    System.err.printf("group is null :: getLUTTextureName()\t\t\t\t\t@@ColorConvert_ColorList\n", new Object[0]);
                }
                return 0;
            }
            LDColor[] lDColorArray2 = this.group.getBaseColors();
            if (lDColorArray2.length != (lDColorArray = this.getTargetColorsRef()).length) {
                if (C.e()) {
                    throw new RuntimeException("Illegal state :_ not same length");
                }
                return 0;
            }
            int[] nArray = f.c(this.imageLUT);
            this.setupColorTable(lDColorArray2, lDColorArray, nArray);
            this.updateTexture(gL2, nArray);
            this.lastTexName = this.texture.getTextureObject((GL)gL2);
            this.dirtyTex = false;
            this.lastGL = gL2;
        }
        return this.lastTexName;
    }

    private void setupColorTable(LDColor[] lDColorArray, LDColor[] lDColorArray2, int[] nArray) {
        float[] fArray = new float[lDColorArray.length];
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = a.a(lDColorArray[n2]);
            ++n2;
        }
        n2 = 0;
        float f2 = 1.0f;
        LDColor lDColor = LDColor.WHITE;
        float f3 = fArray[0];
        LDColor lDColor2 = lDColorArray2[0];
        int n3 = 255;
        while (n3 >= 0) {
            float f4 = (float)n3 / 255.0f;
            if (f4 < f3) {
                f2 = f3;
                lDColor = lDColor2;
                f3 = ++n2 < fArray.length ? fArray[n2] : 0.0f;
                lDColor2 = n2 < fArray.length ? lDColorArray2[n2] : LDColor.BLACK;
            }
            float f5 = f2 == f3 ? 0.0f : (f2 - f4) / (f2 - f3);
            int n4 = lDColor.getRGB();
            int n5 = lDColor2.getRGB();
            nArray[n3] = ColorConvert_ColorList.interpolate_rgb(n4, n5, f5) | 0xFF000000;
            --n3;
        }
    }

    public static int interpolate_rgb(int n2, int n3, double d2) {
        if (d2 <= 0.0) {
            return n2;
        }
        if (d2 >= 1.0) {
            return n3;
        }
        int n4 = (int)((double)(n2 >>> 24 & 0xFF) * (1.0 - d2) + (double)(n3 >>> 24 & 0xFF) * d2);
        int n5 = (int)((double)(n2 >>> 16 & 0xFF) * (1.0 - d2) + (double)(n3 >>> 16 & 0xFF) * d2);
        int n6 = (int)((double)(n2 >>> 8 & 0xFF) * (1.0 - d2) + (double)(n3 >>> 8 & 0xFF) * d2);
        int n7 = (int)((double)(n2 & 0xFF) * (1.0 - d2) + (double)(n3 & 0xFF) * d2);
        n4 = ap.a(n4, 0, 255);
        n5 = ap.a(n5, 0, 255);
        n6 = ap.a(n6, 0, 255);
        n7 = ap.a(n7, 0, 255);
        return n4 << 24 | n5 << 16 | n6 << 8 | n7;
    }

    private void updateTexture(GL2 gL2, int[] nArray) {
        if (this.textureData == null) {
            GLProfile gLProfile = ac.a();
            this.textureData = AWTTextureIO.newTextureData((GLProfile)gLProfile, (BufferedImage)this.imageLUT, (boolean)false);
            this.nativeIntBuffer = Buffers.newDirectIntBuffer((int[])nArray);
        } else {
            this.nativeIntBuffer.clear();
            this.nativeIntBuffer.put(nArray);
            this.nativeIntBuffer.position(0);
            this.textureData.setBuffer((Buffer)this.nativeIntBuffer);
        }
        if (this.texture == null) {
            this.texture = AWTTextureIO.newTexture((GL)gL2, (TextureData)this.textureData);
        } else {
            this.texture.updateImage((GL)gL2, this.textureData);
        }
        this.texture.enable((GL)gL2);
        this.texture.bind((GL)gL2);
    }
}

