/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.cubism.ui.morphEditor;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import jp.live2d.cubism.f.w;
import jp.live2d.cubism.ui.morphEditor.TextureImage;
import jp.live2d.cubism.ui.morphEditor.source.ISourceImage;
import jp.live2d.cubism.ui.morphEditor.source.ISourceRegion;
import jp.live2d.cubism.ui.morphEditor.source.SourceImage_PSD;
import jp.live2d.type_editor.image.LDImage;
import jp.noids.graphics.f;
import jp.noids.model3Dp.Model;
import jp.noids.ui.h.b;
import jp.noids.ui.l.a;
import jp.noids.util.C;
import jp.noids.util.al;
import jp.noids.util.az;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class TextureManager
implements b,
h {
    private static final long serialVersionUID = 1L;
    public static String CLIENT_PROPERTY_KEY = "CLIENT_PROPERTY_KEY";
    private static TextureManager currentTextureManager;
    TextureManager cloneSrc = null;
    ArrayList<TextureImage> textureList = new ArrayList();
    ArrayList<ISourceImage> sourceList = new ArrayList();

    public static TextureManager getCurrent() {
        return currentTextureManager;
    }

    public void dump() {
        System.out.printf("--- dump textures ---\t\t\t\t\t@@TextureManager\n", new Object[0]);
        for (TextureImage textureImage : this.textureList) {
            System.out.printf("   texture : %s\n", textureImage.getTextureName());
        }
    }

    public static void setCurrent(TextureManager textureManager) {
        currentTextureManager = textureManager;
    }

    @Override
    public b clone_forEdit(jp.noids.ui.h.a a2) {
        TextureManager textureManager = new TextureManager();
        textureManager.init_forEdit(this, a2);
        textureManager.cloneSrc = (TextureManager)a2.a(this, textureManager);
        return textureManager;
    }

    public void init_forEdit(b b2, jp.noids.ui.h.a a2) {
        b b3;
        b b4;
        TextureManager textureManager = (TextureManager)b2;
        this.textureList.clear();
        int n2 = 0;
        while (n2 < textureManager.textureList.size()) {
            b4 = textureManager.textureList.get(n2);
            b3 = ((TextureImage)b4).clone_forEdit(a2);
            this.textureList.add((TextureImage)b3);
            ++n2;
        }
        this.sourceList.clear();
        n2 = 0;
        while (n2 < textureManager.sourceList.size()) {
            b4 = textureManager.sourceList.get(n2);
            b3 = (ISourceImage)b4.clone_forEdit(a2);
            this.sourceList.add((ISourceImage)b3);
            ++n2;
        }
    }

    @Override
    public b getCloneSrc() {
        return this.cloneSrc;
    }

    @Override
    public void read(g g2, Element element) {
        int n2 = g2.a(element);
        if (n2 < 1001) {
            ArrayList arrayList = (ArrayList)g2.a(element, "imageList");
            this.textureList.clear();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                BufferedImage bufferedImage = (BufferedImage)arrayList.get(n3);
                LDImage lDImage = new LDImage(bufferedImage);
                this.addNewTextureImageIfNotExists(lDImage);
                ++n3;
            }
        } else if (n2 < 1002) {
            ArrayList arrayList = (ArrayList)g2.a(element, "imageRefList");
            this.textureList.clear();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                LDImage lDImage = (LDImage)arrayList.get(n4);
                this.addNewTextureImageIfNotExists(lDImage);
                ++n4;
            }
        } else {
            this.textureList = (ArrayList)g2.a(element, "textureList");
        }
        if (n2 >= 1003) {
            this.sourceList = (ArrayList)g2.a(element, "sourceList");
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1003);
        l2.a(element, "textureList", this.textureList);
        l2.a(element, "sourceList", this.sourceList);
    }

    public void clearCache() {
        for (TextureImage textureImage : this.textureList) {
            textureImage.dispose();
        }
        this.textureList.clear();
    }

    public ArrayList<TextureImage> getTextureList() {
        return this.textureList;
    }

    public void setTextureList(ArrayList<TextureImage> arrayList) {
        this.textureList = arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isSamePicture(LDImage lDImage, LDImage lDImage2) {
        try {
            int[] nArray;
            if (lDImage == lDImage2) {
                return true;
            }
            BufferedImage bufferedImage = lDImage.getBufferedImage();
            BufferedImage bufferedImage2 = lDImage2.getBufferedImage();
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            if (n2 != bufferedImage2.getWidth()) {
                return false;
            }
            if (n3 != bufferedImage2.getHeight()) {
                return false;
            }
            if (bufferedImage.getType() != bufferedImage2.getType()) {
                return false;
            }
            if (bufferedImage.getRGB(0, 0) != bufferedImage2.getRGB(0, 0)) {
                return false;
            }
            if (bufferedImage.getRGB(n2 - 1, 0) != bufferedImage2.getRGB(n2 - 1, 0)) {
                return false;
            }
            if (bufferedImage.getRGB(n2 - 1, n3 - 1) != bufferedImage2.getRGB(n2 - 1, n3 - 1)) {
                return false;
            }
            if (bufferedImage.getRGB(0, n3 - 1) != bufferedImage2.getRGB(0, n3 - 1)) {
                return false;
            }
            if (bufferedImage.getRGB(n2 / 2, n3 / 2) != bufferedImage2.getRGB(n2 / 2, n3 / 2)) {
                return false;
            }
            int[] nArray2 = f.c(bufferedImage);
            if (nArray2 == (nArray = f.c(bufferedImage2))) {
                System.out.printf("same buffer\t\t\t\t\t@@TextureManager\n", new Object[0]);
                return true;
            }
            int n4 = nArray2.length;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    return true;
                }
                if (nArray2[n5] != nArray[n5]) {
                    return false;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isSameImageExists(LDImage lDImage) {
        TextureImage textureImage = this.getSameTexture(lDImage);
        return textureImage != null;
    }

    public boolean isSameImageExists(BufferedImage bufferedImage) {
        LDImage lDImage = new LDImage(bufferedImage);
        TextureImage textureImage = this.getSameTexture(lDImage);
        return textureImage != null;
    }

    public TextureImage addNewTextureImageIfNotExists(LDImage lDImage) {
        return this.addNewTextureImageIfNotExists(lDImage, null);
    }

    public TextureImage addNewTextureImageIfNotExists(LDImage lDImage, a a2) {
        try {
            TextureImage textureImage = this.getSameTexture(lDImage);
            if (textureImage == null) {
                textureImage = this.createTextureImage(null, lDImage, null);
                this.addTextureImage(textureImage);
                if (a2 != null) {
                    w w2 = w.a(this, textureImage);
                    a2.addEdit(w2);
                }
            }
            return textureImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TextureImage createTextureImage(Model model, LDImage lDImage, String string) {
        if (string == null) {
            string = "untitled";
        }
        while (true) {
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.textureList.size()) {
                TextureImage textureImage = this.textureList.get(n2);
                if (string.equals(textureImage.getTextureName())) {
                    bl2 = true;
                }
                ++n2;
            }
            if (!bl2) break;
            string = az.e(string);
        }
        return TextureImage.createDefault(model, lDImage, string);
    }

    public static TextureImage getSame(ArrayList<TextureImage> arrayList, LDImage lDImage) {
        int n2 = 0;
        while (n2 < arrayList.size()) {
            TextureImage textureImage = arrayList.get(n2);
            LDImage lDImage2 = textureImage.getImage();
            if (lDImage2 == lDImage) {
                return textureImage;
            }
            if (TextureManager.isSamePicture(lDImage2, lDImage)) {
                return textureImage;
            }
            ++n2;
        }
        return null;
    }

    public TextureImage getSameTexture(LDImage lDImage) {
        int n2 = 0;
        while (n2 < this.textureList.size()) {
            TextureImage textureImage = this.textureList.get(n2);
            LDImage lDImage2 = textureImage.getImage();
            if (lDImage2.equals(lDImage)) {
                return textureImage;
            }
            ++n2;
        }
        TextureImage textureImage = TextureManager.getSame(this.textureList, lDImage);
        return textureImage;
    }

    public TextureImage getSameTexture(TextureImage textureImage) {
        int n2 = 0;
        while (n2 < this.textureList.size()) {
            TextureImage textureImage2 = this.textureList.get(n2);
            LDImage lDImage = textureImage2.getImage();
            if (lDImage.equals(textureImage.getImage())) {
                return textureImage2;
            }
            ++n2;
        }
        TextureImage textureImage3 = TextureManager.getSame(this.textureList, textureImage.getImage());
        return textureImage3;
    }

    public int addTextureImage(TextureImage textureImage) {
        return this.insertTextureImage(textureImage, -1);
    }

    public boolean hasTextureImage(TextureImage textureImage) {
        return this.textureList.contains(textureImage);
    }

    public int insertTextureImage(TextureImage textureImage, int n2) {
        int n3 = this.textureList.indexOf(textureImage);
        if (n3 >= 0) {
            return n3;
        }
        String string = textureImage.getTextureName();
        if (string == null && C.e()) {
            throw new RuntimeException(a.b.a("CUBI-0853"));
        }
        int n4 = 0;
        while (n4 < this.textureList.size()) {
            TextureImage textureImage2 = this.textureList.get(n4);
            String string2 = textureImage2.getTextureName();
            if (string.equals(string2) && C.e()) {
                throw new RuntimeException(a.b.a("CUBI-0854"));
            }
            ++n4;
        }
        if (n2 >= 0 && n2 <= this.textureList.size()) {
            this.textureList.add(n2, textureImage);
            n4 = n2;
        } else {
            this.textureList.add(textureImage);
            n4 = this.textureList.size() - 1;
        }
        return n4;
    }

    public boolean deleteTextureImage(TextureImage textureImage) {
        return this.textureList.remove(textureImage);
    }

    public int getTextureImageNo(TextureImage textureImage) {
        return this.textureList.indexOf(textureImage);
    }

    public TextureImage getTextureImage(int n2) {
        return this.textureList.get(n2);
    }

    public int getTextureImageCount() {
        return this.textureList.size();
    }

    public void setTextureImage(int n2, TextureImage textureImage) {
        if (this.textureList.remove(textureImage)) {
            if (this.textureList.size() < n2) {
                al.a(this.textureList, n2);
                this.textureList.ensureCapacity(n2);
            }
            this.textureList.add(n2, textureImage);
        } else {
            if (this.textureList.size() <= n2) {
                al.a(this.textureList, n2 + 1);
                this.textureList.ensureCapacity(n2 + 1);
            }
            this.textureList.set(n2, textureImage);
        }
    }

    public int getMaxSize() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.textureList.size()) {
            TextureImage textureImage = this.textureList.get(n3);
            n2 = Math.max(n2, Math.max(textureImage.getWidth(), textureImage.getHeight()));
            ++n3;
        }
        return n2;
    }

    public int addSourceImage(ISourceImage iSourceImage, int n2) {
        if (this.sourceList.contains(iSourceImage)) {
            return this.sourceList.indexOf(iSourceImage);
        }
        if (n2 < 0) {
            n2 = this.sourceList.size();
        }
        this.sourceList.add(n2, iSourceImage);
        return n2;
    }

    public void setSourceImage(Collection<ISourceImage> collection) {
        this.sourceList.clear();
        this.sourceList.addAll(collection);
    }

    public boolean hasSourceImage(ISourceImage iSourceImage) {
        return this.sourceList.contains(iSourceImage);
    }

    public void removeSourceImage(ISourceImage iSourceImage) {
        this.sourceList.remove(iSourceImage);
    }

    public int indexOfSourceImage(ISourceImage iSourceImage) {
        return this.sourceList.indexOf(iSourceImage);
    }

    public ISourceImage[] getSourceList() {
        return this.sourceList.toArray(new ISourceImage[0]);
    }

    public void cleanupSourceImage() {
        Iterator<ISourceImage> iterator = this.sourceList.iterator();
        while (iterator.hasNext()) {
            ISourceImage iSourceImage = iterator.next();
            ISourceRegion[] iSourceRegionArray = iSourceImage.getSourceRegions();
            if (iSourceRegionArray != null && iSourceRegionArray.length != 0) continue;
            iterator.remove();
        }
    }

    public boolean hasPSDImage() {
        for (ISourceImage iSourceImage : this.sourceList) {
            if (!(iSourceImage instanceof SourceImage_PSD)) continue;
            return true;
        }
        return false;
    }

    public LinkedHashSet<ISourceImage> getAllSourceImageInTextureImages() {
        ArrayList<TextureImage> arrayList = this.getTextureList();
        LinkedHashSet<ISourceImage> linkedHashSet = new LinkedHashSet<ISourceImage>();
        for (TextureImage textureImage : arrayList) {
            ISourceRegion[] iSourceRegionArray = textureImage.getSourceRegions();
            int n2 = 0;
            while (n2 < iSourceRegionArray.length) {
                linkedHashSet.add(iSourceRegionArray[n2].getSourceImage());
                ++n2;
            }
        }
        return linkedHashSet;
    }

    public String toString() {
        return "TextureManager";
    }
}

