/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.type_editor.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import jp.live2d.type_editor.image.b;
import jp.live2d.type_editor.image.c;
import jp.live2d.type_editor.image.d;
import jp.live2d.type_editor.image.e;
import jp.noids.graphics.UtImage;
import jp.noids.graphics.f;
import jp.noids.util.C;
import jp.noids.util.M;
import jp.noids.util.O;
import jp.noids.util.UtURL;
import jp.noids.util.ax;
import jp.noids.util.ay;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class LDImage
implements Serializable,
h {
    private static final int DEFAULT_COLOR_TYPE = 2;
    public static boolean DEBUG = true;
    private static final long serialVersionUID = 1L;
    private static final int CHECK_TIMER_SEC = 300;
    private static final int ARCHIVE_IMAGE_TIME_SEC = 360;
    int width;
    int height;
    int type;
    byte[] imageFileBuf;
    byte[] previewImageFileBuf;
    BufferedImage image;
    BufferedImage previewImage;
    transient long lastUse = 0L;
    transient boolean isDisposed = false;
    public transient String debugString = "";
    static ArrayList<a> cacheList = new ArrayList();
    static Timer timer = new Timer();
    static int createdCount = 0;
    static int disposedCount = 0;
    String DEBUG_LOG = null;
    static boolean cleanupRunning;
    static ArrayList<LDImage> DEBUG_IMAGES;
    boolean archiveIfIdleUsing = false;

    static {
        timer.schedule((TimerTask)new jp.live2d.type_editor.image.a(), 300000L, 300000L);
        cleanupRunning = false;
        DEBUG_IMAGES = new ArrayList();
    }

    private static void invokeCleanupThread() {
        b b2 = new b();
        b2.start();
    }

    static void cleanupTimer() {
        if (cleanupRunning) {
            return;
        }
        cleanupRunning = true;
        try {
            try {
                boolean bl2 = false;
                Iterator<a> iterator = cacheList.iterator();
                while (iterator.hasNext()) {
                    a a2 = iterator.next();
                    LDImage lDImage = a2.a.get();
                    if (lDImage == null) {
                        iterator.remove();
                        continue;
                    }
                    if (bl2 |= lDImage.archiveIfIdle()) break;
                }
                if (bl2) {
                    System.gc();
                }
            }
            catch (Throwable throwable) {
                System.err.printf("LDImage clear :: error [%s]\t\t\t\t\t@@LDImage\n", throwable);
                cleanupRunning = false;
            }
        }
        finally {
            cleanupRunning = false;
        }
    }

    public static void dumpState() {
        System.out.printf("LDImage state dump --------\t\t\t\t\t@@LDImage\n", new Object[0]);
        System.out.printf("cache list size : %d\t\t\t\t\t\n", cacheList.size());
        System.out.printf("create / dispose / remaining : %d / %d\t/ %d\t\t\t\n", createdCount, disposedCount, createdCount - disposedCount);
    }

    public LDImage() {
        cacheList.add(new a(this));
        ++createdCount;
        if (DEBUG) {
            this.debugStart();
        }
    }

    public LDImage(BufferedImage bufferedImage) {
        this();
        if (bufferedImage.getType() != 2) {
            bufferedImage = UtImage.createSameTypeImage(bufferedImage, 2);
        }
        this.imageFileBuf = null;
        this.image = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.type = bufferedImage.getType();
    }

    public LDImage(byte[] byArray) {
        this();
        this.imageFileBuf = byArray;
        this.image = null;
        this.width = -1;
        this.height = -1;
        this.type = -1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isSameContents(LDImage lDImage) {
        block15: {
            if (lDImage == null) {
                return false;
            }
            LDImage lDImage2 = this;
            if (lDImage2.getWidth() != lDImage.getWidth()) {
                return false;
            }
            if (lDImage2.getHeight() != lDImage.getHeight()) {
                return false;
            }
            try {
                BufferedImage bufferedImage = lDImage2.getBufferedImage();
                BufferedImage bufferedImage2 = lDImage.getBufferedImage();
                if (bufferedImage.getType() != bufferedImage2.getType()) {
                    return false;
                }
                DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
                DataBuffer dataBuffer2 = bufferedImage2.getRaster().getDataBuffer();
                if (dataBuffer.getDataType() != dataBuffer2.getDataType()) {
                    return false;
                }
                if (dataBuffer instanceof DataBufferInt) {
                    int[] nArray;
                    int[] nArray2 = ((DataBufferInt)dataBuffer).getData();
                    if (nArray2.length != (nArray = ((DataBufferInt)dataBuffer2).getData()).length) {
                        return false;
                    }
                    int n2 = nArray2.length - 1;
                    while (n2 >= 0) {
                        if (nArray2[n2] != nArray[n2]) {
                            return false;
                        }
                        --n2;
                    }
                    break block15;
                }
                if (dataBuffer instanceof DataBufferByte) {
                    byte[] byArray;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    if (byArray2.length != (byArray = ((DataBufferByte)dataBuffer2).getData()).length) {
                        return false;
                    }
                    int n3 = byArray2.length - 1;
                    while (n3 >= 0) {
                        if (byArray2[n3] != byArray[n3]) {
                            return false;
                        }
                        --n3;
                    }
                    break block15;
                }
                throw new RuntimeException("Not Impl");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void debugStart() {
        if (!DEBUG) {
            return;
        }
        this.DEBUG_LOG = C.b(1, 1);
        DEBUG_IMAGES.add(this);
    }

    public static void debugClear() {
        DEBUG_IMAGES.clear();
    }

    public static void debugDump() {
        if (!DEBUG) {
            return;
        }
        System.out.printf("--------------------------------------------------\t\t\t\t\t@@LDImage\n", new Object[0]);
        System.out.printf("--------------------------------------------------\t\t\t\t\t@@LDImage\n", new Object[0]);
        long l2 = 0L;
        int n2 = 0;
        while (n2 < DEBUG_IMAGES.size()) {
            LDImage lDImage = DEBUG_IMAGES.get(n2);
            int n3 = lDImage.getWidth() * lDImage.getHeight() * 4;
            l2 += (long)n3;
            System.out.printf("[%2d] : %8s : %s\n", n2, LDImage.toByteStr(n3), lDImage.DEBUG_LOG);
            ++n2;
        }
        System.out.printf("TOTAL : %8s ( %d files )\n", LDImage.toByteStr(l2), DEBUG_IMAGES.size());
    }

    private static String toByteStr(long l2) {
        if (l2 < 1024L) {
            return l2 + " B";
        }
        if (l2 < 0x100000L) {
            return l2 / 1024L + " KB";
        }
        return l2 / 0x100000L + " MB";
    }

    public static LDImage createSample(int n2, int n3) {
        BufferedImage bufferedImage = UtImage.createSampleImage(n2, n3);
        LDImage lDImage = new LDImage(bufferedImage);
        return lDImage;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        ++disposedCount;
        Iterator<a> iterator = cacheList.iterator();
        while (iterator.hasNext()) {
            a a2 = iterator.next();
            if (a2.a != null && a2.a.get() != this) continue;
            iterator.remove();
        }
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        if (this.previewImage != null) {
            this.previewImage.flush();
            this.previewImage = null;
        }
        this.imageFileBuf = null;
        this.previewImageFileBuf = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType() {
        return this.type;
    }

    public synchronized void update(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 2) {
            bufferedImage = UtImage.createSameTypeImage(bufferedImage, 2);
        }
        this.imageFileBuf = null;
        this.image = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.type = bufferedImage.getType();
        this.previewImageFileBuf = null;
        this.previewImage = null;
    }

    public synchronized void draw(jp.noids.graphics.c c2) {
        Graphics2D graphics2D = c2.s();
        BufferedImage bufferedImage = this.getBufferedImage(c2.p());
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (n2 != this.width || n3 != this.height) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale((double)this.width / (double)n2, (double)this.height / (double)n3);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
    }

    public synchronized BufferedImage getBufferedImage(int n2) {
        if (n2 <= 1) {
            if (this.previewImage == null) {
                O.a("Loading..", 0);
                if (this.previewImageFileBuf != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.previewImageFileBuf);
                    this.previewImage = UtImage.getBufferedImage(byteArrayInputStream, 2, null);
                    ((InputStream)byteArrayInputStream).close();
                } else {
                    int n3;
                    int n4 = n3 = this.width > this.height ? this.width : this.height;
                    while (n4 > 900) {
                        n4 /= 2;
                    }
                    if (n4 != n3) {
                        this.previewImage = f.a(this.getBufferedImage(), this.width * n4 / n3, this.height * n4 / n3, 2);
                    }
                }
                if (this.previewImage == null) {
                    this.previewImage = this.getBufferedImage();
                }
                O.a("", 0);
            }
            return this.previewImage;
        }
        return this.getBufferedImage();
    }

    public synchronized BufferedImage getBufferedImage() {
        if (this.image == null) {
            O.a("Loading..", 0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.imageFileBuf);
            BufferedImage bufferedImage = UtImage.getBufferedImage(byteArrayInputStream, 2, null);
            ((InputStream)byteArrayInputStream).close();
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            this.type = bufferedImage.getType();
            this.image = bufferedImage;
            O.a("", 0);
        }
        this.lastUse = System.currentTimeMillis();
        return this.image;
    }

    public synchronized boolean archiveIfIdle() {
        if (this.archiveIfIdleUsing) {
            return false;
        }
        this.archiveIfIdleUsing = true;
        try {
            if (this.image != null && this.lastUse < System.currentTimeMillis() - 360000L) {
                long l2 = System.currentTimeMillis();
                System.out.printf("archive\t\t\t\t\t@@LDImage\n", new Object[0]);
                this.archive();
                long l3 = System.currentTimeMillis() - l2;
                return true;
            }
            return false;
        }
        finally {
            this.archiveIfIdleUsing = false;
        }
    }

    synchronized void archive() {
        try {
            O.a("Archiving..", 0);
            BufferedImage bufferedImage = this.image;
            if (bufferedImage == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            UtImage.saveImage_exe(bufferedImage, bufferedOutputStream, "png", 1.0f, null);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            this.imageFileBuf = byteArrayOutputStream.toByteArray();
            this.image.flush();
            this.image = null;
            O.a("", 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void setArchivable() {
        this.lastUse = 0L;
    }

    @Override
    public synchronized void write(l l2, Element element) {
        if (this.image == null && this.imageFileBuf == null) {
            throw new jp.noids.xml.serialize.e();
        }
        String string = null;
        try {
            String string2 = "image";
            File file = l2.f();
            File file2 = M.d(file, String.valueOf(string2) + ".png");
            l2.a(element, "width", this.width);
            l2.a(element, "height", this.height);
            l2.a(element, "type", this.type);
            String string3 = l2.b(file2);
            File file3 = M.a(new File(file, String.valueOf(string2) + ".png"), true);
            if (this.image == null && this.imageFileBuf != null) {
                M.a(file3, this.imageFileBuf);
                if (!file3.renameTo(file2)) {
                    string = a.d.a("CORE-0000");
                }
            } else if (UtImage.saveImage(this.image, file3, 1.0f, true, null)) {
                if (!file3.renameTo(file2)) {
                    string = a.d.a("CORE-0000");
                }
            } else {
                string = a.d.a("CORE-0001");
            }
            if (string == null) {
                l2.a(element, "path", string3);
            }
            string3 = M.g(file2);
            file3 = M.d(file, String.valueOf(string3) + "_preview.png");
            String string4 = l2.b(file3);
            if (this.previewImage == null && this.previewImageFileBuf != null) {
                File file4 = M.a(new File(file, String.valueOf(string2) + ".png"), true);
                M.a(file4, this.previewImageFileBuf);
                if (!file4.renameTo(file3)) {
                    string = a.d.a("CORE-0000");
                }
            } else if (this.previewImage != null && this.previewImage != this.image) {
                File file5 = M.a(new File(file, String.valueOf(string2) + ".png"), true);
                if (UtImage.saveImage(this.previewImage, file5, 1.0f, true, null)) {
                    if (!file5.renameTo(file3)) {
                        string = a.d.a("CORE-0000");
                    }
                } else {
                    string = a.d.a("CORE-0001");
                }
            } else {
                string4 = null;
            }
            if (string == null) {
                l2.a(element, "preview_path", string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new jp.noids.xml.serialize.e(exception);
        }
        if (string != null) {
            throw new jp.noids.xml.serialize.e(string);
        }
    }

    @Override
    public synchronized void read(g g2, Element element) {
        try {
            this.width = g2.b(element, "width");
            this.height = g2.b(element, "height");
            this.type = g2.b(element, "type");
            String string = (String)g2.a(element, "path");
            String string2 = (String)g2.a(element, "preview_path");
            URL uRL = g2.c();
            URL uRL2 = UtURL.getRelative(uRL, string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL2.openStream());
            this.imageFileBuf = ay.a(bufferedInputStream);
            this.image = null;
            ((InputStream)bufferedInputStream).close();
            if (string2 == null) {
                this.previewImageFileBuf = null;
                this.previewImage = null;
            } else {
                uRL2 = UtURL.getRelative(uRL, string2);
                bufferedInputStream = new BufferedInputStream(uRL2.openStream());
                this.previewImageFileBuf = ay.a(bufferedInputStream);
                this.previewImage = null;
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {
            throw new jp.noids.xml.serialize.e(iOException);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.width);
        objectOutputStream.writeInt(this.height);
        objectOutputStream.writeInt(this.type);
        if (this.imageFileBuf != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeInt(this.imageFileBuf.length);
            objectOutputStream.write(this.imageFileBuf);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        if (this.image != null) {
            objectOutputStream.writeBoolean(true);
            ax.a(this.image, objectOutputStream);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        if (this.previewImageFileBuf != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeInt(this.previewImageFileBuf.length);
            objectOutputStream.write(this.previewImageFileBuf);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        if (this.previewImage != null) {
            objectOutputStream.writeBoolean(true);
            ax.a(this.previewImage, objectOutputStream);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) {
        try {
            int n2;
            this.width = objectInputStream.readInt();
            this.height = objectInputStream.readInt();
            this.type = objectInputStream.readInt();
            if (objectInputStream.readBoolean()) {
                n2 = objectInputStream.readInt();
                this.imageFileBuf = new byte[n2];
                ay.a((InputStream)objectInputStream, this.imageFileBuf);
            } else {
                this.imageFileBuf = null;
            }
            this.image = objectInputStream.readBoolean() ? ax.a(objectInputStream) : null;
            if (objectInputStream.readBoolean()) {
                n2 = objectInputStream.readInt();
                this.previewImageFileBuf = new byte[n2];
                ay.a((InputStream)objectInputStream, this.previewImageFileBuf);
            } else {
                this.previewImageFileBuf = null;
            }
            this.previewImage = objectInputStream.readBoolean() ? ax.a(objectInputStream) : null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public static void main(String[] stringArray) {
        try {
            BufferedImage bufferedImage = UtImage.createSampleImage(5000, 6000, Color.pink);
            LDImage lDImage = new LDImage(bufferedImage);
            JFrame jFrame = O.a("LDImage", a.d.a("CORE-0002"), 800, 600, true);
            Container container = jFrame.getContentPane();
            JButton jButton = new JButton("update");
            jButton.addActionListener(new c(lDImage));
            d d2 = new d();
            javax.swing.Timer timer = new javax.swing.Timer(1, new e(d2));
            timer.start();
            container.add((Component)d2, "Center");
            container.add((Component)jButton, "South");
            container.add((Component)new jp.noids.framework.d.a(), "North");
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static /* synthetic */ void access$0() {
        LDImage.invokeCleanupThread();
    }

    static class a {
        SoftReference<LDImage> a;

        public a(LDImage lDImage) {
            this.a = new SoftReference<LDImage>(lDImage);
        }
    }
}

