/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.jogl.scene;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.gl2.GLUT;
import jp.noids.design.jogl.b;
import jp.noids.design.jogl.scene.AbstractNode;
import jp.noids.design.jogl.scene.Box3D;

public abstract class SimpleNode
extends AbstractNode {
    protected boolean dirty = true;
    protected String name = "";
    protected Box3D bounds;

    protected SimpleNode() {
    }

    protected SimpleNode(String string) {
        this.name = string;
    }

    @Override
    public Box3D getBoundsBox() {
        if (this.bounds == null) {
            this.updateBounds();
        }
        return this.bounds;
    }

    public static SimpleNode createCone(double d2, double d3) {
        return SimpleNode.createCone(d2, d3, 20, 20);
    }

    public static SimpleNode createCone(final double d2, final double d3, final int n2, final int n3) {
        SimpleNode simpleNode = new SimpleNode("Cube"){

            @Override
            public void draw(b b2) {
                GLUT gLUT = b2.b();
                GL2 gL2 = b2.a();
                gL2.glEnable(2896);
                gLUT.glutSolidCone(d2, d3, n2, n3);
            }

            @Override
            protected void updateBounds() {
                this.bounds = new Box3D(-d2, d2, -d2, d2, 0.0, d3);
            }
        };
        return simpleNode;
    }

    public static SimpleNode createTeapod(final double d2) {
        SimpleNode simpleNode = new SimpleNode("Treapod"){

            @Override
            public void draw(b b2) {
                GL2 gL2 = b2.a();
                GLUT gLUT = b2.b();
                gL2.glEnable(2896);
                gLUT.glutSolidTeapot((double)((float)d2));
            }

            @Override
            protected void updateBounds() {
                double d22 = d2 * 1.65;
                double d3 = d2 * 0.8;
                this.bounds = new Box3D(-d22, d22, -d3, d3, -d2, d2);
            }
        };
        return simpleNode;
    }

    public static SimpleNode createSphere(double d2) {
        return SimpleNode.createSphere(d2, 20, 20);
    }

    public static SimpleNode createSphere(final double d2, final int n2, final int n3) {
        SimpleNode simpleNode = new SimpleNode("Sphere"){

            @Override
            public void draw(b b2) {
                GLUT gLUT = b2.b();
                GL2 gL2 = b2.a();
                gL2.glEnable(2896);
                gLUT.glutSolidSphere(d2, n2, n3);
            }

            @Override
            protected void updateBounds() {
                this.bounds = new Box3D(d2);
            }
        };
        return simpleNode;
    }

    public static SimpleNode createCube(final double d2) {
        SimpleNode simpleNode = new SimpleNode("Cube"){

            @Override
            public void draw(b b2) {
                GLUT gLUT = b2.b();
                GL2 gL2 = b2.a();
                gL2.glEnable(2896);
                gLUT.glutSolidCube((float)d2);
            }

            @Override
            protected void updateBounds() {
                this.bounds = new Box3D(d2);
            }
        };
        return simpleNode;
    }

    public static SimpleNode createCylinder(double d2, double d3) {
        return SimpleNode.createCylinder(d2, d3, 20, 20);
    }

    public static SimpleNode createCylinder(final double d2, final double d3, final int n2, final int n3) {
        SimpleNode simpleNode = new SimpleNode("Cube"){

            @Override
            public void draw(b b2) {
                GLUT gLUT = b2.b();
                GL2 gL2 = b2.a();
                gL2.glEnable(2896);
                gLUT.glutSolidCylinder(d2, d3, n2, n3);
            }

            @Override
            protected void updateBounds() {
                this.bounds = new Box3D(-d2, d2, -d2, d2, 0.0, d3);
            }
        };
        return simpleNode;
    }

    @Override
    public abstract void draw(b var1);

    protected abstract void updateBounds();

    public String toString() {
        return this.name;
    }

    @Override
    public void dump() {
        System.out.println(this.name);
    }

    @Override
    public void init(Object object) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Object deepClone() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }
}

