/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.jogl.scene.camera;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import jp.live2d.type_editor.LDColor;
import jp.noids.design.jogl.a;
import jp.noids.design.jogl.ac;
import jp.noids.design.jogl.b;
import jp.noids.design.jogl.scene.AbstractNode;
import jp.noids.design.jogl.scene.Box3D;
import jp.noids.graphics.geom.Point3d;
import jp.noids.graphics.geom.Vector3d;
import jp.noids.util.ap;

public class CameraPerspective
extends AbstractNode {
    double cameraScale = 1.0;
    double near;
    double far;
    Point3d eyePos;
    Point3d lookAt;
    Vector3d up;
    int x;
    int y;
    int width;
    int height;
    double ratio;
    double cameraBoxSize = 0.1;

    public CameraPerspective(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d2, double d3) {
        this.eyePos = point3d;
        this.lookAt = point3d2;
        this.up = vector3d;
        this.near = d2;
        this.far = d3;
    }

    public void setCamera(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        this.eyePos = point3d;
        this.lookAt = point3d2;
        this.up = vector3d;
    }

    public void resizeSetup(b b2, int n2, int n3, int n4, int n5) {
        GL2 gL2 = b2.a();
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.ratio = (float)n5 / (float)n4;
        gL2.glViewport(n2, n3, n4, n5);
        float f2 = 0.01f;
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glFrustum((double)(-1.0f * f2), (double)(1.0f * f2), -this.ratio * (double)f2, this.ratio * (double)f2, this.near, this.far);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        GLU gLU = new GLU();
        gLU.gluLookAt(this.eyePos.x, this.eyePos.y, this.eyePos.z, this.lookAt.x, this.lookAt.y, this.lookAt.z, this.up.x, this.up.y, this.up.z);
    }

    public void setupCamera(b b2) {
        this.resizeSetup(b2, this.x, this.y, this.width, this.height);
    }

    @Override
    public void draw(b b2) {
        GL2 gL2 = b2.a();
        gL2.glDisable(2896);
        ac.a(gL2, LDColor.BLUE);
        this.drawCamera(b2, gL2);
        gL2.glDisable(2896);
        ac.a(gL2, LDColor.ORANGE);
        gL2.glEnable(2852);
        gL2.glLineStipple(2, (short)-21846);
        gL2.glBegin(1);
        gL2.glVertex3d(this.eyePos.x, this.eyePos.y, this.eyePos.z);
        gL2.glVertex3d(this.lookAt.x, this.lookAt.y, this.lookAt.z);
        gL2.glEnd();
        gL2.glDisable(2852);
        gL2.glPushMatrix();
        gL2.glTranslatef((float)this.lookAt.x, (float)this.lookAt.y, (float)this.lookAt.z);
        GLUT gLUT = b2.b();
        gL2.glEnable(2896);
        ac.c(gL2, LDColor.RED);
        gLUT.glutSolidSphere(this.cameraBoxSize * 0.1, 10, 10);
        gL2.glPopMatrix();
    }

    private void drawCamera(b b2, GL2 gL2) {
        gL2.glPushMatrix();
        gL2.glTranslated(this.eyePos.x, this.eyePos.y, this.eyePos.z);
        Vector3d vector3d = new Vector3d(0.0, 0.0, -1.0);
        Vector3d vector3d2 = new Vector3d(this.eyePos, this.lookAt).unit();
        Vector3d vector3d3 = Vector3d.cross(vector3d, vector3d2).unit();
        double d2 = vector3d.getAngle(vector3d2);
        a a2 = vector3d3.isZero() ? new a() : a.a(d2 * ap.d, vector3d3);
        Vector3d vector3d4 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vector3d5 = this.up.cross_new(vector3d2);
        Vector3d vector3d6 = vector3d5.cross(vector3d2);
        a2.a(vector3d4, vector3d4);
        double d3 = vector3d4.getAngle(vector3d6);
        a a3 = a.a(d3 * ap.d, vector3d2);
        gL2.glMultMatrixd(a3.a(), 0);
        gL2.glMultMatrixd(a2.a(), 0);
        gL2.glScaled(this.cameraScale, this.cameraScale, this.cameraScale);
        double d4 = this.cameraBoxSize * 0.15;
        double d5 = this.cameraBoxSize * 0.2;
        double d6 = this.cameraBoxSize * 0.15;
        double d7 = d4 * 0.8;
        double d8 = d4 * 0.6;
        double d9 = this.cameraBoxSize * 0.3;
        double d10 = this.cameraBoxSize / 2.0;
        Box3D box3D = new Box3D(-d4, d4, -d5, d5, d6, this.cameraBoxSize - d6);
        box3D.draw(b2);
        Box3D box3D2 = new Box3D(-d7, d7, -d7, d7, 0.0, d6);
        box3D2.draw(b2);
        Box3D box3D3 = new Box3D(-d8, d8, d5, d5 + d9, d10 - d8, d10 + d8);
        box3D3.draw(b2);
        gL2.glPopMatrix();
    }

    @Override
    public void dump() {
    }

    @Override
    public Box3D getBoundsBox() {
        return new Box3D();
    }

    @Override
    public void init(Object object) {
    }

    @Override
    public Object deepClone() {
        return null;
    }

    @Override
    public void setDirty() {
    }

    public void setCameraScale(double d2) {
        this.cameraScale = d2;
    }

    public double getCameraScale() {
        return this.cameraScale;
    }
}

