/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.layer.core;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import jp.live2d.type_editor.LDColor;
import jp.live2d.type_editor.g;
import jp.noids.design.layer.core.AbstractLayer;
import jp.noids.design.layer.core.a;
import jp.noids.graphics.b;
import jp.noids.graphics.i;
import jp.noids.graphics.m;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class ShapeLayer
extends AbstractLayer {
    protected Shape shape;
    protected Paint fill = LDColor.RED;
    protected LDColor strokeColor = new LDColor(LDColor.black);
    protected float strokeWidth = 2.0f;
    transient boolean dirty = true;

    public ShapeLayer() {
    }

    public ShapeLayer(Shape shape) {
        this.shape = shape;
        this.dirty = true;
    }

    @Override
    protected boolean isDirty() {
        return this.dirty;
    }

    @Override
    protected boolean setupLayer() {
        if (this.shape == null) {
            this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
        } else {
            this.bounds.setRect(m.a(this.shape.getBounds2D(), (double)this.strokeWidth));
        }
        this.dirty = false;
        return true;
    }

    @Override
    public boolean contains(g g2) {
        if (this.shape == null) {
            return false;
        }
        if (!m.a(this.shape.getBounds2D(), (double)this.strokeWidth).contains(g2)) {
            return false;
        }
        if (this.fill != null && this.shape.contains(g2)) {
            return true;
        }
        return this.shape.intersects(new jp.live2d.type_editor.i(g2.x - (double)this.strokeWidth, g2.y - (double)this.strokeWidth, this.strokeWidth * 2.0f, this.strokeWidth * 2.0f));
    }

    @Override
    public Object deepClone() {
        ShapeLayer shapeLayer = new ShapeLayer();
        shapeLayer.init(this);
        return shapeLayer;
    }

    @Override
    public void init(Object object) {
        ShapeLayer shapeLayer = (ShapeLayer)object;
        super.init_(shapeLayer);
        this.shape = shapeLayer.shape == null ? null : m.b(shapeLayer.shape);
        this.fill = shapeLayer.fill;
        this.strokeColor = shapeLayer.strokeColor;
        this.strokeWidth = shapeLayer.strokeWidth;
    }

    @Override
    public void draw(a a2) {
        if (this.shape != null) {
            jp.noids.graphics.a a3 = a2.k();
            b b2 = i.d(a3);
            if (this.fill != null) {
                ((Graphics2D)a3).setPaint(this.fill);
                ((Graphics2D)a3).fill(this.shape);
            }
            if (this.strokeWidth > 0.0f) {
                ((Graphics2D)a3).setStroke(new BasicStroke(this.strokeWidth));
                ((Graphics)a3).setColor(this.strokeColor);
                ((Graphics2D)a3).draw(this.shape);
            }
            i.a((Graphics)a3, b2);
        }
    }

    @Override
    public void dump() {
        System.out.println("ShapeLayer");
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        super.read(g2, g2.b(element));
        this.shape = (Shape)g2.a(element, "shape");
        this.fill = (Paint)g2.a(element, "fill");
        this.strokeColor = (LDColor)g2.a(element, "strokeColor");
        this.strokeWidth = g2.d(element, "strokeWidth");
    }

    @Override
    public void write(l l2, Element element) {
        super.write(l2, l2.a(element));
        l2.a(element, "shape", this.shape);
        l2.a(element, "fill", this.fill);
        l2.a(element, "strokeColor", this.strokeColor);
        l2.a(element, "strokeWidth", this.strokeWidth);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.setDirty();
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public void setFillColor(LDColor lDColor) {
        this.fill = lDColor;
    }

    public LDColor getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(LDColor lDColor) {
        this.strokeColor = lDColor;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float f2) {
        this.strokeWidth = f2;
        this.setDirty();
    }

    public static ShapeLayer createSample() {
        ShapeLayer shapeLayer = new ShapeLayer(new jp.live2d.type_editor.i(10.0, 10.0, 100.0, 200.0));
        return shapeLayer;
    }
}

