/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.layer.core;

import a.e;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import jp.live2d.type_editor.LDColor;
import jp.live2d.type_editor.g;
import jp.noids.design.color.ColorXsParam;
import jp.noids.design.layer.core.AbstractLayer;
import jp.noids.design.layer.core.LayerRef;
import jp.noids.design.layer.core.a;
import jp.noids.framework.ID;
import jp.noids.framework.IParam;
import jp.noids.framework.IVarParam;
import jp.noids.framework.c;
import jp.noids.framework.param.FontVar;
import jp.noids.framework.param.ParamDouble;
import jp.noids.framework.param.TextVar;
import jp.noids.graphics.m;
import jp.noids.ui.l.b;
import jp.noids.util.N;
import jp.noids.util.aD;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class TextLayer
extends AbstractLayer
implements b {
    private static boolean DEBUG = false;
    public static final int ALIGN_LEFT_OR_TOP = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT_OR_BOTTOM = 2;
    public static final ID.Param PID_TEXTLAYER_TEXT;
    public static final ID.Param PID_TEXTLAYER_FONT;
    public static final ID.Param PID_TEXTLAYER_FILL_COLOR;
    public static final ID.Param PID_TEXTLAYER_STROKE_COLOR;
    public static final ID.Param PID_TEXTLAYER_STROKE_WIDTH;
    public static final ID.Param PID_TEXTLAYER_FONT_SIZE;
    public static final ID.Param PID_TEXTLAYER_LINE_FEED;
    public static final ID.Param PID_TEXTLAYER_VERTICAL;
    protected TextVar textVar = new TextVar(PID_TEXTLAYER_TEXT, "");
    protected FontVar fontVar = new FontVar(PID_TEXTLAYER_FONT, aD.a(20));
    protected float fontSize = 20.0f;
    protected Shape[] shapeFills = null;
    protected Shape[] shapeDraws = null;
    protected LDColor fillColor = new LDColor(LDColor.WHITE);
    protected LDColor drawColor = new LDColor(LDColor.BLACK);
    protected float strokeWidth = 2.0f;
    protected int cap = 2;
    protected int join = 0;
    protected float miterLimit = -1.0f;
    protected float lineFeed = 150.0f;
    protected boolean verticalLine = false;
    protected int textAlign = 1;
    public static TextVar lastTextVar_forTest;
    public static FontVar lastFontVar_forTest;
    transient long lastSetupTime = 0L;

    static {
        if (DEBUG) {
            System.out.println(" < DEBUG : jp.noids.design.layer.core.TextLayer > ");
        }
        PID_TEXTLAYER_TEXT = TextLayer.id("TextLayer_text", e.a("DESI-0112"));
        PID_TEXTLAYER_FONT = TextLayer.id("TextLayer_font", e.a("DESI-0103"));
        PID_TEXTLAYER_FILL_COLOR = TextLayer.id("TextLayer_fill", e.a("DESI-0113"));
        PID_TEXTLAYER_STROKE_COLOR = TextLayer.id("TextLayer_stroke", e.a("DESI-0114"));
        PID_TEXTLAYER_STROKE_WIDTH = TextLayer.id("TextLayer_width", e.a("DESI-0110"));
        PID_TEXTLAYER_FONT_SIZE = TextLayer.id("TextLayer_fontSize", e.a("DESI-0104"));
        PID_TEXTLAYER_LINE_FEED = TextLayer.id("TextLayer_lineFeed", e.a("DESI-0105"));
        PID_TEXTLAYER_VERTICAL = TextLayer.id("TextLayer_vertical", e.a("DESI-0115"));
        lastTextVar_forTest = new TextVar(PID_TEXTLAYER_TEXT, "");
        lastFontVar_forTest = new FontVar(PID_TEXTLAYER_FONT, aD.a(20));
    }

    static ID.Param id(String string, String string2) {
        ID.Param param = new ID.Param(string);
        c.a(param, string2);
        return param;
    }

    public TextLayer() {
        lastTextVar_forTest = this.textVar;
        lastFontVar_forTest = this.fontVar;
    }

    public int getCap() {
        return this.cap;
    }

    public void setCap(int n2) {
        this.cap = n2;
        this.setDirty();
    }

    public int getJoin() {
        return this.join;
    }

    public void setJoin(int n2) {
        this.join = n2;
        this.setDirty();
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float f2) {
        this.miterLimit = f2;
        this.setDirty();
    }

    @Override
    public void draw(a a2) {
        int n2;
        if (this.isDirty()) {
            this.setupLayer();
        }
        jp.noids.graphics.a a3 = a2.k();
        if (this.shapeDraws != null) {
            ((Graphics)a3).setColor(this.drawColor);
            n2 = 0;
            while (n2 < this.shapeDraws.length) {
                ((Graphics2D)a3).fill(this.shapeDraws[n2]);
                ++n2;
            }
        }
        if (this.shapeFills != null) {
            ((Graphics)a3).setColor(this.fillColor);
            n2 = 0;
            while (n2 < this.shapeFills.length) {
                ((Graphics2D)a3).fill(this.shapeFills[n2]);
                ++n2;
            }
        }
    }

    public void setText(String string) {
        if (this.textVar == null) {
            this.textVar = new TextVar();
        }
        this.textVar.setText(string);
        this.setDirty();
    }

    public String getText() {
        if (this.textVar == null) {
            return "";
        }
        return this.textVar.getText();
    }

    public void setFont(Font font) {
        this.fontVar.setFont(font.deriveFont(this.fontSize));
        this.setDirty();
    }

    public void initParam() {
        LayerRef layerRef = this.getLayerRef();
        if (layerRef != null) {
            this.setIfNull(layerRef, this.textVar);
            this.setIfNull(layerRef, this.fontVar);
            this.setIfNull(layerRef, new ColorXsParam(PID_TEXTLAYER_FILL_COLOR, this.fillColor));
            this.setIfNull(layerRef, new ColorXsParam(PID_TEXTLAYER_STROKE_COLOR, this.drawColor));
            this.setIfNull(layerRef, new ParamDouble(PID_TEXTLAYER_STROKE_WIDTH, this.strokeWidth, 0.0, 10.0));
            this.setIfNull(layerRef, new ParamDouble(PID_TEXTLAYER_FONT_SIZE, this.fontSize, 0.0, 10.0));
            this.setIfNull(layerRef, new ParamDouble(PID_TEXTLAYER_LINE_FEED, this.lineFeed, 10.0, 1000.0));
        }
    }

    public void setIfNull(LayerRef layerRef, IParam iParam) {
        ID.Param param = iParam.getID();
        if (layerRef.getParam(param) == null) {
            layerRef.setParam(param, iParam);
        }
    }

    @Override
    protected boolean setupLayer() {
        return this.setupLayer_exe();
    }

    protected boolean setupLayer_exe() {
        try {
            this.lastSetupTime = System.currentTimeMillis();
            this.initParam();
            Serializable serializable = this.getLayerRef();
            if (serializable != null) {
                this.fillColor = ((ColorXsParam)((LayerRef)serializable).getParam(PID_TEXTLAYER_FILL_COLOR)).getColor(null);
                this.drawColor = ((ColorXsParam)((LayerRef)serializable).getParam(PID_TEXTLAYER_STROKE_COLOR)).getColor(null);
                this.strokeWidth = (float)((ParamDouble)((LayerRef)serializable).getParam(PID_TEXTLAYER_STROKE_WIDTH)).getDouble();
                this.fontSize = (float)((ParamDouble)((LayerRef)serializable).getParam(PID_TEXTLAYER_FONT_SIZE)).getDouble();
                this.lineFeed = (float)((ParamDouble)((LayerRef)serializable).getParam(PID_TEXTLAYER_LINE_FEED)).getDouble();
            }
            serializable = this.fontVar.getFont().deriveFont(this.fontSize);
            float f2 = ((Font)serializable).getSize2D() * this.lineFeed * 0.01f;
            if (this.verticalLine) {
                jp.noids.design.b.a.b b2 = new jp.noids.design.b.a.b();
                b2.a(false);
                b2.a(f2);
                this.shapeFills = b2.a((Font)serializable, this.getText());
            } else {
                this.shapeFills = this.createTextShape((Font)serializable, this.getText(), f2);
            }
            if (this.strokeWidth > 0.0f) {
                float f3;
                float f4 = f3 = this.miterLimit >= 0.0f ? this.miterLimit : 2.0f;
                if (f3 < 1.0f) {
                    f3 = 1.0f;
                }
                BasicStroke basicStroke = new BasicStroke(this.strokeWidth, this.cap, this.join, f3);
                this.shapeDraws = new Shape[this.shapeFills.length];
                int n2 = 0;
                while (n2 < this.shapeDraws.length) {
                    this.shapeDraws[n2] = basicStroke.createStrokedShape(this.shapeFills[n2]);
                    ++n2;
                }
            }
            if (this.strokeWidth > 0.0f && this.shapeDraws != null) {
                this.bounds.setRect(m.a(this.shapeDraws));
            } else {
                this.bounds.setRect(m.a(this.shapeFills));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public Shape[] createTextShape(Font font, String string, float f2) {
        int n2 = 0;
        while (n2 < 10) {
            try {
                return this.createTextShape_exe(font, string, f2);
            }
            catch (Exception exception) {
                System.err.println("error at UtFont#createTextShape()");
                ++n2;
            }
        }
        return this.createTextShape_exe(font, string, f2);
    }

    public Shape[] createTextShape_exe(Font font, String string, float f2) {
        if (font == null) {
            throw new RuntimeException("Illegal State :_ font is null ");
        }
        String[] stringArray = string.split("\n");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        FontRenderContext fontRenderContext = new FontRenderContext((AffineTransform)new jp.live2d.type_editor.a(), true, true);
        GlyphVector[] glyphVectorArray = new GlyphVector[stringArray.length];
        Shape[] shapeArray = new Shape[stringArray.length];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[stringArray.length];
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            glyphVectorArray[n2] = font.layoutGlyphVector(fontRenderContext, string2.toCharArray(), 0, string2.length(), 0);
            rectangle2DArray[n2] = glyphVectorArray[n2].getLogicalBounds();
            if (rectangle2DArray[n2].getWidth() > d2) {
                d2 = rectangle2DArray[n2].getWidth();
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < stringArray.length) {
            Shape shape;
            float f3 = 0.0f;
            switch (this.textAlign) {
                default: {
                    f3 = 0.0f;
                    break;
                }
                case 1: {
                    f3 = (float)(-rectangle2DArray[n2].getWidth() / 2.0);
                    break;
                }
                case 2: {
                    f3 = (float)(-rectangle2DArray[n2].getWidth());
                }
            }
            float f4 = (float)n2 * f2;
            shapeArray[n2] = shape = glyphVectorArray[n2].getOutline(f3, f4);
            ++n2;
        }
        return shapeArray;
    }

    @Override
    public boolean contains(g g2) {
        int n2;
        if (this.isDirty()) {
            this.setupLayer();
        }
        if (this.shapeFills != null) {
            n2 = 0;
            while (n2 < this.shapeFills.length) {
                if (this.shapeFills[n2].contains(g2)) {
                    return true;
                }
                ++n2;
            }
        }
        if (this.shapeDraws != null) {
            n2 = 0;
            while (n2 < this.shapeDraws.length) {
                if (this.shapeDraws[n2].contains(g2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    protected boolean isDirty() {
        if (this.shapeFills == null && this.shapeDraws == null) {
            return true;
        }
        if (this.textVar != null && this.lastSetupTime < this.textVar.getLastModified()) {
            return true;
        }
        return this.fontVar != null && this.lastSetupTime < this.fontVar.getLastModified();
    }

    public static TextLayer createSample(String string) {
        return TextLayer.createSample(string, new LDColor(LDColor.ORANGE), new LDColor(LDColor.BLACK));
    }

    public static TextLayer createSample(String string, LDColor lDColor, LDColor lDColor2) {
        TextLayer textLayer = new TextLayer();
        textLayer.setText(string);
        textLayer.setFont(N.e(40));
        textLayer.setFontSize(40.0f);
        textLayer.setFillColor(lDColor);
        textLayer.setDrawColor(lDColor2);
        return textLayer;
    }

    @Override
    public void setDirty() {
        this.shapeFills = null;
        this.shapeDraws = null;
    }

    @Override
    public void dump() {
        System.out.println("TextLayer(" + this.create_no + ") [ " + this.getText() + " ]");
    }

    @Override
    public Object deepClone() {
        TextLayer textLayer = new TextLayer();
        textLayer.init(this);
        return textLayer;
    }

    @Override
    public TextLayer duplicate() {
        TextLayer textLayer = (TextLayer)this.deepClone();
        textLayer.textVar = new TextVar(this.getText());
        textLayer.fontVar = new FontVar(this.getFont());
        textLayer.setDirty();
        return textLayer;
    }

    @Override
    public void init(Object object) {
        TextLayer textLayer = (TextLayer)object;
        super.init_(textLayer);
        this.textVar = textLayer.textVar;
        this.fontVar = textLayer.fontVar;
        this.fontSize = textLayer.fontSize;
        this.shapeFills = textLayer.shapeFills;
        this.shapeDraws = textLayer.shapeDraws;
        this.fillColor = textLayer.fillColor;
        this.drawColor = textLayer.drawColor;
        this.strokeWidth = textLayer.strokeWidth;
        this.cap = textLayer.cap;
        this.join = textLayer.join;
        this.miterLimit = textLayer.miterLimit;
        this.lineFeed = textLayer.lineFeed;
        this.verticalLine = textLayer.verticalLine;
        this.textAlign = textLayer.textAlign;
    }

    public LDColor getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(LDColor lDColor) {
        this.drawColor = lDColor;
        LayerRef layerRef = this.getLayerRef();
        if (layerRef != null) {
            layerRef.setParam(PID_TEXTLAYER_STROKE_COLOR, new ColorXsParam(PID_TEXTLAYER_STROKE_COLOR, this.drawColor));
        }
        this.setDirty();
    }

    public LDColor getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(LDColor lDColor) {
        this.fillColor = lDColor;
        LayerRef layerRef = this.getLayerRef();
        if (layerRef != null) {
            layerRef.setParam(PID_TEXTLAYER_FILL_COLOR, new ColorXsParam(PID_TEXTLAYER_FILL_COLOR, this.fillColor));
        }
        this.setDirty();
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        Object object;
        super.read(g2, g2.b(element));
        int n2 = g2.a(element);
        if (n2 >= 1001) {
            this.textVar = (TextVar)g2.a(element, "textVar");
        } else {
            object = (String)g2.a(element, "text");
            this.textVar.setText((String)object);
        }
        if (n2 >= 1002) {
            this.fontVar = (FontVar)g2.a(element, "fontVar");
        } else {
            object = (Font)g2.a(element, "font");
            this.fontVar.setFont((Font)object);
        }
        this.fontSize = n2 >= 1003 ? g2.d(element, "fontSize") : this.fontVar.getFont().getSize2D();
        if (n2 >= 1004) {
            this.shapeFills = (Shape[])g2.a(element, "shapeFills");
            this.shapeDraws = (Shape[])g2.a(element, "shapeDraws");
        } else {
            Shape[] shapeArray;
            Shape[] shapeArray2;
            object = (Shape)g2.a(element, "shapeFill");
            Shape shape = (Shape)g2.a(element, "shapeDraw");
            if (object == null) {
                shapeArray2 = null;
            } else {
                Shape[] shapeArray3 = new Shape[1];
                shapeArray2 = shapeArray3;
                shapeArray3[0] = object;
            }
            this.shapeFills = shapeArray2;
            if (shape == null) {
                shapeArray = null;
            } else {
                Shape[] shapeArray4 = new Shape[1];
                shapeArray = shapeArray4;
                shapeArray4[0] = shape;
            }
            this.shapeDraws = shapeArray;
        }
        this.fillColor = (LDColor)g2.a(element, "fillColor");
        this.drawColor = (LDColor)g2.a(element, "drawColor");
        this.strokeWidth = g2.d(element, "strokeWidth");
        this.cap = g2.b(element, "cap");
        this.join = g2.b(element, "join");
        this.miterLimit = g2.d(element, "miterLimit");
        lastTextVar_forTest = this.textVar;
        lastFontVar_forTest = this.fontVar;
        if (n2 >= 1005) {
            this.lineFeed = g2.d(element, "lineFeed");
            this.verticalLine = g2.e(element, "verticalLine");
        } else {
            this.lineFeed = 150.0f;
            this.verticalLine = false;
        }
        this.textAlign = n2 >= 1006 ? g2.b(element, "textAlign") : 0;
    }

    @Override
    public void write(l l2, Element element) {
        super.write(l2, l2.a(element));
        l2.a(element, 1006);
        l2.a(element, "textVar", this.textVar);
        l2.a(element, "fontVar", this.fontVar);
        l2.a(element, "fontSize", this.fontSize);
        l2.a(element, "shapeFills", this.shapeFills);
        l2.a(element, "shapeDraws", this.shapeDraws);
        l2.a(element, "fillColor", this.fillColor);
        l2.a(element, "drawColor", this.drawColor);
        l2.a(element, "strokeWidth", this.strokeWidth);
        l2.a(element, "cap", this.cap);
        l2.a(element, "join", this.join);
        l2.a(element, "miterLimit", this.miterLimit);
        l2.a(element, "lineFeed", this.lineFeed);
        l2.a(element, "verticalLine", this.verticalLine);
        l2.a(element, "textAlign", this.textAlign);
    }

    public IVarParam[] getVarParam() {
        return new IVarParam[]{this.textVar, this.fontVar};
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f2) {
        this.fontSize = f2;
        LayerRef layerRef = this.getLayerRef();
        if (layerRef != null) {
            layerRef.setParam(PID_TEXTLAYER_FONT_SIZE, new ParamDouble(PID_TEXTLAYER_FONT_SIZE, this.fontSize, 0.0, 10.0));
        }
        this.setDirty();
    }

    public Font getFont() {
        return this.fontVar.getFont().deriveFont(this.fontSize);
    }

    public float getLineFeed() {
        return this.lineFeed;
    }

    public void setLineFeed(float f2) {
        this.lineFeed = f2;
        LayerRef layerRef = this.getLayerRef();
        if (layerRef != null) {
            layerRef.setParam(PID_TEXTLAYER_LINE_FEED, new ParamDouble(PID_TEXTLAYER_LINE_FEED, this.lineFeed));
        }
        this.setDirty();
    }

    public boolean isVerticalLine() {
        return this.verticalLine;
    }

    public void setVerticalLine(boolean bl2) {
        this.verticalLine = bl2;
        this.setDirty();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float f2) {
        this.strokeWidth = f2;
        LayerRef layerRef = this.getLayerRef();
        if (layerRef != null) {
            layerRef.setParam(PID_TEXTLAYER_STROKE_WIDTH, new ParamDouble(PID_TEXTLAYER_STROKE_WIDTH, this.strokeWidth));
        }
        this.setDirty();
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int n2) {
        this.textAlign = n2;
        this.setDirty();
    }
}

