/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.morph.simple;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JFrame;
import jp.live2d.type_editor.i;
import jp.live2d.type_editor.image.LDImage;
import jp.noids.design.morph.simple.Patch;
import jp.noids.design.morph.simple.e;
import jp.noids.design.morph.simple.f;
import jp.noids.design.morph.simple.g;
import jp.noids.design.morph.simple.h;
import jp.noids.framework.property.E;
import jp.noids.framework.property.H;
import jp.noids.graphics.geom.Vector2d;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.util.C;
import jp.noids.util.L;
import jp.noids.util.O;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BasicMorph
implements IInterpolatable {
    static boolean DUMP = false;
    static int MAX_POLYGON_TO_PATCH = 1000;
    static boolean CHECK_ANGLE_DISABLED = false;
    MoPoint[] points = new MoPoint[0];
    MoLine[] lines = new MoLine[0];
    MoCtrlPoint[] ctrlPoints = new MoCtrlPoint[0];
    int[][] polygons = new int[0][];
    boolean isStaticPolygon_ = false;
    transient Patch[] patch = new Patch[0];
    transient boolean dirtyPatch = true;
    transient boolean dirtyPolygon = true;
    transient boolean dirtyBounds = true;
    transient boolean dirtyCtrlPoint = true;
    transient i bounds = null;
    static final boolean CW_PATCH = true;
    static final double PI2 = Math.PI * 2;

    static {
        H h2 = H.e();
        h2.a(new E(a.e.a("DESI-0133"), 8, 5, 1000, new jp.noids.design.morph.simple.a()));
    }

    public boolean isCrossing(jp.live2d.type_editor.g g2, jp.live2d.type_editor.g g3, MoLine moLine) {
        int n2 = g2 instanceof MoPoint ? ((MoPoint)g2).getIndex() : -1;
        int n3 = g3 instanceof MoPoint ? ((MoPoint)g3).getIndex() : -1;
        int n4 = moLine == null ? -1 : moLine.getIndex();
        int n5 = 0;
        while (n5 < this.lines.length) {
            if (n5 != n4) {
                int n6 = this.lines[n5].index1;
                int n7 = this.lines[n5].index2;
                if (n2 != n6 && n2 != n7 && n3 != n6 && n3 != n7) {
                    MoPoint moPoint = this.points[this.lines[n5].index1];
                    MoPoint moPoint2 = this.points[this.lines[n5].index2];
                    if (!(Math.min(g2.x, g3.x) > Math.max(moPoint.x, moPoint2.x)) && !(Math.min(g2.y, g3.y) > Math.max(moPoint.y, moPoint2.y)) && !(Math.min(moPoint.x, moPoint2.x) > Math.max(g2.x, g3.x)) && !(Math.min(moPoint.y, moPoint2.y) > Math.max(g2.y, g3.y)) && ((g2.x - g3.x) * (moPoint.y - g2.y) + (g2.y - g3.y) * (g2.x - moPoint.x)) * ((g2.x - g3.x) * (moPoint2.y - g2.y) + (g2.y - g3.y) * (g2.x - moPoint2.x)) <= 0.0 && ((moPoint.x - moPoint2.x) * (g2.y - moPoint.y) + (moPoint.y - moPoint2.y) * (moPoint.x - g2.x)) * ((moPoint.x - moPoint2.x) * (g3.y - moPoint.y) + (moPoint.y - moPoint2.y) * (moPoint.x - g3.x)) <= 0.0) {
                        return true;
                    }
                }
            }
            ++n5;
        }
        return false;
    }

    public boolean isStaticPolygon() {
        return this.isStaticPolygon_;
    }

    public void setStaticPolygon(boolean bl2) {
        this.isStaticPolygon_ = bl2;
    }

    public void setDirty() {
        this.dirtyPolygon = true;
        this.dirtyPatch = true;
        this.dirtyBounds = true;
        this.dirtyCtrlPoint = true;
    }

    public void removeAllLine() {
        this.lines = new MoLine[0];
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
    }

    public void dump() {
        System.out.println("points ------------");
        int n2 = 0;
        while (n2 < this.points.length) {
            System.out.println(L.a(this.points[n2]));
            ++n2;
        }
        System.out.println("lines ------------");
        n2 = 0;
        while (n2 < this.lines.length) {
            System.out.println(String.valueOf(this.lines[n2].index1) + "=>" + this.lines[n2].index2);
            ++n2;
        }
    }

    public BasicMorph createTransformed(ITransform iTransform, int n2) {
        try {
            BasicMorph basicMorph = this.deepClone();
            if (!iTransform.isIdentity()) {
                basicMorph.transform(iTransform, n2);
            }
            return basicMorph;
        }
        catch (jp.noids.ui.l.f f2) {
            f2.printStackTrace();
            throw new jp.noids.graphics.transform.a(f2);
        }
    }

    public void transform(ITransform iTransform, int n2) {
        if (!this.isStaticPolygon_) {
            if (this.dirtyPolygon) {
                this.updatePolygon_();
            }
        } else if (this.patch == null && C.e()) {
            throw new RuntimeException("Illegal State : patch is null ");
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        if (this.patch.length == 0) {
            return;
        }
        this.patch[0] = this.patch[0].createTransformed(iTransform, n2);
        int n3 = 1;
        while (n3 < this.patch.length) {
            this.patch[n3] = this.patch[n3].createTransformed(iTransform, n2);
            ++n3;
        }
        iTransform.transform(this.points, 0, this.points, 0, this.points.length);
        this.dirtyBounds = true;
    }

    public boolean contains(jp.live2d.type_editor.g g2) {
        Patch[] patchArray = this.getPatchListRef();
        int n2 = 0;
        while (n2 < patchArray.length) {
            if (patchArray[n2].contains(g2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public BasicMorph deepClone() {
        BasicMorph basicMorph = new BasicMorph();
        basicMorph.init(this);
        if (!basicMorph.verifyInnerObjectAndCorrect() && C.e()) {
            throw new RuntimeException("Illegal State : ");
        }
        return basicMorph;
    }

    @Override
    public void init(Object object) {
        BasicMorph basicMorph = (BasicMorph)object;
        this.points = (MoPoint[])jp.noids.graphics.interpolate.b.a(basicMorph.points, this);
        this.lines = (MoLine[])jp.noids.graphics.interpolate.b.a(basicMorph.lines, this);
        this.isStaticPolygon_ = basicMorph.isStaticPolygon_;
        if (this.isStaticPolygon_) {
            if (basicMorph.polygons == null) {
                this.polygons = null;
            } else {
                this.polygons = new int[basicMorph.polygons.length][];
                int n2 = 0;
                while (n2 < this.polygons.length) {
                    this.polygons[n2] = jp.noids.util.c.a(basicMorph.polygons[n2]);
                    ++n2;
                }
            }
            this.dirtyPolygon = basicMorph.dirtyPolygon;
            this.dirtyPatch = true;
            this.dirtyBounds = true;
        } else {
            if (basicMorph.dirtyPolygon) {
                basicMorph.updatePolygon_();
            }
            if (this.polygons != null) {
                this.polygons = new int[basicMorph.polygons.length][];
                int n3 = 0;
                while (n3 < basicMorph.polygons.length) {
                    this.polygons[n3] = jp.noids.util.c.a(basicMorph.polygons[n3]);
                    ++n3;
                }
            } else {
                this.polygons = null;
            }
            this.dirtyPolygon = false;
            this.dirtyPatch = true;
            this.dirtyBounds = true;
        }
    }

    public boolean canInterpolate(BasicMorph basicMorph) {
        if (!(basicMorph instanceof BasicMorph)) {
            return false;
        }
        BasicMorph basicMorph2 = basicMorph;
        if (this.points.length != basicMorph2.points.length) {
            return false;
        }
        return this.lines.length == basicMorph2.lines.length;
    }

    public void initTopology(BasicMorph basicMorph) {
        this.lines = (MoLine[])jp.noids.graphics.interpolate.b.a(basicMorph.lines, this);
        if (basicMorph.polygons == null) {
            this.polygons = null;
        } else {
            this.polygons = new int[basicMorph.polygons.length][];
            int n2 = 0;
            while (n2 < this.polygons.length) {
                this.polygons[n2] = jp.noids.util.c.a(basicMorph.polygons[n2]);
                ++n2;
            }
        }
        this.dirtyPolygon = basicMorph.dirtyPolygon;
        this.dirtyPatch = true;
        this.dirtyBounds = true;
    }

    public int[][] getPolygons() {
        if (!this.isStaticPolygon_ && this.dirtyPolygon) {
            this.updatePolygon_();
        }
        return this.polygons;
    }

    public MoLine getNearestLineRef(jp.live2d.type_editor.g g2, jp.live2d.type_editor.g g3) {
        MoPoint moPoint;
        MoPoint moPoint2;
        if (this.points == null || this.lines == null) {
            return null;
        }
        double d2 = Double.MAX_VALUE;
        int n2 = -1;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        int n3 = 0;
        while (n3 < this.lines.length) {
            double d3;
            MoLine moLine = this.lines[n3];
            moPoint2 = this.points[moLine.index1];
            moPoint = this.points[moLine.index2];
            Vector2d vector2d = new Vector2d((jp.live2d.type_editor.g)moPoint2, (jp.live2d.type_editor.g)moPoint);
            Vector2d vector2d2 = vector2d.norm_new();
            jp.noids.graphics.geom.c.a(g2.x, g2.y, (jp.live2d.type_editor.g)moPoint2, vector2d, vector2d2, dArray2);
            if (0.0 <= dArray2[0] && dArray2[0] <= 1.0) {
                d3 = vector2d2.getDistance() * dArray2[1];
                d3 *= d3;
            } else {
                d3 = dArray2[0] < 0.0 ? m.b((jp.live2d.type_editor.g)moPoint2, g2) : m.b((jp.live2d.type_editor.g)moPoint, g2);
            }
            if (d3 < d2) {
                d2 = d3;
                n2 = n3;
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        double d4 = dArray[0];
        moPoint2 = this.points[this.lines[n2].index1];
        moPoint = this.points[this.lines[n2].index2];
        if (0.0 <= d4 && d4 <= 1.0) {
            g3.x = moPoint2.x + (moPoint.x - moPoint2.x) * d4;
            g3.y = moPoint2.y + (moPoint.y - moPoint2.y) * d4;
        } else if (d4 < 0.0) {
            g3.x = moPoint2.x;
            g3.y = moPoint2.y;
        } else {
            g3.x = moPoint.x;
            g3.y = moPoint.y;
        }
        return this.lines[n2];
    }

    public MoCtrlPoint getNearestCtrlPointRef(jp.live2d.type_editor.g g2) {
        if (this.ctrlPoints == null) {
            return null;
        }
        double d2 = Double.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.ctrlPoints.length) {
            MoCtrlPoint moCtrlPoint = this.ctrlPoints[n3];
            double d3 = (moCtrlPoint.x - g2.x) * (moCtrlPoint.x - g2.x) + (moCtrlPoint.y - g2.y) * (moCtrlPoint.y - g2.y);
            if (d3 < d2) {
                d2 = d3;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        return this.ctrlPoints[n2];
    }

    public MoPoint getNearestPointRef(jp.live2d.type_editor.g g2) {
        if (this.points == null) {
            return null;
        }
        double d2 = Double.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.points.length) {
            MoPoint moPoint = this.points[n3];
            double d3 = (moPoint.x - g2.x) * (moPoint.x - g2.x) + (moPoint.y - g2.y) * (moPoint.y - g2.y);
            if (d3 < d2) {
                d2 = d3;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        return this.points[n2];
    }

    public MoPoint getCompatiblePointRef(jp.noids.graphics.c.b b2) {
        if (this.points == null) {
            return null;
        }
        if (!(b2 instanceof MoPoint)) {
            throw new RuntimeException("Illegal State : ");
        }
        MoPoint moPoint = (MoPoint)b2;
        int n2 = moPoint.getIndex();
        if (n2 < 0 || this.points.length <= n2) {
            return null;
        }
        return this.points[n2];
    }

    public MoCtrlPoint getCompatibleCtrlPointRef(MoCtrlPoint moCtrlPoint) {
        if (this.ctrlPoints == null) {
            return null;
        }
        if (!(moCtrlPoint instanceof MoCtrlPoint)) {
            throw new RuntimeException("Illegal State : ");
        }
        MoCtrlPoint moCtrlPoint2 = moCtrlPoint;
        int n2 = moCtrlPoint2.getIndex();
        if (n2 < 0 || this.ctrlPoints.length <= n2) {
            return null;
        }
        return this.ctrlPoints[n2];
    }

    public MoLine getCompatibleLineRef(MoLine moLine) {
        try {
            int n2 = moLine.getIndex();
            return this.lines[n2];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            int n3 = moLine.getIndex();
            return this.lines[n3];
        }
    }

    public MoPoint[] getAllPointRef() {
        return this.points;
    }

    public MoLine[] getLineListRef() {
        return this.lines;
    }

    public MoLine getLineRef(int n2, int n3) {
        int n4 = 0;
        while (n4 < this.lines.length) {
            MoLine moLine = this.lines[n4];
            if (moLine.index1 == n2 && moLine.index2 == n3) {
                return moLine;
            }
            if (moLine.index1 == n3 && moLine.index2 == n2) {
                return moLine;
            }
            ++n4;
        }
        return null;
    }

    public MoCtrlPoint[] getCtrlPointListRef() {
        return this.ctrlPoints;
    }

    public MoPoint[] getPointListRef() {
        return this.points;
    }

    public int getPointCount() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length;
    }

    public MoLine addLine(MoPoint moPoint, MoPoint moPoint2) {
        if (moPoint == null || moPoint2 == null) {
            return null;
        }
        int n2 = moPoint.getIndex();
        int n3 = moPoint2.getIndex();
        int n4 = 0;
        while (n4 < this.lines.length) {
            if (this.lines[n4].isUsing(n2) && this.lines[n4].isUsing(n3)) {
                return this.lines[n4];
            }
            ++n4;
        }
        MoLine moLine = new MoLine(n2, n3);
        this.lines = (MoLine[])jp.noids.util.c.c(this.lines, moLine);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
        return moLine;
    }

    public void removeLine(MoLine moLine) {
        int n2 = moLine.getIndex();
        this.lines[n2].setDeleted(true);
        this.lines = (MoLine[])jp.noids.util.c.a((Object[])this.lines, n2);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
    }

    public MoPoint addPoint(double d2, double d3) {
        MoPoint moPoint = new MoPoint(d2, d3);
        this.points = (MoPoint[])jp.noids.util.c.c(this.points, moPoint);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
        return moPoint;
    }

    public void removePoint(MoPoint moPoint) {
        int n2 = moPoint.getIndex();
        ArrayList<MoLine> arrayList = new ArrayList<MoLine>();
        int n3 = 0;
        while (n3 < this.lines.length) {
            if (!this.lines[n3].isUsing(n2)) {
                if (this.lines[n3].index1 > n2) {
                    --this.lines[n3].index1;
                }
                if (this.lines[n3].index2 > n2) {
                    --this.lines[n3].index2;
                }
                arrayList.add(this.lines[n3]);
            }
            ++n3;
        }
        this.lines = arrayList.toArray(new MoLine[arrayList.size()]);
        this.points = (MoPoint[])jp.noids.util.c.a((Object[])this.points, n2);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
    }

    public MoCtrlPoint addCtrlPoint(float f2, float f3) {
        MoCtrlPoint moCtrlPoint = new MoCtrlPoint(f2, f3);
        this.ctrlPoints = (MoCtrlPoint[])jp.noids.util.c.c(this.ctrlPoints, moCtrlPoint);
        return moCtrlPoint;
    }

    public void removeCtrlPoint(MoCtrlPoint moCtrlPoint) {
        int n2 = moCtrlPoint.getIndex();
        this.ctrlPoints = (MoCtrlPoint[])jp.noids.util.c.a((Object[])this.ctrlPoints, n2);
    }

    public i getBoundsRect() {
        if (!this.isStaticPolygon_ && this.dirtyPolygon) {
            this.updatePolygon_();
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        if (this.dirtyBounds) {
            this.updateBounds();
        }
        return this.bounds;
    }

    private void updateBounds() {
        this.bounds = new i();
        if (this.points.length < 1) {
            return;
        }
        this.bounds.setRect(this.points[0].x, this.points[0].y, 0.0, 0.0);
        int n2 = 1;
        while (n2 < this.points.length) {
            this.bounds.a(this.points[n2]);
            ++n2;
        }
        this.dirtyBounds = false;
    }

    public Patch[] getPatchListRef() {
        if (!this.isStaticPolygon_) {
            if (this.dirtyPolygon) {
                this.updatePolygon_();
            }
        } else if (this.patch == null && C.e()) {
            throw new RuntimeException("Illegal State : patch is null ");
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        return this.patch;
    }

    public Patch getPatch(int n2) {
        if (!this.isStaticPolygon_) {
            if (this.dirtyPolygon) {
                this.updatePolygon_();
            }
        } else if (this.patch == null && C.e()) {
            throw new RuntimeException("Illegal State : patch is null ");
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        return this.patch[n2];
    }

    void updatePolygon_() {
        g.a(this);
    }

    public void updateStaticPolygon() {
        this.updatePolygon_();
        this.updatePatch();
    }

    private void updatePatch() {
        if (this.lines == null) {
            return;
        }
        if (this.polygons == null) {
            throw new RuntimeException(a.e.a("DESI-0134"));
        }
        this.patch = new Patch[this.polygons.length];
        int n2 = 0;
        while (n2 < this.polygons.length) {
            Patch patch;
            int[] nArray = this.polygons[n2];
            if (nArray.length != 3) {
                throw new RuntimeException("Illegal State : " + nArray.length);
            }
            this.patch[n2] = patch = new Patch(this.points[nArray[0]], this.points[nArray[1]], this.points[nArray[2]]);
            ++n2;
        }
        this.dirtyPatch = false;
        this.dirtyBounds = true;
    }

    private void updateCtrlPoint() {
    }

    private static double normalizeTo2PI(double d2) {
        while (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        while (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    private static double normalizeToPI(double d2) {
        while (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        while (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    static int r360(double d2) {
        return (int)(180.0 * d2 / Math.PI);
    }

    public static BasicMorph createSample(float f2) {
        BasicMorph basicMorph = new BasicMorph();
        f2 = (float)((double)f2 * 0.005);
        MoPoint[] moPointArray = new MoPoint[7];
        BasicMorph basicMorph2 = basicMorph;
        basicMorph2.getClass();
        moPointArray[0] = basicMorph2.new MoPoint(10.0f * f2, 10.0f * f2);
        BasicMorph basicMorph3 = basicMorph;
        basicMorph3.getClass();
        moPointArray[1] = basicMorph3.new MoPoint(100.0f * f2, 10.0f * f2);
        BasicMorph basicMorph4 = basicMorph;
        basicMorph4.getClass();
        moPointArray[2] = basicMorph4.new MoPoint(70.0f * f2, 70.0f * f2);
        BasicMorph basicMorph5 = basicMorph;
        basicMorph5.getClass();
        moPointArray[3] = basicMorph5.new MoPoint(150.0f * f2, 70.0f * f2);
        BasicMorph basicMorph6 = basicMorph;
        basicMorph6.getClass();
        moPointArray[4] = basicMorph6.new MoPoint(5.0f * f2, 110.0f * f2);
        BasicMorph basicMorph7 = basicMorph;
        basicMorph7.getClass();
        moPointArray[5] = basicMorph7.new MoPoint(60.0f * f2, 130.0f * f2);
        BasicMorph basicMorph8 = basicMorph;
        basicMorph8.getClass();
        moPointArray[6] = basicMorph8.new MoPoint(120.0f * f2, 120.0f * f2);
        basicMorph.points = moPointArray;
        MoLine[] moLineArray = new MoLine[12];
        BasicMorph basicMorph9 = basicMorph;
        basicMorph9.getClass();
        moLineArray[0] = basicMorph9.new MoLine(0, 1);
        BasicMorph basicMorph10 = basicMorph;
        basicMorph10.getClass();
        moLineArray[1] = basicMorph10.new MoLine(1, 3);
        BasicMorph basicMorph11 = basicMorph;
        basicMorph11.getClass();
        moLineArray[2] = basicMorph11.new MoLine(3, 6);
        BasicMorph basicMorph12 = basicMorph;
        basicMorph12.getClass();
        moLineArray[3] = basicMorph12.new MoLine(6, 5);
        BasicMorph basicMorph13 = basicMorph;
        basicMorph13.getClass();
        moLineArray[4] = basicMorph13.new MoLine(5, 4);
        BasicMorph basicMorph14 = basicMorph;
        basicMorph14.getClass();
        moLineArray[5] = basicMorph14.new MoLine(4, 0);
        BasicMorph basicMorph15 = basicMorph;
        basicMorph15.getClass();
        moLineArray[6] = basicMorph15.new MoLine(0, 2);
        BasicMorph basicMorph16 = basicMorph;
        basicMorph16.getClass();
        moLineArray[7] = basicMorph16.new MoLine(2, 4);
        BasicMorph basicMorph17 = basicMorph;
        basicMorph17.getClass();
        moLineArray[8] = basicMorph17.new MoLine(2, 3);
        BasicMorph basicMorph18 = basicMorph;
        basicMorph18.getClass();
        moLineArray[9] = basicMorph18.new MoLine(3, 5);
        BasicMorph basicMorph19 = basicMorph;
        basicMorph19.getClass();
        moLineArray[10] = basicMorph19.new MoLine(2, 5);
        BasicMorph basicMorph20 = basicMorph;
        basicMorph20.getClass();
        moLineArray[11] = basicMorph20.new MoLine(2, 1);
        basicMorph.lines = moLineArray;
        return basicMorph;
    }

    public static BasicMorph createBoxMorph(i i2) {
        return BasicMorph.createBoxMorph(i2, false, false);
    }

    public static BasicMorph createBoxMorph(i i2, boolean bl2, boolean bl3) {
        BasicMorph basicMorph = new BasicMorph();
        float f2 = (float)(bl2 ? i2.getMaxX() : i2.getMinX());
        float f3 = (float)(bl2 ? i2.getMinX() : i2.getMaxX());
        float f4 = (float)(bl3 ? i2.getMaxY() : i2.getMinY());
        float f5 = (float)(bl3 ? i2.getMinY() : i2.getMaxY());
        MoPoint[] moPointArray = new MoPoint[4];
        BasicMorph basicMorph2 = basicMorph;
        basicMorph2.getClass();
        moPointArray[0] = basicMorph2.new MoPoint(f2, f4);
        BasicMorph basicMorph3 = basicMorph;
        basicMorph3.getClass();
        moPointArray[1] = basicMorph3.new MoPoint(f3, f4);
        BasicMorph basicMorph4 = basicMorph;
        basicMorph4.getClass();
        moPointArray[2] = basicMorph4.new MoPoint(f3, f5);
        BasicMorph basicMorph5 = basicMorph;
        basicMorph5.getClass();
        moPointArray[3] = basicMorph5.new MoPoint(f2, f5);
        basicMorph.points = moPointArray;
        MoLine[] moLineArray = new MoLine[5];
        BasicMorph basicMorph6 = basicMorph;
        basicMorph6.getClass();
        moLineArray[0] = basicMorph6.new MoLine(0, 1);
        BasicMorph basicMorph7 = basicMorph;
        basicMorph7.getClass();
        moLineArray[1] = basicMorph7.new MoLine(1, 2);
        BasicMorph basicMorph8 = basicMorph;
        basicMorph8.getClass();
        moLineArray[2] = basicMorph8.new MoLine(2, 3);
        BasicMorph basicMorph9 = basicMorph;
        basicMorph9.getClass();
        moLineArray[3] = basicMorph9.new MoLine(3, 0);
        BasicMorph basicMorph10 = basicMorph;
        basicMorph10.getClass();
        moLineArray[4] = basicMorph10.new MoLine(0, 2);
        basicMorph.lines = moLineArray;
        return basicMorph;
    }

    public static void main(String[] stringArray) {
        BasicMorph basicMorph = BasicMorph.createSample(200.0f);
        JFrame jFrame = O.a("jp.noids.design.morph.simple.BasicMorph", a.e.a("DESI-0000"), 800, 600, true);
        Container container = jFrame.getContentPane();
        jp.noids.design.morph.simple.b b2 = new jp.noids.design.morph.simple.b(basicMorph);
        JButton jButton = new JButton("auto1");
        jButton.addActionListener(new jp.noids.design.morph.simple.c(basicMorph, jFrame));
        b2.add(jButton);
        JButton jButton2 = new JButton("auto2");
        jButton2.addActionListener(new jp.noids.design.morph.simple.d(basicMorph, jFrame));
        b2.add(jButton2);
        JButton jButton3 = new JButton("clear");
        jButton3.addActionListener(new e(basicMorph, jFrame));
        b2.add(jButton3);
        b2.addMouseListener(new f(basicMorph, jFrame));
        container.add(b2);
        jFrame.setVisible(true);
        basicMorph.updatePolygon_();
        basicMorph.updatePatch();
    }

    public void triangulation(boolean bl2, LDImage lDImage, boolean bl3, jp.noids.framework.e.c c2) {
        c2 = jp.noids.framework.e.e.a(c2);
        h h2 = new h();
        h2.a(this.points);
        h2.a(this.lines, bl2, bl3);
        this.removeAllLine();
        h2.a(c2);
        MoLine[] moLineArray = h2.a(this, lDImage, bl3);
        int n2 = 0;
        while (n2 < moLineArray.length) {
            MoLine moLine = moLineArray[n2];
            this.addLine(this.points[moLine.index1], this.points[moLine.index2]);
            ++n2;
        }
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        BasicMorph basicMorph = (BasicMorph)iInterpolatable;
        BasicMorph basicMorph2 = new BasicMorph();
        basicMorph2.points = (MoPoint[])jp.noids.graphics.interpolate.b.a(this.points, basicMorph.points, d2, basicMorph2);
        basicMorph2.lines = (MoLine[])jp.noids.graphics.interpolate.b.a(this.lines, basicMorph.lines, d2, basicMorph2);
        basicMorph2.polygons = new int[this.polygons.length][];
        int n2 = 0;
        while (n2 < this.polygons.length) {
            basicMorph2.polygons[n2] = jp.noids.util.c.a(this.polygons[n2]);
            ++n2;
        }
        basicMorph2.isStaticPolygon_ = this.isStaticPolygon_ & basicMorph.isStaticPolygon_;
        if (!basicMorph2.verifyInnerObjectAndCorrect() && C.e()) {
            throw new RuntimeException("Illegal State : ");
        }
        return basicMorph2;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        int n2 = g2.a(element);
        if (n2 < 1002) {
            this.points = (MoPoint[])g2.a(element, "points");
            this.lines = (MoLine[])g2.a(element, "lines");
            this.polygons = (int[][])g2.a(element, "polygons");
        } else {
            Object[] objectArray = (float[])g2.a(element, "f_points");
            int n3 = objectArray.length / 2;
            this.points = new MoPoint[n3];
            int n4 = -1;
            int n5 = 0;
            while (n5 < n3) {
                this.points[n5] = new MoPoint(objectArray[++n4], objectArray[++n4]);
                ++n5;
            }
            objectArray = (int[])g2.a(element, "i_lines");
            n3 = objectArray.length / 2;
            this.lines = new MoLine[n3];
            n4 = -1;
            n5 = 0;
            while (n5 < n3) {
                this.lines[n5] = new MoLine((int)objectArray[++n4], (int)objectArray[++n4]);
                ++n5;
            }
            objectArray = (int[])g2.a(element, "i_polygons");
            if (objectArray == null) {
                this.polygons = null;
            } else {
                n3 = objectArray.length / 3;
                this.polygons = new int[n3][];
                n4 = -1;
                n5 = 0;
                while (n5 < n3) {
                    this.polygons[n5] = new int[]{(int)objectArray[++n4], (int)objectArray[++n4], (int)objectArray[++n4]};
                    ++n5;
                }
            }
        }
        if (n2 >= 1001) {
            this.isStaticPolygon_ = g2.e(element, "isStaticPolygon");
            this.dirtyPolygon = false;
        } else {
            this.isStaticPolygon_ = false;
            this.dirtyPolygon = true;
        }
        this.dirtyPatch = true;
        this.dirtyBounds = true;
    }

    @Override
    public void write(l l2, Element element) {
        if (!this.isStaticPolygon_ && this.dirtyPolygon) {
            this.updatePolygon_();
        }
        this.verifyInnerObjectAndCorrect();
        int n2 = 1002;
        l2.a(element, n2);
        if (n2 < 1002) {
            l2.a(element, "points", this.points);
            l2.a(element, "lines", this.lines);
            l2.a(element, "polygons", this.polygons);
        } else {
            int n3 = this.points.length;
            Object[] objectArray = new float[n3 * 2];
            int n4 = -1;
            int n5 = 0;
            while (n5 < n3) {
                objectArray[++n4] = (float)this.points[n5].x;
                objectArray[++n4] = (float)this.points[n5].y;
                ++n5;
            }
            l2.a(element, "f_points", objectArray);
            n3 = this.lines.length;
            objectArray = new int[n3 * 2];
            n4 = -1;
            n5 = 0;
            while (n5 < n3) {
                objectArray[++n4] = this.lines[n5].index1;
                objectArray[++n4] = this.lines[n5].index2;
                ++n5;
            }
            l2.a(element, "i_lines", objectArray);
            if (this.polygons == null) {
                l2.a(element, "i_polygons", null);
            } else {
                n3 = this.polygons.length;
                objectArray = new int[n3 * 3];
                n4 = -1;
                n5 = 0;
                while (n5 < n3) {
                    int[] nArray = this.polygons[n5];
                    objectArray[++n4] = nArray[0];
                    objectArray[++n4] = nArray[1];
                    objectArray[++n4] = nArray[2];
                    ++n5;
                }
                l2.a(element, "i_polygons", objectArray);
            }
        }
        l2.a(element, "isStaticPolygon", this.isStaticPolygon_);
    }

    private boolean verifyInnerObjectAndCorrect() {
        boolean bl2 = true;
        try {
            IInterpolatable iInterpolatable;
            int n2 = 0;
            while (n2 < this.points.length) {
                if (this.points[n2].getOwner() != this) {
                    bl2 = false;
                    iInterpolatable = new MoPoint();
                    ((MoPoint)iInterpolatable).init(this.points[n2]);
                    this.points[n2] = iInterpolatable;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.lines.length) {
                if (this.lines[n2].getOwner() != this) {
                    bl2 = false;
                    iInterpolatable = new MoLine();
                    ((MoLine)iInterpolatable).init(this.lines[n2]);
                    this.lines[n2] = iInterpolatable;
                }
                ++n2;
            }
        }
        catch (jp.noids.ui.l.f f2) {
            f2.printStackTrace();
        }
        return bl2;
    }

    public b getTopologyDef(double d2, double d3) {
        int n2;
        jp.live2d.type_editor.g g2;
        Object object;
        int n3;
        jp.live2d.type_editor.g g3;
        Vector2d vector2d;
        int n4;
        jp.live2d.type_editor.g g4;
        Object object2;
        jp.live2d.type_editor.g g5 = new jp.live2d.type_editor.g(d2, d3);
        Patch[] patchArray = this.getPatchListRef();
        int[][] nArray = this.getPolygons();
        int n5 = -1;
        int n6 = 0;
        while (n6 < patchArray.length) {
            if (patchArray[n6].contains(g5) && (object2 = jp.noids.graphics.geom.c.a(g5, g4 = new jp.live2d.type_editor.g(this.points[n4 = nArray[n6][0]]), vector2d = new Vector2d(g4, g3 = new jp.live2d.type_editor.g(this.points[n3 = nArray[n6][1]])), (Vector2d)(object = new Vector2d(g4, g2 = new jp.live2d.type_editor.g(this.points[n2 = nArray[n6][2]]))))) != null) {
                b b2 = new b(d2, d3, n4, n3, n2, (float)object2[0], (float)object2[1]);
                return b2;
            }
            ++n6;
        }
        ArrayList<a> arrayList = new ArrayList<a>();
        n4 = 0;
        while (n4 < this.points.length) {
            double d4 = m.b((jp.live2d.type_editor.g)this.points[n4], g5);
            if (d4 > 0.0) {
                arrayList.add(new a(d4, n4));
            }
            ++n4;
        }
        if (arrayList.size() <= 0) {
            b b3 = new b(d2, d3);
            return b3;
        }
        Collections.sort(arrayList);
        a[] aArray = this.createArray(arrayList);
        n3 = aArray[0].a;
        n2 = aArray.length >= 2 ? aArray[1].a : -1;
        g4 = this.points[n3];
        g3 = n2 >= 0 ? this.points[n2] : new jp.live2d.type_editor.g(0.0, 0.0);
        g2 = new Vector2d(g4, g3);
        if (aArray.length >= 3) {
            int n7 = 2;
            while (n7 < aArray.length) {
                int n8 = aArray[n7].a;
                object2 = this.points[n8];
                Vector2d vector2d2 = new Vector2d(g4, (jp.live2d.type_editor.g)object2);
                double d5 = jp.noids.h.b.a((Vector2d)g2, vector2d2, false);
                double d6 = Math.abs(d5 - Math.PI);
                if (d6 < d5) {
                    d5 = d6;
                }
                if (d5 < 0.005235987755982988) {
                    System.out.printf("ignore low angle %f\t\t\t\t\t@@BasicMorph\n", d5 * 180.0 / Math.PI);
                } else {
                    double[] dArray = jp.noids.graphics.geom.c.a(g5, g4, (Vector2d)g2, vector2d2);
                    if (dArray != null) {
                        b b4 = new b(d2, d3, n3, n2, n8, (float)dArray[0], (float)dArray[1]);
                        return b4;
                    }
                    System.out.printf("det == 0\t\t\t\t\t@@BasicMorph\n", new Object[0]);
                }
                ++n7;
            }
        }
        if ((object = (Object)jp.noids.graphics.geom.c.a(g5, g4, (Vector2d)g2, vector2d = ((Vector2d)g2).norm_new())) != null) {
            object2 = new b(d2, d3, n3, n2, (float)object[0], (float)object[1]);
            return object2;
        }
        object2 = new b(d2, d3);
        return object2;
    }

    private a[] createArray(ArrayList<a> arrayList) {
        a a2;
        a a3 = a2 = arrayList.get(arrayList.size() - 1);
        int n2 = arrayList.size() - 2;
        while (n2 >= 0) {
            a a4 = arrayList.get(n2);
            if (a4.b == a3.b) {
                MoPoint moPoint = this.points[a3.a];
                MoPoint moPoint2 = this.points[a4.a];
                if (moPoint2.x == moPoint.x && moPoint2.y == moPoint.y) {
                    arrayList.remove(n2);
                }
            }
            a3 = a4;
            --n2;
        }
        a[] aArray = arrayList.toArray(new a[0]);
        return aArray;
    }

    public jp.live2d.type_editor.g getPointByTopologyDef(b b2, float f2, float f3) {
        jp.live2d.type_editor.g g2;
        if (b2.c == -1) {
            return null;
        }
        if (f2 == f3) {
            MoPoint moPoint = this.points[b2.c];
            Vector2d vector2d = null;
            Vector2d vector2d2 = null;
            jp.live2d.type_editor.g g3 = b2.d == -1 ? new jp.live2d.type_editor.g(0.0, 0.0) : this.points[b2.d];
            vector2d = new Vector2d((jp.live2d.type_editor.g)moPoint, g3);
            vector2d2 = b2.e == -1 ? vector2d.norm_new() : new Vector2d((jp.live2d.type_editor.g)moPoint, (jp.live2d.type_editor.g)this.points[b2.e]);
            jp.live2d.type_editor.g g4 = new jp.live2d.type_editor.g(moPoint.x + vector2d.x * b2.f + vector2d2.x * b2.g, moPoint.y + vector2d.y * b2.f + vector2d2.y * b2.g);
            return g4;
        }
        jp.live2d.type_editor.g g5 = new jp.live2d.type_editor.g(this.points[b2.c]);
        Vector2d vector2d = null;
        Vector2d vector2d3 = null;
        jp.live2d.type_editor.g g6 = b2.d == -1 ? new jp.live2d.type_editor.g(0.0, 0.0) : new jp.live2d.type_editor.g(this.points[b2.d]);
        float f4 = f3 / f2;
        float f5 = f2 / f3;
        if (f2 < f3) {
            g5.x *= (double)f4;
            g6.x *= (double)f4;
        } else {
            g5.y *= (double)f5;
            g6.y *= (double)f5;
        }
        vector2d = new Vector2d(g5, g6);
        if (b2.e == -1) {
            vector2d3 = vector2d.norm_new();
        } else {
            g2 = new jp.live2d.type_editor.g(this.points[b2.e]);
            if (f2 < f3) {
                g2.x *= (double)f4;
            } else {
                g2.y *= (double)f5;
            }
            vector2d3 = new Vector2d(g5, g2);
        }
        g2 = new jp.live2d.type_editor.g(g5.x + vector2d.x * b2.f + vector2d3.x * b2.g, g5.y + vector2d.y * b2.f + vector2d3.y * b2.g);
        if (f2 < f3) {
            g2.x *= (double)f5;
        } else {
            g2.y *= (double)f4;
        }
        return g2;
    }

    public c getTopologyDef2(float f2, float f3) {
        int n2;
        int n3;
        Object object;
        jp.live2d.type_editor.g g2 = new jp.live2d.type_editor.g(f2, f3);
        Patch[] patchArray = this.getPatchListRef();
        int[][] nArray = this.getPolygons();
        int n4 = 0;
        while (n4 < patchArray.length) {
            jp.live2d.type_editor.g g3;
            Vector2d vector2d;
            Vector2d vector2d2;
            int n5;
            jp.live2d.type_editor.g g4;
            double[] dArray;
            if (patchArray[n4].contains(g2) && (dArray = jp.noids.graphics.geom.c.a(g2, g4 = new jp.live2d.type_editor.g(this.points[n5 = nArray[n4][0]]), vector2d2 = new Vector2d(g4, (jp.live2d.type_editor.g)(object = new jp.live2d.type_editor.g(this.points[n3 = nArray[n4][1]]))), vector2d = new Vector2d(g4, g3 = new jp.live2d.type_editor.g(this.points[n2 = nArray[n4][2]])))) != null) {
                c c2 = this.createTopologyDef2Inside(f2, f3, n5, n3, n2, (float)dArray[0], (float)dArray[1]);
                return c2;
            }
            ++n4;
        }
        ArrayList<a> arrayList = new ArrayList<a>();
        jp.live2d.type_editor.g g5 = new jp.live2d.type_editor.g();
        n3 = 0;
        while (n3 < this.points.length) {
            g5.x += this.points[n3].x;
            g5.y += this.points[n3].y;
            double d2 = m.b((jp.live2d.type_editor.g)this.points[n3], g2);
            if (d2 > 0.0) {
                arrayList.add(new a(d2, n3));
            }
            ++n3;
        }
        g5.x /= (double)this.points.length;
        g5.y /= (double)this.points.length;
        if (arrayList.size() <= 0) {
            c c3 = this.createTopologyDef2Single(f2, f3);
            return c3;
        }
        if (arrayList.size() <= 1) {
            c c4 = this.createTopologyDef2Single(f2, f3);
            return c4;
        }
        Collections.sort(arrayList);
        a[] aArray = this.createArray(arrayList);
        n2 = aArray[0].a;
        int n6 = aArray[1].a;
        object = this.createTopologyDef2OutsideSimple(f2, f3, n2, n6);
        return object;
    }

    private c createTopologyDef2Single(double d2, double d3) {
        c c2 = new c();
        c2.a = d2;
        c2.b = d3;
        c2.l = d.b;
        return c2;
    }

    private c createTopologyDef2Inside(double d2, double d3, int n2, int n3, int n4, double d4, double d5) {
        c c2 = new c();
        c2.a = d2;
        c2.b = d3;
        c2.c = n2;
        c2.d = n3;
        c2.e = n4;
        c2.j = d4;
        c2.k = d5;
        c2.l = d.a;
        return c2;
    }

    private c createTopologyDef2OutsideSimple(double d2, double d3, int n2, int n3) {
        c c2 = new c();
        c2.a = d2;
        c2.b = d3;
        c2.c = n2;
        c2.d = n3;
        c2.f = this.points[n2].x;
        c2.g = this.points[n2].y;
        c2.h = this.points[n3].x;
        c2.i = this.points[n3].y;
        c2.l = d.c;
        return c2;
    }

    public jp.live2d.type_editor.g getPointByTopologyDef2(c c2, float f2, float f3) {
        if (c2.c == -1) {
            return null;
        }
        if (f2 == f3) {
            if (c2.l == d.c) {
                double d2 = (c2.f + c2.h) * 0.5;
                double d3 = (c2.g + c2.i) * 0.5;
                double d4 = (this.points[c2.c].x + this.points[c2.d].x) * 0.5;
                double d5 = (this.points[c2.c].y + this.points[c2.d].y) * 0.5;
                jp.live2d.type_editor.g g2 = new jp.live2d.type_editor.g(c2.a + (d4 - d2), c2.b + (d5 - d3));
                return g2;
            }
            MoPoint moPoint = this.points[c2.c];
            Vector2d vector2d = null;
            Vector2d vector2d2 = null;
            jp.live2d.type_editor.g g3 = c2.d == -1 ? new jp.live2d.type_editor.g(0.0, 0.0) : this.points[c2.d];
            vector2d = new Vector2d((jp.live2d.type_editor.g)moPoint, g3);
            vector2d2 = c2.e == -1 ? vector2d.norm_new() : new Vector2d((jp.live2d.type_editor.g)moPoint, (jp.live2d.type_editor.g)this.points[c2.e]);
            jp.live2d.type_editor.g g4 = new jp.live2d.type_editor.g(moPoint.x + vector2d.x * c2.j + vector2d2.x * c2.k, moPoint.y + vector2d.y * c2.j + vector2d2.y * c2.k);
            return g4;
        }
        throw new RuntimeException("Not impl _");
    }

    public String toString() {
        return "Morphing [ " + this.points.length + " / " + this.lines.length + " ]";
    }

    static /* synthetic */ void access$1(BasicMorph basicMorph) {
        basicMorph.updatePatch();
    }

    class a
    implements Comparable {
        int a;
        double b;

        public a(double d2, int n2) {
            this.b = d2;
            this.a = n2;
        }

        public int compareTo(Object object) {
            a a2 = (a)object;
            if (this.b < a2.b) {
                return -1;
            }
            if (this.b > a2.b) {
                return 1;
            }
            return 0;
        }
    }

    public class MoCtrlPoint
    extends jp.noids.graphics.c.a
    implements IInterpolatable,
    jp.noids.xml.serialize.f {
        private static final long serialVersionUID = 1L;

        public MoCtrlPoint() {
        }

        public MoCtrlPoint(float f2, float f3) {
            super(f2, f3);
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.x = (float)d2;
            this.y = (float)d3;
            BasicMorph.this.dirtyPatch = true;
            BasicMorph.this.dirtyBounds = true;
        }

        @Override
        public void checkAndRollback(ITransform iTransform) {
        }

        public int getIndex() {
            MoCtrlPoint[] moCtrlPointArray = BasicMorph.this.ctrlPoints;
            int n2 = 0;
            while (n2 < moCtrlPointArray.length) {
                if (moCtrlPointArray[n2] == this) {
                    return n2;
                }
                ++n2;
            }
            throw new RuntimeException("Illegal State : ");
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            this.x = g2.h(element, "x");
            this.y = g2.h(element, "y");
        }

        @Override
        public void write(l l2, Element element) {
            l2.b(element, "x", (float)this.x);
            l2.b(element, "y", (float)this.y);
        }

        @Override
        public MoPoint deepClone() {
            throw new RuntimeException(a.e.a("DESI-0135"));
        }

        @Override
        public void init(Object object) {
            MoPoint moPoint = (MoPoint)object;
            this.x = moPoint.x;
            this.y = moPoint.y;
        }

        @Override
        public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
            MoPoint moPoint = (MoPoint)iInterpolatable;
            MoPoint moPoint2 = new MoPoint();
            moPoint2.x = (float)(this.x + (moPoint.x - this.x) * d2);
            moPoint2.y = (float)(this.y + (moPoint.y - this.y) * d2);
            return moPoint2;
        }

        @Override
        public Object getOwner() {
            return BasicMorph.this;
        }
    }

    public class MoLine
    implements IInterpolatable,
    jp.noids.xml.serialize.f {
        public int index1;
        public int index2;
        boolean deleted = false;

        public MoLine() {
        }

        public MoLine(int n2, int n3) {
            this.index1 = n2;
            this.index2 = n3;
        }

        public String toString() {
            return String.format("Line(%3d,%3d)%s", this.index1, this.index2, this.deleted ? " deleted!" : "");
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(boolean bl2) {
            this.deleted = bl2;
        }

        public int getIndex() {
            if (this.deleted) {
                return -1;
            }
            MoLine[] moLineArray = BasicMorph.this.lines;
            int n2 = 0;
            while (n2 < moLineArray.length) {
                if (moLineArray[n2] == this) {
                    return n2;
                }
                ++n2;
            }
            throw new RuntimeException("Illegal State : ");
        }

        public boolean isUsing(int n2) {
            return this.index1 == n2 || this.index2 == n2;
        }

        @Override
        public Object deepClone() {
            throw new RuntimeException(a.e.a("DESI-0135"));
        }

        @Override
        public void init(Object object) {
            MoLine moLine = (MoLine)object;
            this.index1 = moLine.index1;
            this.index2 = moLine.index2;
        }

        @Override
        public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
            MoLine moLine = (MoLine)iInterpolatable;
            MoLine moLine2 = new MoLine();
            moLine2.index1 = d2 <= 0.5 ? this.index1 : moLine.index1;
            moLine2.index2 = d2 <= 0.5 ? this.index2 : moLine.index2;
            return moLine2;
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            this.index1 = g2.g(element, "index1");
            this.index2 = g2.g(element, "index2");
        }

        @Override
        public void write(l l2, Element element) {
            l2.b(element, "index1", this.index1);
            l2.b(element, "index2", this.index2);
        }

        @Override
        public Object getOwner() {
            return BasicMorph.this;
        }
    }

    public class MoPoint
    extends jp.noids.graphics.c.a
    implements IInterpolatable,
    jp.noids.xml.serialize.f {
        private static final long serialVersionUID = 1L;

        public MoPoint() {
        }

        public MoPoint(double d2, double d3) {
            super(d2, d3);
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.x = (float)d2;
            this.y = (float)d3;
            BasicMorph.this.dirtyPatch = true;
            BasicMorph.this.dirtyBounds = true;
        }

        @Override
        public void checkAndRollback(ITransform iTransform) {
        }

        public int getIndex() {
            MoPoint[] moPointArray = BasicMorph.this.points;
            int n2 = 0;
            while (n2 < moPointArray.length) {
                if (moPointArray[n2] == this) {
                    return n2;
                }
                ++n2;
            }
            throw new RuntimeException("Illegal State : ");
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            this.x = g2.h(element, "x");
            this.y = g2.h(element, "y");
        }

        @Override
        public void write(l l2, Element element) {
            l2.b(element, "x", (float)this.x);
            l2.b(element, "y", (float)this.y);
        }

        @Override
        public MoPoint deepClone() {
            throw new RuntimeException(a.e.a("DESI-0135"));
        }

        @Override
        public void init(Object object) {
            MoPoint moPoint = (MoPoint)object;
            this.x = moPoint.x;
            this.y = moPoint.y;
        }

        @Override
        public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
            MoPoint moPoint = (MoPoint)iInterpolatable;
            MoPoint moPoint2 = new MoPoint();
            moPoint2.x = (float)(this.x + (moPoint.x - this.x) * d2);
            moPoint2.y = (float)(this.y + (moPoint.y - this.y) * d2);
            return moPoint2;
        }

        @Override
        public Object getOwner() {
            return BasicMorph.this;
        }
    }

    public class b {
        public double a;
        public double b;
        int c = -1;
        int d = -1;
        int e = -1;
        double f;
        double g;

        public String toString() {
            return String.format("xy(%5f,%5f) index(%2d,%2d,%2d) w12(%5f) w13(%5f) ", this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        public b(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }

        public b(double d2, double d3, int n2, int n3, double d4, double d5) {
            this.a = d2;
            this.b = d3;
            this.c = n2;
            this.d = n3;
            this.f = d4;
            this.g = d5;
        }

        public b(double d2, double d3, int n2, int n3, int n4, double d4, double d5) {
            this.a = d2;
            this.b = d3;
            this.c = n2;
            this.d = n3;
            this.e = n4;
            this.f = d4;
            this.g = d5;
        }

        public b(double d2, double d3, int n2, int n3) {
            this.a = d2;
            this.b = d3;
            this.c = n2;
            this.d = n3;
            jp.live2d.type_editor.g g2 = new jp.live2d.type_editor.g(d2, d3);
            MoPoint moPoint = BasicMorph.this.points[n2];
            MoPoint moPoint2 = BasicMorph.this.points[n3];
            Vector2d vector2d = new Vector2d((jp.live2d.type_editor.g)moPoint, (jp.live2d.type_editor.g)moPoint2);
            Vector2d vector2d2 = vector2d.norm_new();
            double[] dArray = jp.noids.graphics.geom.c.a(g2, moPoint, vector2d, vector2d2);
            if (dArray == null) {
                n2 = -1;
                n3 = -1;
            } else {
                this.f = dArray[0];
                this.g = dArray[1];
            }
        }
    }

    public class c {
        public double a;
        public double b;
        int c = -1;
        int d = -1;
        int e = -1;
        public double f;
        public double g;
        public double h;
        public double i;
        double j;
        double k;
        d l;

        public String toString() {
            return String.format("xy(%5f,%5f) index(%2d,%2d,%2d) w12(%5f) w13(%5f) ", this.a, this.b, this.c, this.d, this.e, this.j, this.k);
        }

        private c() {
        }
    }

    static enum d {
        a,
        b,
        c;

    }
}

