/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.design.morph.simple;

import java.util.Random;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.graphics.transform.SimpleAffineTransform;
import jp.noids.graphics.transform.a;
import jp.noids.util.az;
import jp.noids.util.c;
import jp.noids.xml.serialize.e;
import jp.noids.xml.serialize.f;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class Patch
implements IInterpolatable {
    float[] x;
    float[] y;
    SubPatch[] subPatch;
    int div;
    i bounds = new i();
    transient float _div_inverse;
    transient boolean dirty = true;

    public Patch() {
    }

    public Patch(g g2, g g3, g g4) {
        this.setup((float)g2.x, (float)g2.y, (float)g3.x, (float)g3.y, (float)g4.x, (float)g4.y, 1);
    }

    public Patch(float[] fArray) {
        this.setup(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], 1);
    }

    public Patch(float[] fArray, int n2) {
        this.setup(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], n2);
    }

    public Patch(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.setup(f2, f3, f4, f5, f6, f7, 1);
    }

    public Patch(float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
        this.setup(f2, f3, f4, f5, f6, f7, n2);
    }

    public g getCenter() {
        return new g((double)(this.x[0] + this.x[1] + this.x[2]) / 3.0, (double)(this.y[0] + this.y[1] + this.y[2]) / 3.0);
    }

    public void setup(float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
        float f8;
        int n3;
        int n4;
        this.div = n2;
        this._div_inverse = 1.0f / (float)n2;
        if (n2 == 1) {
            this.x = new float[]{f2, f4, f6};
            this.y = new float[]{f3, f5, f7};
            this.subPatch = new SubPatch[]{new SubPatch()};
            return;
        }
        int n5 = n2 * n2;
        int n6 = (n2 + 2) * (n2 + 1) / 2;
        float f9 = f4 - f2;
        float f10 = f5 - f3;
        float f11 = f6 - f2;
        float f12 = f7 - f3;
        this.x = new float[n6];
        this.y = new float[n6];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n2 + 1) {
            n4 = 0;
            while (n4 < n8 + 1) {
                n3 = n8 - n4;
                float f13 = f11 * (float)n4 * this._div_inverse;
                float f14 = f12 * (float)n4 * this._div_inverse;
                float f15 = f9 * (float)n3 * this._div_inverse;
                float f16 = f10 * (float)n3 * this._div_inverse;
                this.x[n7] = f2 + f15 + f13;
                this.y[n7] = f3 + f16 + f14;
                ++n7;
                ++n4;
            }
            ++n8;
        }
        this.subPatch = new SubPatch[n5];
        n8 = 0;
        n4 = 0;
        while (n4 < n2) {
            n3 = 0;
            while (n3 < n4 + 1) {
                int n9 = n4 - n3;
                int n10 = n8;
                int n11 = n10 + n4 + 1;
                int n12 = n11 + 1;
                float f17 = (float)n9 * this._div_inverse;
                f8 = (float)n3 * this._div_inverse;
                this.subPatch[n8] = new SubPatch(n8, f17, f8, true, n10, n11, n12);
                ++n8;
                ++n3;
            }
            ++n4;
        }
        n4 = 1;
        while (n4 < n2) {
            n3 = 0;
            while (n3 < n4) {
                int n13 = n4 - n3;
                int n14 = (n4 + 1) * n4 / 2 + n3;
                int n15 = n14 + n4 + 2;
                int n16 = n14 + 1;
                int n17 = n14;
                f8 = (float)n13 * this._div_inverse;
                float f18 = (float)(n3 + 1) * this._div_inverse;
                this.subPatch[n8] = new SubPatch(n8, f8, f18, false, n15, n16, n17);
                ++n8;
                ++n3;
            }
            ++n4;
        }
    }

    public float[] getMainTriangle() {
        if (this.subPatch.length != 1) {
            throw new RuntimeException("Not Implemented : " + this.subPatch.length);
        }
        SubPatch subPatch = this.subPatch[0];
        float[] fArray = subPatch.getPositions(null, 0);
        return fArray;
    }

    public void dump() {
        int n2 = 0;
        while (n2 < this.x.length) {
            System.out.print("(" + az.a(this.x[n2], 5) + " , " + az.a(this.y[n2], 5) + ") , ");
            ++n2;
        }
        System.out.println();
    }

    @Override
    public Object deepClone() {
        Patch patch = new Patch();
        patch.init(this);
        return patch;
    }

    @Override
    public void init(Object object) {
        Patch patch = (Patch)object;
        this.x = c.a(patch.x);
        this.y = c.a(patch.y);
        this.div = patch.div;
        this._div_inverse = patch._div_inverse;
        this.subPatch = new SubPatch[patch.subPatch.length];
        int n2 = 0;
        while (n2 < this.subPatch.length) {
            SubPatch subPatch = patch.subPatch[n2];
            this.subPatch[n2] = new SubPatch(subPatch.subPatchNo, subPatch.base_u, subPatch.base_v, subPatch.forward, subPatch.pt1, subPatch.pt2, subPatch.pt3);
            ++n2;
        }
        this.dirty = true;
    }

    public i getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        return this.bounds;
    }

    private void update() {
        int n2 = this.x.length;
        float f2 = this.x[0];
        float f3 = this.x[0];
        float f4 = this.y[0];
        float f5 = this.y[0];
        int n3 = 1;
        while (n3 < n2) {
            float f6 = this.x[n3];
            float f7 = this.y[n3];
            if (f6 > f2) {
                f2 = f6;
            }
            if (f6 < f3) {
                f3 = f6;
            }
            if (f7 > f4) {
                f4 = f7;
            }
            if (f7 < f5) {
                f5 = f7;
            }
            ++n3;
        }
        this.bounds = new i(f3, f5, f2 - f3, f4 - f5);
        this.dirty = false;
    }

    public boolean contains(g g2) {
        if (!this.getBoundsRect().contains(g2)) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.subPatch.length) {
            if (this.subPatch[n2].contains(g2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public SubPatch[] getSubPatchListRef() {
        return this.subPatch;
    }

    public SubPatch getSubPatch(int n2) {
        return this.subPatch[n2];
    }

    public int getSubPatchNo(float f2, float f3) {
        int n2;
        boolean bl2;
        int n3 = (int)(f2 * (float)this.div);
        int n4 = (int)(f3 * (float)this.div);
        float f4 = f2 + f3 - (float)(n3 + n4) * this._div_inverse;
        boolean bl3 = bl2 = f4 < this._div_inverse;
        if (bl2) {
            n2 = (n3 + 1) * n3 / 2 + n4;
        } else {
            int n5 = (this.div + 1) * this.div / 2;
            n2 = n5 + (n3 + 1) * n3 / 2 + n4;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 1) {
            return 1;
        }
        return n2;
    }

    public Patch createTransformed(ITransform iTransform, int n2) {
        try {
            if (iTransform == null) {
                return (Patch)this.deepClone();
            }
            Patch patch = iTransform instanceof SimpleAffineTransform ? (Patch)this.deepClone() : (this.div == 1 ? new Patch(this.x[0], this.y[0], this.x[1], this.y[1], this.x[2], this.y[2], n2) : (Patch)this.deepClone());
            patch.transform(iTransform);
            return patch;
        }
        catch (jp.noids.ui.l.f f2) {
            f2.printStackTrace();
            throw new a(f2);
        }
    }

    public void transform(ITransform iTransform) {
        int n2 = this.x.length;
        g g2 = new g();
        int n3 = 0;
        while (n3 < n2) {
            g2.x = this.x[n3];
            g2.y = this.y[n3];
            iTransform.transform(g2, g2);
            this.x[n3] = (float)g2.x;
            this.y[n3] = (float)g2.y;
            ++n3;
        }
        this.dirty = true;
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        Patch patch = (Patch)iInterpolatable;
        if (patch.div != this.div) {
            throw new RuntimeException("Illegal State : " + patch.div + " != " + this.div);
        }
        int n2 = this.x.length;
        Patch patch2 = new Patch();
        patch2.x = new float[n2];
        patch2.y = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            patch2.x[n3] = (float)((double)this.x[n3] + (double)(patch.x[n3] - this.x[n3]) * d2);
            patch2.y[n3] = (float)((double)this.y[n3] + (double)(patch.y[n3] - this.y[n3]) * d2);
            ++n3;
        }
        n3 = patch.subPatch.length;
        patch2.subPatch = new SubPatch[n3];
        int n4 = 0;
        while (n4 < n3) {
            SubPatch[] subPatchArray = patch2.subPatch;
            Patch patch3 = patch2;
            patch3.getClass();
            subPatchArray[n4] = patch3.new SubPatch(this.subPatch[n4]);
            ++n4;
        }
        return patch2;
    }

    public void test(float f2) {
        Random random = new Random();
        int n2 = 0;
        while (n2 < this.x.length) {
            int n3 = n2;
            this.x[n3] = this.x[n3] + f2 * random.nextFloat();
            int n4 = n2++;
            this.y[n4] = this.y[n4] + f2 * random.nextFloat();
        }
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.x = (float[])g2.a(element, "x");
        this.y = (float[])g2.a(element, "y");
        this.subPatch = (SubPatch[])g2.a(element, "subPatch");
        this.div = g2.b(element, "div");
        this.bounds = (i)g2.a(element, "bounds");
        this._div_inverse = 1.0f / (float)this.div;
        this.dirty = false;
    }

    @Override
    public void write(l l2, Element element) {
        if (this.dirty) {
            this.update();
        }
        l2.a(element, "x", this.x);
        l2.a(element, "y", this.y);
        l2.a(element, "subPatch", this.subPatch);
        l2.a(element, "div", this.div);
        l2.a(element, "bounds", this.bounds);
    }

    public class SubPatch
    implements f,
    h {
        int subPatchNo;
        float base_u;
        float base_v;
        boolean forward;
        int pt1;
        int pt2;
        int pt3;

        public SubPatch() {
            this.subPatchNo = -1;
            this.base_u = 0.0f;
            this.base_v = 0.0f;
            this.forward = true;
            this.pt1 = 0;
            this.pt2 = 1;
            this.pt3 = 2;
        }

        public SubPatch(int n2, float f2, float f3, boolean bl2, int n3, int n4, int n5) {
            this.subPatchNo = n2;
            this.base_u = f2;
            this.base_v = f3;
            this.forward = bl2;
            this.pt1 = n3;
            this.pt2 = n4;
            this.pt3 = n5;
        }

        public SubPatch(SubPatch subPatch) {
            this.subPatchNo = subPatch.subPatchNo;
            this.base_u = subPatch.base_u;
            this.base_v = subPatch.base_v;
            this.forward = subPatch.forward;
            this.pt1 = subPatch.pt1;
            this.pt2 = subPatch.pt2;
            this.pt3 = subPatch.pt3;
        }

        public float getX1() {
            return Patch.this.x[this.pt1];
        }

        public float getY1() {
            return Patch.this.y[this.pt1];
        }

        public float getX2() {
            return Patch.this.x[this.pt2];
        }

        public float getY2() {
            return Patch.this.y[this.pt2];
        }

        public float getX3() {
            return Patch.this.x[this.pt3];
        }

        public float getY3() {
            return Patch.this.y[this.pt3];
        }

        public float[] getPositions(float[] fArray, int n2) {
            if (fArray == null) {
                fArray = new float[6];
            }
            fArray[n2 + 0] = Patch.this.x[this.pt1];
            fArray[n2 + 1] = Patch.this.y[this.pt1];
            fArray[n2 + 2] = Patch.this.x[this.pt2];
            fArray[n2 + 3] = Patch.this.y[this.pt2];
            fArray[n2 + 4] = Patch.this.x[this.pt3];
            fArray[n2 + 5] = Patch.this.y[this.pt3];
            return fArray;
        }

        public void getWholeUV(float f2, float f3, float[] fArray) {
            if (this.subPatchNo == -1) {
                fArray[0] = f2;
                fArray[1] = f3;
                return;
            }
            if (this.forward) {
                fArray[0] = this.base_u + f2 * Patch.this._div_inverse;
                fArray[1] = this.base_v + f3 * Patch.this._div_inverse;
            } else {
                fArray[0] = this.base_u - f2 * Patch.this._div_inverse;
                fArray[1] = this.base_v - f3 * Patch.this._div_inverse;
            }
        }

        public void dump() {
            System.out.println("no " + this.subPatchNo + " / " + this.pt1 + " , " + this.pt2 + " , " + this.pt3 + "  base uv[" + this.base_u + " , " + this.base_v + "]");
        }

        public boolean contains(g g2) {
            return m.a((float)g2.x, (float)g2.y, Patch.this.x[this.pt1], Patch.this.y[this.pt1], Patch.this.x[this.pt2], Patch.this.y[this.pt2], Patch.this.x[this.pt3], Patch.this.y[this.pt3]);
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            try {
                this.subPatchNo = g2.b(element, "subPatchNo");
                this.base_u = g2.d(element, "u");
                this.base_v = g2.d(element, "v");
                this.forward = g2.e(element, "forward");
                String string = (String)g2.a(element, "pt");
                int[] nArray = jp.noids.l.a.e.b(string);
                this.pt1 = nArray[0];
                this.pt2 = nArray[1];
                this.pt3 = nArray[2];
            }
            catch (jp.noids.l.a.m m2) {
                m2.printStackTrace();
                throw new e(m2);
            }
        }

        @Override
        public void write(l l2, Element element) {
            l2.a(element, "subPatchNo", this.subPatchNo);
            l2.a(element, "u", this.base_u);
            l2.a(element, "v", this.base_v);
            l2.a(element, "forward", this.forward);
            l2.a(element, "pt", this.pt1 + "," + this.pt2 + "," + this.pt3);
        }

        @Override
        public Object getOwner() {
            return Patch.this;
        }
    }
}

