/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.framework.param;

import jp.noids.framework.ID;
import jp.noids.framework.IDoubleParam;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class ParamDouble
implements IDoubleParam,
IInterpolatable {
    private double value;
    private ID.Param id;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;

    public ParamDouble() {
    }

    public ParamDouble(ID.Param param, double d2) {
        this.id = param;
        this.value = d2;
    }

    public ParamDouble(ID.Param param, double d2, double d3, double d4) {
        this.id = param;
        this.value = d2;
        this.min = d3;
        this.max = d4;
    }

    @Override
    public ID.Param getID() {
        return this.id;
    }

    public double getDouble() {
        return this.value;
    }

    public void setDouble(double d2) {
        this.value = d2;
    }

    @Override
    public void setDoubleValue(int n2, double d2) {
        this.value = d2;
    }

    @Override
    public Object deepClone() {
        return new ParamDouble(this.id, this.value, this.min, this.max);
    }

    @Override
    public void init(Object object) {
        ParamDouble paramDouble = (ParamDouble)object;
        this.id = paramDouble.id;
        this.value = paramDouble.value;
        this.min = paramDouble.min;
        this.max = paramDouble.max;
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        ParamDouble paramDouble = (ParamDouble)iInterpolatable;
        ParamDouble paramDouble2 = new ParamDouble();
        paramDouble2.id = this.id;
        paramDouble2.value = this.value + (paramDouble.value - this.value) * d2;
        paramDouble2.min = this.min + (paramDouble.min - this.min) * d2;
        paramDouble2.max = this.max + (paramDouble.max - this.max) * d2;
        return paramDouble2;
    }

    @Override
    public Object getValue(int n2) {
        switch (n2) {
            case 0: {
                return new Double(this.value);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public double getDoubleValue(int n2) {
        return this.value;
    }

    @Override
    public void read(g g2, Element element) {
        int n2 = g2.a(element);
        this.value = g2.c(element, "val");
        this.id = (ID.Param)g2.a(element, "id");
        if (n2 >= 1000) {
            this.min = g2.c(element, "min");
            this.max = g2.c(element, "max");
        }
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1000);
        l2.a(element, "val", this.value);
        l2.a(element, "id", this.id);
        l2.a(element, "min", this.min);
        l2.a(element, "max", this.max);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double d2) {
        this.max = d2;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double d2) {
        this.min = d2;
    }

    public String toString() {
        return "" + this.value;
    }

    public void dump() {
        System.out.println(this.id + " : " + this.value + " { " + this.min + " .. " + this.max + " } ");
    }
}

