/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.graphics;

import a.d;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.noids.framework.INoObfuscate;
import jp.noids.g.c;
import jp.noids.graphics.f;
import jp.noids.graphics.f.e;
import jp.noids.graphics.i;
import jp.noids.graphics.k;
import jp.noids.graphics.l;
import jp.noids.util.M;
import jp.noids.util.O;
import jp.noids.util.UtCache;
import jp.noids.util.aP;
import jp.noids.util.ap;
import jp.noids.util.p;

public class UtImage
implements INoObfuscate {
    static Component dummyComponent = null;
    static int imgArrayNo = 0;
    static int nameCounter = 0;

    public static Image clone(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            if (bufferedImage.getType() == 13) {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType(), (IndexColorModel)bufferedImage.getColorModel());
                DataBuffer dataBuffer2 = bufferedImage2.getRaster().getDataBuffer();
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                byte[] byArray2 = ((DataBufferByte)dataBuffer2).getData();
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                return bufferedImage2;
            }
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
            DataBuffer dataBuffer3 = bufferedImage3.getRaster().getDataBuffer();
            if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int[] nArray2 = ((DataBufferInt)dataBuffer3).getData();
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            } else if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                byte[] byArray3 = ((DataBufferByte)dataBuffer3).getData();
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            } else if (dataBuffer instanceof DataBufferUShort) {
                short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                short[] sArray2 = ((DataBufferUShort)dataBuffer3).getData();
                System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            } else if (dataBuffer instanceof DataBufferShort) {
                short[] sArray = ((DataBufferShort)dataBuffer).getData();
                short[] sArray3 = ((DataBufferShort)dataBuffer3).getData();
                System.arraycopy(sArray, 0, sArray3, 0, sArray.length);
            }
            return bufferedImage3;
        }
        throw new RuntimeException("Not Implemented");
    }

    public static Image getImage(File file) {
        return UtImage.getImage(file, true);
    }

    public static Image getImage(File file, boolean bl2) {
        if (M.e(file, ".bmp")) {
            try {
                return UtImage.getBufferedImage(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
            }
        }
        Image image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        if (bl2) {
            UtImage.loadImage(image);
        }
        return image;
    }

    public static Image getImage(URL uRL) {
        return UtImage.getImage(uRL, true);
    }

    public static Image getImage(URL uRL, boolean bl2) {
        if (M.a(uRL.getFile(), ".bmp")) {
            try {
                return UtImage.getBufferedImage(uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return Toolkit.getDefaultToolkit().getImage(uRL);
            }
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (bl2) {
            UtImage.loadImage(image);
        }
        return image;
    }

    public static void loadImage(Image image) {
        try {
            MediaTracker mediaTracker = new MediaTracker(UtImage.getDummyComonent());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static Component getDummyComonent() {
        if (dummyComponent == null) {
            dummyComponent = new k();
        }
        return dummyComponent;
    }

    public static BufferedImage getBufferedImage(String string) {
        try {
            return UtImage.getBufferedImage(string, -1, null);
        }
        catch (jp.noids.framework.e.a a2) {
            a2.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getBufferedImage(String string, int n2) {
        try {
            return UtImage.getBufferedImage(string, n2, null);
        }
        catch (jp.noids.framework.e.a a2) {
            a2.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getBufferedImage(String string, int n2, jp.noids.framework.e.c c2) {
        File file = new File(string);
        if (file.exists()) {
            return UtImage.getBufferedImage(new FileInputStream(file), n2, c2);
        }
        URL uRL = new URL(string);
        return UtImage.getBufferedImage(uRL, n2, c2);
    }

    public static BufferedImage getBufferedImage(String string, jp.noids.framework.e.c c2) {
        return UtImage.getBufferedImage(string, -1, c2);
    }

    public static BufferedImage getBufferedImage(File file) {
        return UtImage.getBufferedImage(file, -1);
    }

    public static BufferedImage getBufferedImage(File file, int n2, jp.noids.framework.e.c c2) {
        return UtImage.getBufferedImage(new FileInputStream(file), n2, c2);
    }

    public static BufferedImage getBufferedImage(File file, jp.noids.framework.e.c c2) {
        return UtImage.getBufferedImage(new FileInputStream(file), -1, c2);
    }

    public static BufferedImage getBufferedImage(URL uRL, jp.noids.framework.e.c c2) {
        return UtImage.getBufferedImage(uRL.openStream(), -1, c2);
    }

    public static BufferedImage getBufferedImage(URL uRL, int n2, jp.noids.framework.e.c c2) {
        return UtImage.getBufferedImage(uRL.openStream(), n2, c2);
    }

    public static BufferedImage getBufferedImage(InputStream inputStream, int n2, jp.noids.framework.e.c c2) {
        BufferedImage bufferedImage;
        if (c2 != null) {
            jp.noids.framework.e.d d2 = new jp.noids.framework.e.d(c2, 100, d.a("CORE-0098"), true, inputStream);
            bufferedImage = ImageIO.read(d2);
            d2.close();
        } else {
            bufferedImage = ImageIO.read(inputStream);
        }
        if (bufferedImage == null) {
            throw new IOException("failed to open");
        }
        return UtImage.createSameTypeImage(bufferedImage, n2);
    }

    public static BufferedImage getBufferedImage(File file, int n2) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                throw new IOException("failed to open");
            }
            return UtImage.createSameTypeImage(bufferedImage, n2);
        }
        catch (IOException iOException) {
            System.err.println("failed file : " + file);
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public static BufferedImage getBufferedImage(URL uRL) {
        return UtImage.getBufferedImage(uRL, -1);
    }

    public static BufferedImage getBufferedImage(URL uRL, int n2) {
        BufferedImage bufferedImage = ImageIO.read(uRL);
        if (bufferedImage == null) {
            throw new IOException("failed to open");
        }
        return UtImage.createSameTypeImage(bufferedImage, n2);
    }

    public static BufferedImage createSameTypeImage(BufferedImage bufferedImage, int n2) {
        boolean bl2 = false;
        int n3 = bufferedImage.getType();
        if (n2 == -1 || n3 == n2) {
            return bufferedImage;
        }
        if (n3 == 6) {
            if (bl2) {
                System.gc();
            }
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n2);
            byte[] byArray = f.f(bufferedImage);
            int[] nArray = f.c(bufferedImage2);
            int n4 = nArray.length;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                byte by2 = byArray[n5++];
                byte by3 = byArray[n5++];
                byte by4 = byArray[n5++];
                byte by5 = byArray[n5++];
                nArray[n6] = (0xFF & by2) << 24 | (0xFF & by5) << 16 | (0xFF & by4) << 8 | 0xFF & by3;
                ++n6;
            }
            bufferedImage.flush();
            if (bl2) {
                System.gc();
            }
            return bufferedImage2;
        }
        if (bl2) {
            System.gc();
        }
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n2);
        Graphics graphics = bufferedImage3.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        bufferedImage.flush();
        if (bl2) {
            System.gc();
        }
        return bufferedImage3;
    }

    public static BufferedImage cloneImage(Image image, int n2) {
        System.gc();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        image.flush();
        System.gc();
        return bufferedImage;
    }

    public static BufferedImage createSampleImage(int n2, int n3) {
        return UtImage.createSampleImage(n2, n3, Color.PINK, true);
    }

    public static BufferedImage createSampleImage(int n2, int n3, boolean bl2) {
        return UtImage.createSampleImage(n2, n3, Color.PINK, bl2);
    }

    public static BufferedImage createSampleImage(int n2, int n3, Color color) {
        return UtImage.createSampleImage(n2, n3, color, true);
    }

    public static BufferedImage createSampleImage(int n2, int n3, Color color, boolean bl2) {
        try {
            Object object;
            Serializable serializable;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            i.a(graphics2D);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n2, n3);
            if (!bl2) {
                serializable = UtImage.getSampleImageFile();
                object = UtImage.getImage(serializable);
                AffineTransform affineTransform = AffineTransform.getRotateInstance(-30.0 * ap.c, 350.0, 250.0);
                graphics2D.drawImage((Image)object, affineTransform, null);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawOval(0, 0, n2 / 2, n2 / 2);
            graphics2D.setColor(Color.RED);
            graphics2D.setFont(new Font("Dialog", 1, 64));
            serializable = graphics2D.getTransform();
            object = new AffineTransform();
            ((AffineTransform)object).rotate(0.7853981633974483);
            ((AffineTransform)object).scale(1.0, 4.0);
            graphics2D.setTransform((AffineTransform)object);
            graphics2D.drawString("HELLO WORLD! HELLO WORLD! HELLO WORLD! HELLO WORLD! ", 10, 10);
            graphics2D.setTransform((AffineTransform)serializable);
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect(30, 30, 100, 100);
            graphics2D.setColor(Color.BLUE);
            graphics2D.drawString("SAMPLE IMAGE / ( " + n2 + " , " + n3 + " ) ", 20, n3 - 20);
            graphics2D.setColor(Color.BLACK);
            int n4 = 10;
            graphics2D.drawLine(n2 / 2 - n4, n3 / 2, n2 / 2 + n4, n3 / 2);
            graphics2D.drawLine(n2 / 2, n3 / 2 - n4, n2 / 2, n3 / 2 + n4);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferedImage createTextImage(int n2, int n3, Color color, String string) {
        try {
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            i.a(graphics2D);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n2, n3);
            graphics2D.setColor(Color.RED);
            graphics2D.setFont(new Font("Dialog", 1, 64));
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.rotate(0.7853981633974483);
            affineTransform2.scale(1.0, 4.0);
            graphics2D.setTransform(affineTransform2);
            graphics2D.drawString(string, 10, 10);
            graphics2D.setTransform(affineTransform);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File getSampleImageFile() {
        File file = new File("../cn_sample/data/image/sky.jpg");
        if (!file.exists()) {
            System.err.printf("Sample image is not found !! at %s\t\t\t\t\t@@UtImage\n", file.getAbsolutePath());
        }
        return file;
    }

    public static File getSampleImageFile(String string) {
        File file = new File("../cn_sample/data/image/sky." + string);
        if (!file.exists()) {
            System.err.printf("Sample image is not found !! at %s\t\t\t\t\t@@UtImage\n", file.getAbsolutePath());
        }
        return file;
    }

    public static e showImage(Image image, int n2) {
        return e.a(image, n2);
    }

    public static e showImage(Image image, boolean bl2) {
        return e.a(image, bl2 ? 3 : 2);
    }

    public static e showImage() {
        return e.a(null);
    }

    public static e showImage(Image image) {
        return UtImage.showImage(image, 2);
    }

    public static e showImage(String string) {
        return e.a(string);
    }

    public static e showImage(Image[] imageArray) {
        e e2 = UtImage.showImage(imageArray[0], "Array" + imgArrayNo + ": " + 0);
        int n2 = 1;
        while (n2 < imageArray.length) {
            e2.b(imageArray[n2], "Array" + imgArrayNo + ": " + n2);
            ++n2;
        }
        return e2;
    }

    public static e showImage(Image image, int n2, String string) {
        return e.a(image, n2, string);
    }

    public static e showImage(Image image, boolean bl2, String string) {
        return e.a(image, bl2 ? 3 : 2, string, true);
    }

    public static e showImage(Image image, boolean bl2, String string, boolean bl3) {
        return e.a(image, bl2 ? 3 : 2, string, bl3);
    }

    public static e showImage(Image image, String string) {
        return UtImage.showImage(image, 2, string);
    }

    public static e showImage(Image image, boolean bl2, String string, jp.noids.graphics.f.a.a a2) {
        return e.a(image, bl2 ? 3 : 2, string, a2);
    }

    public static e showTexture(BufferedImage bufferedImage, String string) {
        BufferedImage bufferedImage2 = f.b(bufferedImage);
        f.g(bufferedImage2);
        e e2 = UtImage.showImage((Image)bufferedImage, string);
        e2.b(bufferedImage2, String.valueOf(string) + "_opaque");
        return e2;
    }

    public static Image getClipboard() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setClipboard(Image image) {
        a a2 = new a(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(a2, null);
    }

    public static void copyToClipboard(Image image) {
        UtImage.setClipboard(image);
    }

    public static boolean saveImageWithDialog(Image image) {
        block9: {
            File file;
            block10: {
                JFileChooser jFileChooser = new JFileChooser();
                p.a("jp.noids.graphics.UtImage", "AutoSaveFileChooser", jFileChooser);
                c[] cArray = new c[]{new c(".jpg", d.a("CORE-0186")), new c(".gif", d.a("CORE-0187")), new c(".png", d.a("CORE-0188"))};
                int n2 = 0;
                while (n2 < cArray.length) {
                    jFileChooser.addChoosableFileFilter(cArray[n2]);
                    ++n2;
                }
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
                if (jFileChooser.showSaveDialog(O.e()) != 0) break block9;
                file = jFileChooser.getSelectedFile();
                if (!file.exists()) break block10;
                if (JOptionPane.showConfirmDialog(O.e(), String.valueOf(d.a("CORE-0189")) + file.getAbsolutePath() + d.a("CORE-0190"), d.a("CORE-0191"), 0) == 0) {
                    if (!file.delete()) {
                        JOptionPane.showMessageDialog(O.e(), d.a("CORE-0192"));
                        return false;
                    }
                    break block10;
                }
                return false;
            }
            try {
                BufferedImage bufferedImage;
                if (image instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)image;
                } else {
                    bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    graphics2D.dispose();
                }
                ImageIO.write((RenderedImage)bufferedImage, M.b(file, false), file);
                return true;
            }
            catch (HeadlessException headlessException) {
                headlessException.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static boolean hasAlpha(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean saveImage(BufferedImage bufferedImage, File file, float f2, boolean bl2, jp.noids.framework.e.c c2) {
        if (!bl2 && file.exists()) {
            throw new IOException(d.a("CORE-0193"));
        }
        jp.noids.framework.e.c c3 = jp.noids.framework.e.e.a(c2);
        File file2 = M.b(file) ? file : M.a(file, true);
        try {
            c3.a(20, "", true);
            M.f(file);
            if (M.m(file) && UtImage.hasAlpha(bufferedImage)) {
                bufferedImage = UtImage.createSameTypeImage(bufferedImage, 1);
            }
            c3.b(1);
            File file3 = file2;
            String string = M.b(file, false).toLowerCase();
            boolean bl3 = UtImage.saveImage_exe(bufferedImage, file3, string, f2, c3);
            if (bl3) {
                boolean bl4;
                boolean bl5 = bl4 = M.a(file2, file);
                return bl5;
            }
            return false;
        }
        finally {
            c3.b();
        }
    }

    public static boolean saveImage_exe(BufferedImage bufferedImage, Object object, String string, float f2, jp.noids.framework.e.c c2) {
        JPEGImageWriteParam jPEGImageWriteParam;
        ImageWriter imageWriter;
        jp.noids.framework.e.c c3 = jp.noids.framework.e.e.a(c2);
        boolean[] blArray = new boolean[1];
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        ImageWriter imageWriter2 = imageWriter = iterator.hasNext() ? iterator.next() : null;
        if (imageWriter == null) {
            return false;
        }
        boolean bl2 = string.equals("jpg") || string.equals("jpeg");
        int n2 = 10000;
        imageWriter.addIIOWriteProgressListener(new l(blArray, c3));
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(object);
        imageWriter.setOutput(imageOutputStream);
        if (bl2) {
            jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(f2);
        } else {
            jPEGImageWriteParam = null;
        }
        c3.c(10);
        c3.a(10000, "", true);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
        c3.b();
        c3.c();
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
        c3.b(1);
        return !blArray[0];
    }

    public static void main2(String[] stringArray) {
        double d2 = Double.NEGATIVE_INFINITY;
        System.out.println("a : " + d2);
        double d3 = 0.0 * d2;
        System.out.println("b : " + d3);
        double d4 = Double.NaN;
        System.out.println("b : " + d4);
        d4 = Double.POSITIVE_INFINITY;
        System.out.println("" + d4);
        d4 = Double.NaN;
        System.out.println("" + d4);
        d4 = Double.POSITIVE_INFINITY;
        System.out.println("" + d4);
        d4 = Double.POSITIVE_INFINITY;
        System.out.println("" + d4);
        boolean bl2 = true;
        System.out.println("" + bl2);
        d4 = Math.atan(Double.MAX_VALUE);
        d2 = Double.MAX_VALUE;
        while (d2 > 10.0) {
            d4 = Math.atan(d2);
            System.out.println(String.valueOf(d2) + " : " + d4);
            d2 /= 10.0;
        }
    }

    public static Image createCrop(Image image, int n2, int n3, int n4, int n5) {
        CropImageFilter cropImageFilter = new CropImageFilter(n2, n3, n4, n5);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static void drawImageWithMargin(Graphics graphics, BufferedImage bufferedImage, int n2, int n3) {
        double d2;
        double d3;
        double d4;
        double[] dArray;
        AffineTransform affineTransform;
        Graphics2D graphics2D;
        int n4;
        BufferedImage bufferedImage2;
        block7: {
            block8: {
                bufferedImage2 = null;
                n4 = 2;
                int n5 = n4 * 2;
                try {
                    graphics2D = (Graphics2D)graphics;
                    affineTransform = graphics2D.getTransform();
                    dArray = aP.a(affineTransform, null);
                    d4 = dArray[0];
                    d3 = dArray[1];
                    d2 = Math.min(Math.abs(d4), Math.abs(d3));
                    if (d2 != 0.0) break block7;
                    if (bufferedImage2 == null) break block8;
                }
                catch (Throwable throwable) {
                    if (bufferedImage2 != null) {
                        UtCache.release(bufferedImage2);
                    }
                    throw throwable;
                }
                UtCache.release(bufferedImage2);
            }
            return;
        }
        if (d2 <= 0.4) {
            double d5 = (double)bufferedImage.getWidth() * d4;
            double d6 = (double)bufferedImage.getHeight() * d3;
            int n6 = (int)Math.abs(d5 * 2.0);
            int n7 = (int)Math.abs(d6 * 2.0);
            dArray[1] = 1.0;
            dArray[0] = 1.0;
            jp.live2d.type_editor.a a2 = aP.a(dArray);
            a2.scale(d5 / (double)n6, d6 / (double)n7);
            graphics2D.setTransform(a2);
            bufferedImage2 = UtCache.getBufferedImage(n6 + n4 * 2, n7 + n4 * 2, bufferedImage.getType());
            Graphics2D graphics2D2 = bufferedImage2.createGraphics();
            UtImage.clear(bufferedImage2, graphics2D2);
            f.a(bufferedImage, bufferedImage2, n6, n7, n4);
            graphics.drawImage(bufferedImage2, n2 - n4, n3 - n4, null);
            graphics2D.setTransform(affineTransform);
        } else {
            bufferedImage2 = UtCache.getBufferedImage(bufferedImage.getWidth(null) + n4 * 2, bufferedImage.getHeight(null) + n4 * 2, bufferedImage.getType());
            UtImage.clear(bufferedImage2);
            Graphics2D graphics2D3 = bufferedImage2.createGraphics();
            graphics2D3.drawImage((Image)bufferedImage, n4, n4, null);
            graphics2D3.dispose();
            graphics.drawImage(bufferedImage2, n2 - n4, n3 - n4, null);
        }
        if (bufferedImage2 != null) {
            UtCache.release(bufferedImage2);
        }
    }

    public static void clear(BufferedImage bufferedImage) {
        UtImage.setColor(bufferedImage, null, 0xFFFFFF);
    }

    public static void clear(BufferedImage bufferedImage, Graphics2D graphics2D) {
        UtImage.setColor(bufferedImage, graphics2D, 0xFFFFFF);
    }

    public static void setColor(BufferedImage bufferedImage, int n2) {
        UtImage.setColor(bufferedImage, null, n2);
    }

    public static void setColor(BufferedImage bufferedImage, Graphics2D graphics2D, int n2) {
        boolean bl2 = false;
        if (graphics2D == null) {
            graphics2D = bufferedImage.createGraphics();
            bl2 = true;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(2));
        graphics2D.setColor(new Color(n2, true));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setComposite(composite);
        if (bl2) {
            graphics2D.dispose();
        }
    }

    public static String getNextName() {
        return "image:" + nameCounter++;
    }

    private static class a
    implements Transferable {
        private Image a;

        public a(Image image) {
            this.a = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.a;
        }
    }
}

