/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.graphics.geom;

import jp.noids.graphics.geom.Point3d;
import jp.noids.graphics.geom.Point3f;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class Vector3d
extends Point3d {
    public Vector3d() {
    }

    public Vector3d(Point3d point3d) {
        super(point3d);
    }

    public Vector3d(double d2, double d3, double d4) {
        super(d2, d3, d4);
    }

    public Vector3d(Point3f point3f, Point3f point3f2) {
        this(point3f2.x - point3f.x, point3f2.y - point3f.y, point3f2.z - point3f.z);
    }

    public Vector3d(Point3d point3d, Point3d point3d2) {
        this(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
    }

    public void setVector(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public double getAngle(Vector3d vector3d) {
        double d2;
        Vector3d vector3d2 = this;
        double d3 = vector3d2.getDistance();
        double d4 = (vector3d2.x * vector3d.x + vector3d2.y * vector3d.y + vector3d2.z * vector3d.z) / (d3 * (d2 = vector3d.getDistance()));
        if (d4 < -1.0) {
            d4 = -1.0;
        } else if (d4 > 1.0) {
            d4 = 1.0;
        }
        return Math.acos(d4);
    }

    public Vector3d norm_(Vector3d vector3d) {
        this.init(this.y * vector3d.z - this.z * vector3d.y, this.z * vector3d.x - this.x * vector3d.z, this.x * vector3d.y - this.y * vector3d.x);
        return this;
    }

    public Vector3d norm_new(Vector3d vector3d) {
        return Vector3d.cross(this, vector3d);
    }

    public Vector3d normalize() {
        double d2 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= d2;
        this.y /= d2;
        this.z /= d2;
        return this;
    }

    public Vector3d normalize_new() {
        Vector3d vector3d = new Vector3d(this);
        return vector3d.normalize();
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vector3d unit_new() {
        double d2 = this.getDistance();
        if (d2 == 0.0) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return new Vector3d(this.x / d2, this.y / d2, this.z / d2);
    }

    public Vector3d unit() {
        double d2 = this.getDistance();
        if (d2 == 0.0) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.x /= d2;
            this.y /= d2;
            this.z /= d2;
        }
        return this;
    }

    public Vector3d mul_new(double d2) {
        return new Vector3d(this.x * d2, this.y * d2, this.z * d2);
    }

    public Vector3d mul_(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    public Vector3d div_new(double d2) {
        return new Vector3d(this.x / d2, this.y / d2, this.z / d2);
    }

    public Vector3d div(double d2) {
        this.x /= d2;
        this.y /= d2;
        this.z /= d2;
        return this;
    }

    public Vector3d sub_new(Point3d point3d) {
        return new Vector3d(this.x - point3d.x, this.y - point3d.y, this.z - point3d.z);
    }

    public Vector3d sub_(Vector3d vector3d) {
        this.x -= vector3d.x;
        this.y -= vector3d.y;
        this.z -= vector3d.z;
        return this;
    }

    public Vector3d add_new(Point3d point3d) {
        return new Vector3d(this.x + point3d.x, this.y + point3d.y, this.z + point3d.z);
    }

    public Vector3d add_(Point3d point3d) {
        this.x += point3d.x;
        this.y += point3d.y;
        this.z += point3d.z;
        return this;
    }

    public static Vector3d sub(Point3d point3d, Point3d point3d2) {
        return new Vector3d(point3d.x - point3d2.x, point3d.y - point3d2.y, point3d.z - point3d2.z);
    }

    public static Vector3d add(Point3d point3d, Point3d point3d2) {
        return new Vector3d(point3d.x + point3d2.x, point3d.y + point3d2.y, point3d.z + point3d2.z);
    }

    public double dot(Point3d point3d) {
        return this.x * point3d.x + this.y * point3d.y + this.z * point3d.z;
    }

    public static Vector3d cross(Point3d point3d, Point3d point3d2) {
        return new Vector3d(point3d.y * point3d2.z - point3d.z * point3d2.y, point3d.z * point3d2.x - point3d.x * point3d2.z, point3d.x * point3d2.y - point3d.y * point3d2.x);
    }

    public Vector3d cross_new(Point3d point3d) {
        return new Vector3d(this.y * point3d.z - this.z * point3d.y, this.z * point3d.x - this.x * point3d.z, this.x * point3d.y - this.y * point3d.x);
    }

    public Vector3d cross(Point3d point3d) {
        double d2 = this.y * point3d.z - this.z * point3d.y;
        double d3 = this.z * point3d.x - this.x * point3d.z;
        double d4 = this.x * point3d.y - this.y * point3d.x;
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Vector3d rotateX_new(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        Vector3d vector3d = new Vector3d(this.x, this.y * d3 - this.z * d4, this.y * d4 + this.z * d3);
        return vector3d;
    }

    public Vector3d rotateY_new(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        Vector3d vector3d = new Vector3d(this.x * d3 + this.z * d4, this.y, -this.x * d4 + this.z * d3);
        return vector3d;
    }

    public Vector3d rotateZ_new(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        Vector3d vector3d = new Vector3d(this.x * d3 - this.y * d4, this.x * d4 + this.y * d3, this.z);
        return vector3d;
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        return new Vector3d(this.x + (((Vector3d)iInterpolatable).x - this.x) * d2, this.y + (((Vector3d)iInterpolatable).y - this.y) * d2, this.z + (((Vector3d)iInterpolatable).z - this.z) * d2);
    }

    @Override
    public Object deepClone() {
        return new Vector3d(this.x, this.y, this.z);
    }

    @Override
    public void init(Object object) {
        Vector3d vector3d = (Vector3d)object;
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    @Override
    public void read(g g2, Element element) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void write(l l2, Element element) {
        throw new RuntimeException("Not Implemented");
    }
}

