/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.graphics.interpolate;

import jp.noids.graphics.interpolate.IEasing;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class SimpleEasing
implements IEasing {
    double[] x_curve_2;
    double d;
    double easeIn;
    double easeOut;

    public SimpleEasing() {
        this.setEasing(0.0, 0.0);
    }

    public SimpleEasing(double d2, double d3) {
        this.setEasing(d2, d3);
    }

    public void setEasing(double d2, double d3) {
        this.easeIn = d2;
        this.easeOut = d3;
        if (d2 == 0.0 && d3 == 0.0) {
            this.x_curve_2 = null;
            return;
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("must be 0..1 : " + d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("must be 0..1 : " + d3);
        }
        double d4 = d2;
        double d5 = d3;
        double d6 = 0.3333333333333333;
        double d7 = 0.6666666666666666;
        double d8 = 1.0 - (1.0 - d4) * (1.0 - d4);
        double d9 = 1.0 - (1.0 - d5) * (1.0 - d5);
        double d10 = 0.0;
        double d11 = (1.0 - d4) * d6 * d8 + (d5 * d7 + (1.0 - d5) * d6) * (1.0 - d8);
        double d12 = (d5 + (1.0 - d5) * d7) * d9 + (d4 * d6 + (1.0 - d4) * d7) * (1.0 - d9);
        double d13 = 1.0;
        double d14 = d13 - 3.0 * d12 + 3.0 * d11 - d10;
        double d15 = 3.0 * d12 - 6.0 * d11 + 3.0 * d10;
        double d16 = 3.0 * d11 - 3.0 * d10;
        double d17 = d10;
        this.x_curve_2 = new double[]{d17, d16, d15, d14};
        this.d = d17;
    }

    @Override
    public double getT(double d2, Object object) {
        if (this.x_curve_2 == null) {
            return d2;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            return 1.0;
        }
        double d3 = d2;
        double d4 = d3 * d3;
        double d5 = d3 * d4;
        double d6 = this.x_curve_2[3] * d5 + this.x_curve_2[2] * d4 + this.x_curve_2[1] * d3 + this.d;
        return d6;
    }

    public static void main(String[] stringArray) {
        SimpleEasing simpleEasing = new SimpleEasing(0.57, 0.8);
        int n2 = 20;
        int n3 = 0;
        while (n3 <= n2) {
            double d2 = (double)n3 / (double)n2;
            double d3 = simpleEasing.getT(d2, null);
            System.out.println(String.format(" t %1.3f : %1.4f ( % 1.4f )", d2, d3, d3 - d2));
            ++n3;
        }
    }

    public double getEaseIn() {
        return this.easeIn;
    }

    public void setEaseIn(double d2) {
        this.setEasing(d2, this.easeOut);
    }

    public double getEaseOut() {
        return this.easeOut;
    }

    public void setEaseOut(double d2) {
        this.setEasing(this.easeIn, d2);
    }

    @Override
    public void read(g g2, Element element) {
        this.d = g2.c(element, "d");
        this.easeIn = g2.c(element, "easeIn");
        this.easeOut = g2.c(element, "easeOut");
        this.x_curve_2 = (double[])g2.a(element, "x_curve_2");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "d", this.d);
        l2.a(element, "easeIn", this.easeIn);
        l2.a(element, "easeOut", this.easeOut);
        l2.a(element, "x_curve_2", this.x_curve_2);
    }
}

