/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.bezierGrid;

import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.e.a.a;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.AbstractGrid;
import jp.noids.grid.IGrid;
import jp.noids.grid.b;
import jp.noids.util.L;
import jp.noids.util.c;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class SimpleGrid
extends AbstractGrid
implements IGrid {
    int col;
    int row;
    double[] points;
    boolean dirty = true;
    transient i rect = null;
    long lastUpdated;

    public SimpleGrid() {
    }

    public SimpleGrid(int n2, int n3, double[] dArray) {
        this.col = n2;
        this.row = n3;
        this.points = dArray;
    }

    public void applyTransform(ITransform iTransform) {
        iTransform.transform(this.points, 0, this.points, 0, this.points.length / 2);
        this.setDirty();
    }

    public double[] getPoints() {
        return this.points;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    @Override
    public double[] get01(double d2, double d3, double[] dArray) {
        int n2 = this.col + 1;
        i i2 = this.getBoundsRect();
        if (!i2.contains(d2, d3)) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.row) {
            int n4 = 0;
            while (n4 < this.col) {
                double d4 = this.points[2 * (n4 + n3 * n2)];
                double d5 = this.points[2 * (n4 + n3 * n2) + 1];
                double d6 = this.points[2 * (n4 + 1 + n3 * n2)];
                double d7 = this.points[2 * (n4 + 1 + n3 * n2) + 1];
                double d8 = this.points[2 * (n4 + (n3 + 1) * n2)];
                double d9 = this.points[2 * (n4 + (n3 + 1) * n2) + 1];
                double d10 = this.points[2 * (n4 + 1 + (n3 + 1) * n2)];
                double d11 = this.points[2 * (n4 + 1 + (n3 + 1) * n2) + 1];
                double[] dArray2 = b.a(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, dArray);
                if (dArray2 != null) {
                    dArray2[0] = ((double)n4 + dArray2[0]) / (double)this.col;
                    dArray2[1] = ((double)n3 + dArray2[1]) / (double)this.row;
                    return dArray2;
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public double[] getPt(double d2, double d3, double[] dArray) {
        int n2 = (int)(d2 * (double)this.col);
        int n3 = (int)(d3 * (double)this.row);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.col - 1) {
            n2 = this.col - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.row - 1) {
            n3 = this.row - 1;
        }
        double d4 = d2 * (double)this.col - (double)n2;
        if (d4 < 0.0) {
            d4 = 0.0;
        } else if (d4 > 1.0) {
            d4 = 1.0;
        }
        double d5 = d3 * (double)this.row - (double)n3;
        if (d5 < 0.0) {
            d5 = 0.0;
        } else if (d5 > 1.0) {
            d5 = 1.0;
        }
        int n4 = this.col + 1;
        if (d4 + d5 < 1.0) {
            double d6 = this.points[2 * (n2 + n3 * n4)];
            double d7 = this.points[2 * (n2 + n3 * n4) + 1];
            double d8 = this.points[2 * (n2 + 1 + n3 * n4)];
            double d9 = this.points[2 * (n2 + 1 + n3 * n4) + 1];
            double d10 = this.points[2 * (n2 + (n3 + 1) * n4)];
            double d11 = this.points[2 * (n2 + (n3 + 1) * n4) + 1];
            dArray[0] = d6 + d4 * (d8 - d6) + d5 * (d10 - d6);
            dArray[1] = d7 + d4 * (d9 - d7) + d5 * (d11 - d7);
        } else {
            double d12 = this.points[2 * (n2 + 1 + n3 * n4)];
            double d13 = this.points[2 * (n2 + 1 + n3 * n4) + 1];
            double d14 = this.points[2 * (n2 + (n3 + 1) * n4)];
            double d15 = this.points[2 * (n2 + (n3 + 1) * n4) + 1];
            double d16 = this.points[2 * (n2 + 1 + (n3 + 1) * n4)];
            double d17 = this.points[2 * (n2 + 1 + (n3 + 1) * n4) + 1];
            dArray[0] = d16 + (1.0 - d4) * (d14 - d16) + (1.0 - d5) * (d12 - d16);
            dArray[1] = d17 + (1.0 - d4) * (d15 - d17) + (1.0 - d5) * (d13 - d17);
        }
        return dArray;
    }

    @Override
    public i getBoundsRect() {
        if (this.rect == null) {
            int n2 = this.points.length;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            double d5 = Double.NEGATIVE_INFINITY;
            int n3 = 0;
            while (n3 < n2) {
                double d6 = this.points[n3];
                double d7 = this.points[n3 + 1];
                if (d6 > d4) {
                    d4 = d6;
                }
                if (d7 > d5) {
                    d5 = d7;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (d7 < d3) {
                    d3 = d7;
                }
                n3 += 2;
            }
            this.rect = new i(d2, d3, d4 - d2, d5 - d3);
        }
        return this.rect;
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        SimpleGrid simpleGrid = (SimpleGrid)iInterpolatable;
        if (this.col != simpleGrid.col || this.row != simpleGrid.row) {
            throw new RuntimeException("Illegal state :_");
        }
        SimpleGrid simpleGrid2 = new SimpleGrid();
        simpleGrid2.col = this.col;
        simpleGrid2.row = this.row;
        int n2 = this.points.length;
        simpleGrid2.points = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            simpleGrid2.points[n3] = this.points[n3] + (simpleGrid.points[n3] - this.points[n3]) * d2;
            ++n3;
        }
        return simpleGrid2;
    }

    @Override
    public boolean canInterpolate(IGrid iGrid) {
        if (!(iGrid instanceof SimpleGrid)) {
            return false;
        }
        SimpleGrid simpleGrid = (SimpleGrid)iGrid;
        return this.col == simpleGrid.col && this.row == simpleGrid.row;
    }

    @Override
    public Object deepClone() {
        SimpleGrid simpleGrid = new SimpleGrid();
        simpleGrid.init(this);
        return simpleGrid;
    }

    @Override
    public void init(Object object) {
        SimpleGrid simpleGrid = (SimpleGrid)object;
        this.col = simpleGrid.col;
        this.row = simpleGrid.row;
        this.points = c.a(simpleGrid.points);
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.col = g2.b(element, "col");
        this.row = g2.b(element, "row");
        this.points = (double[])g2.a(element, "points");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "col", this.col);
        l2.a(element, "row", this.row);
        l2.a(element, "points", this.points);
    }

    @Override
    public void readV1(a a2) {
        this.col = a2.c();
        this.row = a2.c();
        this.points = (double[])a2.i();
    }

    @Override
    public void writeV1(jp.noids.e.a.b b2) {
        b2.a(this.col);
        b2.a(this.row);
        b2.c(this.points);
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.rect = null;
        this.lastUpdated = System.currentTimeMillis();
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    @Override
    public void dump() {
        System.out.printf("SimpleGrid %d,%d = { %s }\n", this.col, this.row, L.a(this.points));
    }

    @Override
    public jp.noids.graphics.c.c getNearestPointRef(g g2, ITransform iTransform, boolean bl2) {
        throw new RuntimeException("Not supported _");
    }

    @Override
    public jp.noids.graphics.c.c[] getAllPointRef(ITransform iTransform, boolean bl2) {
        throw new RuntimeException("Not supported _");
    }

    @Override
    public jp.noids.graphics.c.c getCompatiblePointRef(jp.noids.graphics.c.c c2, ITransform iTransform) {
        throw new RuntimeException("Not supported _");
    }

    @Override
    public void verify() {
    }
}

