/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.boxGrid;

import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.c.c;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.interpolate.a;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.AbstractGrid;
import jp.noids.grid.IGrid;
import jp.noids.grid.b;
import jp.noids.util.L;
import jp.noids.util.ap;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class Box
extends AbstractGrid
implements IGrid {
    g nw;
    g ne;
    g sw;
    g se;
    final transient i boundsRect = new i();
    transient boolean dirty = true;
    long lastUpdated;

    public Box() {
    }

    public Box(i i2) {
        this(new g(i2.x, i2.y), new g(i2.x + i2.width, i2.y), new g(i2.x, i2.y + i2.height), new g(i2.x + i2.width, i2.y + i2.height));
    }

    public Box(g g2, g g3, g g4, g g5) {
        this.nw = g2;
        this.ne = g3;
        this.sw = g4;
        this.se = g5;
    }

    private void update() {
        m.a(this.nw, this.ne, this.sw, this.se, this.boundsRect);
        this.dirty = false;
    }

    public boolean isCCW() {
        throw new RuntimeException("Not supported");
    }

    public boolean isFore() {
        double d2 = this.ne.x - this.nw.x;
        double d3 = this.ne.y - this.nw.y;
        double d4 = this.sw.x - this.nw.x;
        double d5 = this.sw.y - this.nw.y;
        double d6 = ap.b(d2, d3, d4, d5);
        if (d6 < 0.0) {
            return false;
        }
        d2 = this.sw.x - this.se.x;
        d3 = this.sw.y - this.se.y;
        d4 = this.ne.x - this.se.x;
        d5 = this.ne.y - this.se.y;
        d6 = ap.b(d2, d3, d4, d5);
        return !(d6 < 0.0);
    }

    @Override
    public double[] get01(double d2, double d3, double[] dArray) {
        if (this.dirty) {
            this.update();
        }
        if (!this.boundsRect.contains(d2, d3)) {
            return null;
        }
        return b.a(d2, d3, this.nw, this.ne, this.sw, this.se, dArray);
    }

    @Override
    public double[] getPt(double d2, double d3, double[] dArray) {
        if (d2 + d3 <= 1.0) {
            dArray[0] = this.nw.x + (this.ne.x - this.nw.x) * d2 + (this.sw.x - this.nw.x) * d3;
            dArray[1] = this.nw.y + (this.ne.y - this.nw.y) * d2 + (this.sw.y - this.nw.y) * d3;
        } else {
            dArray[0] = this.se.x + (this.sw.x - this.se.x) * (1.0 - d2) + (this.ne.x - this.se.x) * (1.0 - d3);
            dArray[1] = this.se.y + (this.sw.y - this.se.y) * (1.0 - d2) + (this.ne.y - this.se.y) * (1.0 - d3);
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        Box box = new Box(new i(100.0, 0.0, 100.0, 200.0));
        double[] dArray = new double[2];
        double[] dArray2 = box.getPt(0.5, 0.5, dArray);
        System.out.println("" + dArray2[0]);
        System.out.println("" + dArray2[1]);
    }

    public g getNE() {
        return this.ne;
    }

    public g getNW() {
        return this.nw;
    }

    public g getSE() {
        return this.se;
    }

    public g getSW() {
        return this.sw;
    }

    public void setNE(g g2) {
        this.ne = g2;
    }

    public void setNW(g g2) {
        this.nw = g2;
    }

    public void setSE(g g2) {
        this.se = g2;
    }

    public void setSW(g g2) {
        this.sw = g2;
    }

    @Override
    public i getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        return this.boundsRect;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.lastUpdated = System.currentTimeMillis();
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    @Override
    public void dump() {
        System.out.println("BOX : nw = " + L.a(this.nw) + " / ne = " + L.a(this.ne) + " / sw = " + L.a(this.sw) + " / se = " + L.a(this.se));
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (!(iInterpolatable instanceof Box)) {
            throw new a(String.valueOf(a.b.a("CUBI-1123")) + this + " / " + iInterpolatable);
        }
        Box box = this;
        Box box2 = (Box)iInterpolatable;
        Box box3 = new Box(jp.noids.graphics.interpolate.b.a(box.nw, box2.nw, d2, null), jp.noids.graphics.interpolate.b.a(box.ne, box2.ne, d2, null), jp.noids.graphics.interpolate.b.a(box.sw, box2.sw, d2, null), jp.noids.graphics.interpolate.b.a(box.se, box2.se, d2, null));
        return box3;
    }

    @Override
    public boolean canInterpolate(IGrid iGrid) {
        return iGrid instanceof Box;
    }

    @Override
    public Object deepClone() {
        Box box = new Box(m.a(this.nw), m.a(this.ne), m.a(this.sw), m.a(this.se));
        return box;
    }

    @Override
    public void init(Object object) {
        Box box = (Box)object;
        this.nw = m.a(box.nw);
        this.ne = m.a(box.ne);
        this.sw = m.a(box.sw);
        this.se = m.a(box.se);
        this.setDirty();
    }

    @Override
    public void readV1(jp.noids.e.a.a a2) {
        this.nw = a2.n();
        this.ne = a2.n();
        this.sw = a2.n();
        this.se = a2.n();
        this.update();
    }

    @Override
    public void writeV1(jp.noids.e.a.b b2) {
        b2.a(this.nw);
        b2.a(this.ne);
        b2.a(this.sw);
        b2.a(this.se);
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.nw = (g)g2.a(element, "nw");
        this.ne = (g)g2.a(element, "ne");
        this.sw = (g)g2.a(element, "sw");
        this.se = (g)g2.a(element, "se");
        this.update();
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "nw", this.nw);
        l2.a(element, "ne", this.ne);
        l2.a(element, "sw", this.sw);
        l2.a(element, "se", this.se);
    }

    @Override
    public c getCompatiblePointRef(c c2, ITransform iTransform) {
        throw new RuntimeException(a.b.a("CUBI-1125"));
    }

    @Override
    public c getNearestPointRef(g g2, ITransform iTransform, boolean bl2) {
        throw new RuntimeException(a.b.a("CUBI-1125"));
    }

    @Override
    public c[] getAllPointRef(ITransform iTransform, boolean bl2) {
        throw new RuntimeException(a.b.a("CUBI-1125"));
    }

    @Override
    public void verify() {
    }
}

