/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.boxGrid;

import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.e.a.a;
import jp.noids.graphics.c.c;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.AbstractGrid;
import jp.noids.grid.IGrid;
import jp.noids.grid.b;
import jp.noids.grid.boxGrid.Box;
import jp.noids.util.aj;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BoxGrid
extends AbstractGrid
implements IGrid {
    static final boolean OPTIMIZE_ON = true;
    transient boolean dirty = true;
    Box[][] boxes;
    transient i bounds;
    long lastUpdated;

    public BoxGrid() {
    }

    public BoxGrid(Box[][] boxArray) {
        this.boxes = boxArray;
    }

    @Override
    public i getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        return this.bounds;
    }

    public int getCol() {
        return this.boxes.length;
    }

    public int getRow() {
        return this.boxes[0].length;
    }

    public Box getBox(int n2, int n3) {
        return this.boxes[n2][n3];
    }

    @Override
    public double[] get01(double d2, double d3, double[] dArray) {
        return this.get01_normal(d2, d3, dArray);
    }

    protected double[] get01_normal(double d2, double d3, double[] dArray) {
        if (this.boxes == null) {
            return null;
        }
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                Box box = this.boxes[n5][n4];
                double[] dArray2 = box.get01(d2, d3, dArray);
                if (dArray2 != null) {
                    dArray2[0] = ((double)n5 + dArray2[0]) / (double)n2;
                    dArray2[1] = ((double)n4 + dArray2[1]) / (double)n3;
                    return dArray2;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    @Override
    public double[] getPt(double d2, double d3, double[] dArray) {
        if (this.boxes == null) {
            return null;
        }
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = (int)(d2 * (double)n2);
        int n5 = (int)(d3 * (double)n3);
        Box box = this.boxes[n4][n5];
        return box.getPt(b.a(n2, d2), b.a(n3, d3), dArray);
    }

    public static void main(String[] stringArray) {
        Box[][] boxArray = new Box[2][2];
        boxArray[0][0] = new Box(new i(0.0, 0.0, 50.0, 100.0));
        boxArray[1][0] = new Box(new i(50.0, 0.0, 50.0, 100.0));
        boxArray[0][1] = new Box(new i(0.0, 100.0, 50.0, 100.0));
        boxArray[1][1] = new Box(new i(50.0, 100.0, 50.0, 100.0));
        BoxGrid boxGrid = new BoxGrid(boxArray);
        System.out.println("bg.getBoundsRect() : " + boxGrid.getBoundsRect());
        double[] dArray = new double[2];
        double[] dArray2 = boxGrid.getPt(0.2, 0.7, dArray);
        System.out.println("r[0] : " + dArray2[0]);
        System.out.println("r[1] : " + dArray2[1]);
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.lastUpdated = System.currentTimeMillis();
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    private void update() {
        this.bounds = m.a(this.boxes);
    }

    @Override
    public void dump() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                Box box = this.boxes[n5][n4];
                System.out.println("===========================================");
                System.out.println("Box [" + n5 + "][" + n4 + "]");
                aj.a(4);
                box.dump();
                aj.a(-4);
                ++n5;
            }
            ++n4;
        }
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (!(iInterpolatable instanceof BoxGrid)) {
            throw new jp.noids.graphics.interpolate.a(String.valueOf(a.b.a("CUBI-1123")) + this + " / " + iInterpolatable);
        }
        BoxGrid boxGrid = this;
        BoxGrid boxGrid2 = (BoxGrid)iInterpolatable;
        int n2 = boxGrid.getCol();
        int n3 = boxGrid.getRow();
        if (boxGrid.getCol() != boxGrid2.getCol() || boxGrid.getCol() != boxGrid2.getCol()) {
            throw new jp.noids.graphics.interpolate.a(a.b.a("CUBI-1124"));
        }
        Box[][] boxArray = new Box[n2][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                Box box;
                boxArray[n5][n4] = box = (Box)boxGrid.boxes[n5][n4].interpolate(boxGrid2.boxes[n5][n4], d2);
                ++n5;
            }
            ++n4;
        }
        BoxGrid boxGrid3 = new BoxGrid(boxArray);
        return boxGrid3;
    }

    @Override
    public Object deepClone() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        Box[][] boxArray = new Box[n2][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                Box box;
                this.boxes[n5][n4] = box = (Box)this.boxes[n5][n4].deepClone();
                ++n5;
            }
            ++n4;
        }
        BoxGrid boxGrid = new BoxGrid(boxArray);
        return boxGrid;
    }

    @Override
    public void init(Object object) {
        BoxGrid boxGrid = (BoxGrid)object;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = boxGrid.getCol();
        int n5 = boxGrid.getRow();
        if (n2 != n4 || n3 != n5) {
            this.boxes = new Box[n4][n5];
        }
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n4) {
                Box box;
                this.boxes[n7][n6] = box = (Box)boxGrid.boxes[n7][n6].deepClone();
                ++n7;
            }
            ++n6;
        }
        this.setDirty();
    }

    @Override
    public boolean canInterpolate(IGrid iGrid) {
        if (!(iGrid instanceof BoxGrid)) {
            return false;
        }
        BoxGrid boxGrid = (BoxGrid)iGrid;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = boxGrid.getCol();
        int n5 = boxGrid.getRow();
        return n2 == n4 && n3 == n5;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.boxes = (Box[][])g2.a(element, "boxes");
        this.setDirty();
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "boxes", this.boxes);
    }

    @Override
    public void readV1(a a2) {
        this.boxes = (Box[][])a2.i();
        this.setDirty();
    }

    @Override
    public void writeV1(jp.noids.e.a.b b2) {
        b2.c(this.boxes);
    }

    @Override
    public c getCompatiblePointRef(c c2, ITransform iTransform) {
        throw new RuntimeException(a.b.a("CUBI-1125"));
    }

    @Override
    public c getNearestPointRef(g g2, ITransform iTransform, boolean bl2) {
        throw new RuntimeException(a.b.a("CUBI-1125"));
    }

    @Override
    public c[] getAllPointRef(ITransform iTransform, boolean bl2) {
        throw new RuntimeException(a.b.a("CUBI-1125"));
    }

    @Override
    public void verify() {
    }
}

