/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.compositeGrid;

import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.e.a.a;
import jp.noids.e.a.b;
import jp.noids.graphics.c.c;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.AbstractGrid;
import jp.noids.grid.IGrid;
import jp.noids.util.C;
import jp.noids.util.L;
import jp.noids.util.aj;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class CompositeGrid
extends AbstractGrid
implements IGrid {
    private static boolean DEBUG = false;
    IGrid[][] grid;
    transient boolean dirty = true;
    transient i buffRect;
    long lastUpdated;

    static {
        if (DEBUG && C.e()) {
            System.out.println(" < DEBUG : jp.noids.grid.compositeGrid.CompositeGrid > ");
        }
    }

    public CompositeGrid() {
    }

    public CompositeGrid(IGrid[][] iGridArray) {
        if (iGridArray == null || iGridArray.length < 1) {
            throw new RuntimeException(String.valueOf(a.b.a("CUBI-1126")) + iGridArray);
        }
        this.grid = iGridArray;
    }

    @Override
    public double[] get01(double d2, double d3, double[] dArray) {
        if (this.dirty) {
            this.update();
        }
        if (!this.getBoundsRect().contains(d2, d3)) {
            return null;
        }
        int n2 = this.grid.length;
        int n3 = this.grid[0].length;
        int n4 = 0;
        while (n4 < n2) {
            IGrid[] iGridArray = this.grid[n4];
            int n5 = 0;
            while (n5 < n3) {
                double[] dArray2 = iGridArray[n5].get01(d2, d3, dArray);
                if (dArray2 != null) {
                    dArray2[0] = ((double)n4 + dArray2[0]) / (double)n2;
                    dArray2[1] = ((double)n5 + dArray2[1]) / (double)n3;
                    return dArray2;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    @Override
    public double[] getPt(double d2, double d3, double[] dArray) {
        if (this.dirty) {
            this.update();
        }
        int n2 = this.grid.length;
        int n3 = this.grid[0].length;
        int n4 = (int)(d2 * (double)n2);
        int n5 = (int)(d3 * (double)n3);
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n2 - 1) {
            n4 = n2 - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > n3 - 1) {
            n5 = n3 - 1;
        }
        double d4 = d2 * (double)n2 - (double)n4;
        if (d4 < 0.0) {
            d4 = 0.0;
        } else if (d4 > 1.0) {
            d4 = 1.0;
        }
        double d5 = d3 * (double)n3 - (double)n5;
        if (d5 < 0.0) {
            d5 = 0.0;
        } else if (d5 > 1.0) {
            d5 = 1.0;
        }
        return this.grid[n4][n5].getPt(d4, d5, dArray);
    }

    public int getCol() {
        return this.grid.length;
    }

    public int getRow() {
        return this.grid[0].length;
    }

    public void setGrid(IGrid[][] iGridArray) {
        this.grid = iGridArray;
    }

    public IGrid[][] getGrid() {
        return this.grid;
    }

    @Override
    public i getBoundsRect() {
        if (this.dirty) {
            this.update();
        }
        return this.buffRect;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
        this.lastUpdated = System.currentTimeMillis();
        int n2 = this.grid.length;
        int n3 = this.grid[0].length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                this.grid[n5][n4].setDirty();
                ++n5;
            }
            ++n4;
        }
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    private void update() {
        this.buffRect = m.a(this.grid);
        this.dirty = false;
    }

    @Override
    public void dump() {
        aj.a();
        String string = "";
        int n2 = this.grid.length;
        int n3 = this.grid[0].length;
        System.out.println("COMPOSITE " + L.a(this.getBoundsRect()));
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                aj.a(4);
                this.grid[n5][n4].dump();
                aj.a(-4);
                ++n5;
            }
            ++n4;
        }
        System.out.println("");
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (!(iInterpolatable instanceof CompositeGrid)) {
            throw new jp.noids.graphics.interpolate.a(String.valueOf(a.b.a("CUBI-1123")) + this + " / " + iInterpolatable);
        }
        CompositeGrid compositeGrid = this;
        CompositeGrid compositeGrid2 = (CompositeGrid)iInterpolatable;
        int n2 = compositeGrid.getCol();
        int n3 = compositeGrid.getRow();
        if (compositeGrid.getCol() != compositeGrid2.getCol() || compositeGrid.getCol() != compositeGrid2.getCol()) {
            throw new jp.noids.graphics.interpolate.a(a.b.a("CUBI-1124"));
        }
        IGrid[][] iGridArray = new IGrid[n2][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                IGrid iGrid;
                iGridArray[n5][n4] = iGrid = (IGrid)compositeGrid.grid[n5][n4].interpolate(compositeGrid2.grid[n5][n4], d2);
                ++n5;
            }
            ++n4;
        }
        CompositeGrid compositeGrid3 = new CompositeGrid(iGridArray);
        return compositeGrid3;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.grid = (IGrid[][])g2.a(element, "grid");
        this.setDirty();
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "grid", this.grid);
    }

    @Override
    public void readV1(a a2) {
        this.grid = (IGrid[][])a2.i();
        this.setDirty();
    }

    @Override
    public void writeV1(b b2) {
        b2.c(this.grid);
    }

    @Override
    public Object deepClone() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        IGrid[][] iGridArray = new IGrid[n2][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                iGridArray[n5][n4] = (IGrid)this.grid[n5][n4].deepClone();
                ++n5;
            }
            ++n4;
        }
        CompositeGrid compositeGrid = new CompositeGrid(iGridArray);
        return compositeGrid;
    }

    @Override
    public void init(Object object) {
        CompositeGrid compositeGrid = (CompositeGrid)object;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = compositeGrid.getCol();
        int n5 = compositeGrid.getRow();
        if (n2 != n4 || n3 != n5) {
            this.grid = new IGrid[n4][n5];
        }
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n4) {
                IGrid iGrid;
                this.grid[n7][n6] = iGrid = (IGrid)compositeGrid.grid[n7][n6].deepClone();
                ++n7;
            }
            ++n6;
        }
        this.setDirty();
    }

    @Override
    public boolean canInterpolate(IGrid iGrid) {
        if (!(iGrid instanceof CompositeGrid)) {
            return false;
        }
        CompositeGrid compositeGrid = (CompositeGrid)iGrid;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = compositeGrid.getCol();
        int n5 = compositeGrid.getRow();
        if (this.updateManager != compositeGrid.updateManager) {
            return false;
        }
        return n2 == n4 && n3 == n5;
    }

    @Override
    public c getNearestPointRef(g g2, ITransform iTransform, boolean bl2) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public c[] getAllPointRef(ITransform iTransform, boolean bl2) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public c getCompatiblePointRef(c c2, ITransform iTransform) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void verify() {
    }
}

