/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.grid3d;

import a.b;
import java.util.ArrayList;
import jp.noids.graphics.threeD.Angle3D;
import jp.noids.grid.grid3d.GridData;
import jp.noids.grid.pointGrid.GridPt;
import jp.noids.grid.pointGrid.PointGrid;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class Grid3D
implements h {
    ArrayList grids = new ArrayList();

    public void addGrid(GridData gridData) {
        this.grids.add(gridData);
    }

    public ArrayList getGrids() {
        return this.grids;
    }

    public GridData getGrid(Angle3D angle3D) {
        h h2;
        GridData gridData;
        GridData gridData2 = this.getGridData(angle3D);
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        Object object = this.grids.iterator();
        while (object.hasNext()) {
            gridData2 = gridData = (GridData)object.next();
            h2 = gridData.getAngle();
            if (h2.x <= angle3D.x && d2 <= h2.x) {
                d2 = h2.x;
            }
            if (h2.x >= angle3D.x && h2.x <= d4) {
                d4 = h2.x;
            }
            if (h2.y <= angle3D.y && d3 <= h2.y) {
                d3 = h2.y;
            }
            if (!(h2.y >= angle3D.y) || !(h2.y <= d5)) continue;
            d5 = h2.y;
        }
        object = this.getGridData(new Angle3D(d2, d5, 0.0));
        gridData = this.getGridData(new Angle3D(d4, d5, 0.0));
        h2 = this.getGridData(new Angle3D(d2, d3, 0.0));
        GridData gridData3 = this.getGridData(new Angle3D(d4, d3, 0.0));
        if (object == null || gridData == null || h2 == null || gridData3 == null) {
            throw new RuntimeException(b.a("CUBI-1127"));
        }
        GridData gridData4 = this.createNaibunGrid(angle3D, (GridData)object, gridData, (GridData)h2, gridData3);
        return gridData4;
    }

    private GridData getGridData(Angle3D angle3D) {
        for (GridData gridData : this.grids) {
            PointGrid pointGrid = gridData.getGrid();
            if (!gridData.getAngle().equals(angle3D)) continue;
            return gridData;
        }
        return null;
    }

    public GridData createNaibunGrid(Angle3D angle3D, GridData gridData, GridData gridData2, GridData gridData3, GridData gridData4) {
        boolean bl2 = gridData == gridData2;
        boolean bl3 = gridData == gridData3;
        Angle3D angle3D2 = gridData.getAngle();
        Angle3D angle3D3 = gridData2.getAngle();
        Angle3D angle3D4 = gridData3.getAngle();
        Angle3D angle3D5 = gridData4.getAngle();
        if (angle3D2.x != angle3D4.x || angle3D3.x != angle3D5.x || angle3D2.y != angle3D3.y || angle3D4.y != angle3D5.y) {
            throw new RuntimeException(b.a("CUBI-1128"));
        }
        double d2 = angle3D3.x - angle3D2.x;
        double d3 = angle3D2.y - angle3D4.y;
        double d4 = bl2 ? 1.0 : (angle3D.x - angle3D2.x) / d2;
        double d5 = bl3 ? 1.0 : (angle3D2.y - angle3D.y) / d3;
        int n2 = gridData.getGrid().getCol();
        int n3 = gridData.getGrid().getRow();
        PointGrid pointGrid = new PointGrid(n2, n3, gridData.getGrid().getFlags());
        GridPt[][] gridPtArray = pointGrid.getPt();
        GridPt[][] gridPtArray2 = gridData.getGrid().getPt();
        GridPt[][] gridPtArray3 = gridData2.getGrid().getPt();
        GridPt[][] gridPtArray4 = gridData3.getGrid().getPt();
        GridPt[][] gridPtArray5 = gridData4.getGrid().getPt();
        int n4 = 0;
        while (n4 < gridPtArray.length) {
            int n5 = 0;
            while (n5 < gridPtArray[n4].length) {
                gridPtArray[n4][n5].x = (float)(gridPtArray2[n4][n5].x * (1.0 - d5) * (1.0 - d4) + gridPtArray4[n4][n5].x * d5 * (1.0 - d4) + gridPtArray3[n4][n5].x * (1.0 - d5) * d4 + gridPtArray5[n4][n5].x * d5 * d4);
                gridPtArray[n4][n5].y = (float)(gridPtArray2[n4][n5].y * (1.0 - d5) * (1.0 - d4) + gridPtArray4[n4][n5].y * d5 * (1.0 - d4) + gridPtArray3[n4][n5].y * (1.0 - d5) * d4 + gridPtArray5[n4][n5].y * d5 * d4);
                ++n5;
            }
            ++n4;
        }
        return new GridData(pointGrid, angle3D);
    }

    public PointGrid createNaibunGrid_ex(Angle3D angle3D, GridData gridData, GridData gridData2, GridData gridData3, GridData gridData4) {
        boolean bl2 = gridData == gridData2;
        boolean bl3 = gridData == gridData3;
        Angle3D angle3D2 = gridData.getAngle();
        Angle3D angle3D3 = gridData2.getAngle();
        Angle3D angle3D4 = gridData3.getAngle();
        Angle3D angle3D5 = gridData4.getAngle();
        if (angle3D2.x != angle3D4.x || angle3D3.x != angle3D5.x || angle3D2.y != angle3D3.y || angle3D4.y != angle3D5.y) {
            throw new RuntimeException(b.a("CUBI-1128"));
        }
        double d2 = angle3D3.x - angle3D2.x;
        double d3 = angle3D2.y - angle3D4.y;
        double d4 = bl2 ? 1.0 : (angle3D.x - angle3D2.x) / d2;
        double d5 = bl3 ? 1.0 : (angle3D2.y - angle3D.y) / d3;
        int n2 = gridData.getGrid().getCol();
        int n3 = gridData.getGrid().getRow();
        PointGrid pointGrid = new PointGrid(n2, n3, gridData.getGrid().getFlags());
        GridPt[][] gridPtArray = pointGrid.getPt();
        GridPt[][] gridPtArray2 = gridData.getGrid().getPt();
        GridPt[][] gridPtArray3 = gridData2.getGrid().getPt();
        GridPt[][] gridPtArray4 = gridData3.getGrid().getPt();
        GridPt[][] gridPtArray5 = gridData4.getGrid().getPt();
        int n4 = 0;
        while (n4 < gridPtArray.length) {
            int n5 = 0;
            while (n5 < gridPtArray[n4].length) {
                gridPtArray[n4][n5].x = (float)(gridPtArray2[n4][n5].x * (1.0 - d5) * (1.0 - d4) + gridPtArray4[n4][n5].x * d5 * (1.0 - d4) + gridPtArray3[n4][n5].x * (1.0 - d5) * d4 + gridPtArray5[n4][n5].x * d5 * d4);
                gridPtArray[n4][n5].y = (float)(gridPtArray2[n4][n5].y * (1.0 - d5) * (1.0 - d4) + gridPtArray4[n4][n5].y * d5 * (1.0 - d4) + gridPtArray3[n4][n5].y * (1.0 - d5) * d4 + gridPtArray5[n4][n5].y * d5 * d4);
                ++n5;
            }
            ++n4;
        }
        return pointGrid;
    }

    private void dump(Angle3D angle3D, Angle3D angle3D2, Angle3D angle3D3, Angle3D angle3D4, double d2, double d3) {
        System.out.println("angle x : " + angle3D.getX_asDeg());
        System.out.println("angle y : " + angle3D.getY_asDeg());
        System.out.println("angle x : " + angle3D.getX());
        System.out.println("angle y : " + angle3D.getY());
        System.out.println(String.valueOf(b.a("CUBI-1129")) + angle3D2.getX_asDeg());
        System.out.println(String.valueOf(b.a("CUBI-1130")) + angle3D3.getX_asDeg());
        System.out.println(String.valueOf(b.a("CUBI-1131")) + angle3D2.getY_asDeg());
        System.out.println(String.valueOf(b.a("CUBI-1132")) + angle3D4.getY_asDeg());
        System.out.println("t_x : " + d2);
        System.out.println("t_y : " + d3);
        System.out.println("--------------------------");
    }

    public static Grid3D createSample() {
        double[] dArray = Grid3D.createArray(-30, 30, 30);
        double[] dArray2 = Grid3D.createArray(-60, 60, 30);
        Grid3D grid3D = new Grid3D();
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = 0;
            while (n3 < dArray2.length) {
                Angle3D angle3D = new Angle3D(dArray2[n3] * (Math.PI / 180), dArray[n2] * (Math.PI / 180), 0.0);
                PointGrid pointGrid = PointGrid.createSample(angle3D);
                grid3D.addGrid(new GridData(pointGrid, angle3D));
                ++n3;
            }
            ++n2;
        }
        return grid3D;
    }

    private static double[] createArray(int n2, int n3, int n4) {
        int n5 = 1 + (n3 - n2) / n4;
        double[] dArray = new double[n5];
        int n6 = 0;
        while (n6 < dArray.length) {
            dArray[n6] = n2 + n6 * n4;
            ++n6;
        }
        return dArray;
    }

    @Override
    public void read(g g2, Element element) {
        this.grids = (ArrayList)g2.a(element, "grids");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, "grids", this.grids);
    }
}

