/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.grid.pointGrid;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.live2d.type_editor.LDColor;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.c.c;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.m;
import jp.noids.graphics.threeD.Angle3D;
import jp.noids.graphics.transform.ITransform;
import jp.noids.grid.AbstractGrid;
import jp.noids.grid.IEditableGrid;
import jp.noids.grid.IGrid;
import jp.noids.grid.b;
import jp.noids.grid.pointGrid.GridPolygon;
import jp.noids.grid.pointGrid.GridPt;
import jp.noids.grid.pointGrid.GridPtBox;
import jp.noids.util.aj;
import jp.noids.util.ap;
import jp.noids.util.az;
import jp.noids.xml.serialize.h;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class PointGrid
extends AbstractGrid
implements IEditableGrid,
IGrid,
jp.noids.model3Dp.a,
h {
    public static final int FLAG_NO_LOOP = 0;
    public static final int FLAG_LOOP_X = 2;
    public static final int FLAG_LOOP_Y = 4;
    public static final int FLAG_LOOP_BOTH = 6;
    protected GridPt[][] pt;
    protected int flags;
    int transformCol = -1;
    int transformRow = -1;
    public static final int DIR_FORE = 0;
    public static final int DIR_BOTH = 1;
    public static final int DIR_BACK = 2;
    static boolean isFirstCallOf_getPt = true;
    long lastUpdated;

    public PointGrid() {
    }

    public PointGrid(int n2, int n3, int n4) {
        this.pt = new GridPt[n2 + 1][n3 + 1];
        this.flags = n4;
        int n5 = 0;
        while (n5 < n3 + 1) {
            int n6 = 0;
            while (n6 < n2 + 1) {
                this.pt[n6][n5] = (n4 & 4) != 0 && (n5 == 0 || n5 == n3) ? (n6 == 0 ? new GridPt(n6, n5) : this.pt[0][n5]) : ((n4 & 2) != 0 && n6 == n2 ? this.pt[0][n5] : new GridPt(n6, n5));
                ++n6;
            }
            ++n5;
        }
        this.verify();
    }

    public void setTransformDiv(int n2, int n3) {
        this.transformCol = n2;
        this.transformRow = n3;
        this.setDirty();
    }

    @Override
    public void verify() {
        int n2 = this.getRow();
        int n3 = this.getCol();
        int n4 = 0;
        while (n4 < n2 + 1) {
            int n5 = 0;
            while (n5 < n3 + 1) {
                if (this.pt[n5][n4] == null) {
                    throw new RuntimeException("Illegal state");
                }
                ++n5;
            }
            ++n4;
        }
    }

    public PointGrid(int n2, int n3, i i2) {
        this(n2, n3, 0);
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                this.pt[n5][n4].x = (float)(i2.x + (double)n5 * i2.width / (double)n2);
                this.pt[n5][n4].y = (float)(i2.y + (double)n4 * i2.height / (double)n3);
                ++n5;
            }
            ++n4;
        }
    }

    @Override
    public void transform(ITransform iTransform) {
        HashMap<GridPt, GridPt> hashMap = new HashMap<GridPt, GridPt>();
        int n2 = this.getRow();
        int n3 = this.getCol();
        int n4 = 0;
        while (n4 < n2 + 1) {
            int n5 = 0;
            while (n5 < n3 + 1) {
                GridPt gridPt = this.pt[n5][n4];
                if (hashMap.get(gridPt) == null) {
                    hashMap.put(gridPt, gridPt);
                    iTransform.transform(gridPt, gridPt);
                }
                ++n5;
            }
            ++n4;
        }
        this.setDirty();
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        if (!(iInterpolatable instanceof PointGrid)) {
            throw new jp.noids.graphics.interpolate.a(String.valueOf(a.b.a("CUBI-1123")) + this + " / " + iInterpolatable);
        }
        int n2 = this.getCol();
        int n3 = this.getRow();
        PointGrid pointGrid = this;
        PointGrid pointGrid2 = (PointGrid)iInterpolatable;
        if (pointGrid.getCol() != pointGrid2.getCol() || pointGrid.getRow() != pointGrid2.getRow()) {
            throw new jp.noids.graphics.interpolate.a(a.b.a("CUBI-1124"));
        }
        PointGrid pointGrid3 = new PointGrid(n2, n3, this.getFlags());
        int n4 = 0;
        while (n4 < this.pt.length) {
            int n5 = 0;
            while (n5 < this.pt[n4].length) {
                pointGrid3.pt[n4][n5].x = (float)(pointGrid.pt[n4][n5].x + (pointGrid2.pt[n4][n5].x - pointGrid.pt[n4][n5].x) * d2);
                pointGrid3.pt[n4][n5].y = (float)(pointGrid.pt[n4][n5].y + (pointGrid2.pt[n4][n5].y - pointGrid.pt[n4][n5].y) * d2);
                ++n5;
            }
            ++n4;
        }
        return pointGrid3;
    }

    @Override
    public boolean canInterpolate(IGrid iGrid) {
        if (!(iGrid instanceof PointGrid)) {
            return false;
        }
        PointGrid pointGrid = (PointGrid)iGrid;
        if (this.updateManager != pointGrid.updateManager) {
            return false;
        }
        return this.getCol() == pointGrid.getCol() && this.getRow() == pointGrid.getRow();
    }

    @Override
    public Object deepClone() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        PointGrid pointGrid = new PointGrid(n2, n3, this.getFlags());
        int n4 = 0;
        while (n4 < this.pt.length) {
            int n5 = 0;
            while (n5 < this.pt[n4].length) {
                pointGrid.pt[n4][n5].x = (float)this.pt[n4][n5].x;
                pointGrid.pt[n4][n5].y = (float)this.pt[n4][n5].y;
                ++n5;
            }
            ++n4;
        }
        return pointGrid;
    }

    @Override
    public void init(Object object) {
        PointGrid pointGrid = (PointGrid)object;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = pointGrid.getCol();
        int n5 = pointGrid.getRow();
        if (n2 != n4 || n3 != n5) {
            this.pt = new GridPt[n4][n5];
        }
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n4) {
                GridPt gridPt;
                this.pt[n7][n6] = gridPt = pointGrid.pt[n7][n6].deepClone();
                ++n7;
            }
            ++n6;
        }
        this.setDirty();
    }

    public int getCol() {
        return this.pt.length - 1;
    }

    public int getRow() {
        return this.pt[0].length - 1;
    }

    public GridPt[][] getPt() {
        return this.pt;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n2) {
        this.flags = n2;
    }

    public static PointGrid createSample() {
        return PointGrid.createSample(new Angle3D(0.0, 0.0, 0.0));
    }

    public static PointGrid createSample(Angle3D angle3D) {
        return PointGrid.createSample(angle3D, 1.0);
    }

    public static PointGrid createSample(Angle3D angle3D, double d2) {
        int n2 = 16;
        int n3 = 8;
        PointGrid pointGrid = new PointGrid(n2, n3, 6);
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                d4 = 0.39269908169872414 * (double)(n5 - 8);
                d3 = 0.39269908169872414 * (double)(n4 - 4);
                double d5 = Math.cos(d3);
                double d6 = d5 * Math.sin(d4);
                double d7 = Math.sin(d3);
                double d8 = d5 * Math.cos(d4);
                jp.noids.design.jogl.a a2 = jp.noids.design.jogl.a.b(angle3D.getX_asDeg());
                a2.b(jp.noids.design.jogl.a.a(angle3D.getY_asDeg()));
                a2.b(jp.noids.design.jogl.a.c(angle3D.getZ_asDeg()));
                double[] dArray = a2.a(d6, d7, d8, null);
                pointGrid.pt[n5][n4].x = (float)(dArray[0] * d2);
                pointGrid.pt[n5][n4].y = (float)(dArray[1] * d2);
                ++n5;
            }
            ++n4;
        }
        return pointGrid;
    }

    public static PointGrid createSample_flat() {
        int n2 = 16;
        int n3 = 8;
        PointGrid pointGrid = new PointGrid(n2, n3, 0);
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                pointGrid.pt[n5][n4].x = (float)(4.0 * ((double)n5 - (double)n2 / 2.0) / (double)n2);
                pointGrid.pt[n5][n4].y = (float)(2.0 * ((double)n4 - (double)n3 / 2.0) / (double)n3);
                ++n5;
            }
            ++n4;
        }
        return pointGrid;
    }

    @Override
    public i getBoundsRect() {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                GridPt gridPt = this.pt[n5][n4];
                if (gridPt.x < d2) {
                    d2 = gridPt.x;
                }
                if (gridPt.y < d3) {
                    d3 = gridPt.y;
                }
                if (d4 < gridPt.x) {
                    d4 = gridPt.x;
                }
                if (d5 < gridPt.y) {
                    d5 = gridPt.y;
                }
                ++n5;
            }
            ++n4;
        }
        return new i(d2, d3, d4 - d2, d5 - d3);
    }

    public GridPt getNearestPtRef(double d2, double d3) {
        double d4 = Double.POSITIVE_INFINITY;
        GridPt gridPt = null;
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                GridPt gridPt2 = this.pt[n5][n4];
                double d5 = (gridPt2.x - d2) * (gridPt2.x - d2) + (gridPt2.y - d3) * (gridPt2.y - d3);
                if (d4 > d5) {
                    d4 = d5;
                    gridPt = gridPt2;
                }
                ++n5;
            }
            ++n4;
        }
        return gridPt;
    }

    public int isFore(GridPt gridPt) {
        int n2 = 0;
        GridPolygon[] gridPolygonArray = this.getPolygonFor(gridPt);
        int n3 = 0;
        while (n3 < gridPolygonArray.length) {
            boolean bl2 = gridPolygonArray[n3].isFore();
            if (bl2) {
                ++n2;
            }
            ++n3;
        }
        if (gridPolygonArray.length == n2) {
            return 0;
        }
        if (n2 == 0) {
            return 2;
        }
        return 1;
    }

    @Override
    public double[] get01(double d2, double d3, double[] dArray) {
        int n2 = this.getCol();
        int n3 = this.getRow();
        GridPtBox gridPtBox = new GridPtBox();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                double[] dArray2;
                GridPt gridPt = this.pt[n5][n4];
                GridPt gridPt2 = this.pt[n5 + 1][n4];
                GridPt gridPt3 = this.pt[n5][n4 + 1];
                GridPt gridPt4 = this.pt[n5 + 1][n4 + 1];
                gridPtBox.setGridPt(gridPt, gridPt2, gridPt3, gridPt4);
                if (m.a(gridPtBox.getBoundsRect(), d2, d3, ap.a) && (dArray2 = gridPtBox.get01(d2, d3, dArray)) != null) {
                    dArray2[0] = ((double)n5 + dArray2[0]) / (double)n2;
                    dArray2[1] = ((double)n4 + dArray2[1]) / (double)n3;
                    return dArray2;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    @Override
    public double[] getPt(double d2, double d3, double[] dArray) {
        if (this.pt == null) {
            return null;
        }
        if (d2 < 0.0 - ap.a || d2 > 1.0 + ap.a) {
            return null;
        }
        if (d3 < 0.0 - ap.a || d3 > 1.0 + ap.a) {
            return null;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        int n2 = this.getCol();
        int n3 = this.getRow();
        int n4 = (int)(d2 * (double)n2);
        int n5 = (int)(d3 * (double)n3);
        if (n4 == n2) {
            n4 = n2 - 1;
        }
        if (n5 == n3) {
            n5 = n3 - 1;
        }
        int n6 = n4 + 1;
        int n7 = n5 + 1;
        GridPt gridPt = this.pt[n4][n5];
        GridPt gridPt2 = this.pt[n6][n5];
        GridPt gridPt3 = this.pt[n4][n7];
        GridPt gridPt4 = this.pt[n6][n7];
        GridPtBox gridPtBox = new GridPtBox(gridPt, gridPt2, gridPt3, gridPt4);
        return gridPtBox.getPt(b.a(n2, d2), b.a(n3, d3), dArray);
    }

    public GridPolygon[] getPolygonFor(GridPt gridPt) {
        int n2 = gridPt.getColNo();
        int n3 = gridPt.getRowNo();
        int n4 = this.getCol();
        int n5 = this.getRow();
        if (this.isPole(gridPt)) {
            GridPolygon[] gridPolygonArray = new GridPolygon[n4 + 1];
            if (n3 == 0) {
                int n6 = 0;
                while (n6 < n4 + 1) {
                    GridPolygon gridPolygon;
                    GridPt gridPt2 = this.getPointRefAt(n6 + 1, 1);
                    GridPt gridPt3 = this.getPointRefAt(n6, 1);
                    GridPt[] gridPtArray = new GridPt[]{gridPt, gridPt2, gridPt3};
                    gridPolygonArray[n6] = gridPolygon = new GridPolygon(gridPtArray);
                    ++n6;
                }
            } else {
                int n7 = 0;
                while (n7 < n4 + 1) {
                    GridPolygon gridPolygon;
                    GridPt gridPt4 = this.getPointRefAt(n7, this.getRow() - 2);
                    GridPt gridPt5 = this.getPointRefAt(n7 + 1, this.getRow() - 2);
                    GridPt[] gridPtArray = new GridPt[]{gridPt, gridPt4, gridPt5};
                    gridPolygonArray[n7] = gridPolygon = new GridPolygon(gridPtArray);
                    ++n7;
                }
            }
            return gridPolygonArray;
        }
        GridPt gridPt6 = this.getShiftedPointRef(gridPt, 1, 0);
        if (gridPt6 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt7 = this.getShiftedPointRef(gridPt, -1, 0);
        if (gridPt7 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt8 = this.getShiftedPointRef(gridPt, 0, 1);
        if (gridPt8 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt9 = this.getShiftedPointRef(gridPt, 0, -1);
        if (gridPt9 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt10 = this.getShiftedPointRef(gridPt, 1, 1);
        if (gridPt10 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt11 = this.getShiftedPointRef(gridPt, -1, 1);
        if (gridPt11 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt12 = this.getShiftedPointRef(gridPt, 1, -1);
        if (gridPt12 == null) {
            return new GridPolygon[0];
        }
        GridPt gridPt13 = this.getShiftedPointRef(gridPt, -1, -1);
        if (gridPt13 == null) {
            return new GridPolygon[0];
        }
        GridPolygon gridPolygon = new GridPolygon(gridPt, gridPt6, gridPt10, gridPt8);
        GridPolygon gridPolygon2 = new GridPolygon(gridPt, gridPt8, gridPt11, gridPt7);
        GridPolygon gridPolygon3 = new GridPolygon(gridPt, gridPt9, gridPt12, gridPt6);
        GridPolygon gridPolygon4 = new GridPolygon(gridPt, gridPt7, gridPt13, gridPt9);
        GridPolygon[] gridPolygonArray = new GridPolygon[]{gridPolygon, gridPolygon2, gridPolygon3, gridPolygon4};
        return gridPolygonArray;
    }

    public GridPt getShiftedPointRef(GridPt gridPt, int n2, int n3) {
        if (this.isPole(gridPt)) {
            throw new RuntimeException(a.b.a("CUBI-1147"));
        }
        int n4 = this.getCol();
        int n5 = this.getRow();
        if (Math.abs(n2) >= n4 + 1 || Math.abs(n3) >= n5 + 1) {
            throw new RuntimeException(String.valueOf(a.b.a("CUBI-1148")) + n2 + " , " + n3);
        }
        int n6 = gridPt.colNo;
        int n7 = gridPt.rowNo;
        int n8 = n6 + n2;
        int n9 = n7 + n3;
        return this.getPointRefAt(n8, n9);
    }

    public GridPt getPointRefAt(int n2, int n3) {
        int n4 = this.getCol();
        int n5 = this.getRow();
        if (this.f(this.flags, 4)) {
            if (n3 < 0) {
                n3 = -n3;
                n2 += n4 / 2;
            } else if (n3 >= n5 + 1) {
                n3 = 2 * n5 - n3;
                n2 += n4 / 2;
            }
        } else if (n3 < 0 && n3 >= n5 + 1) {
            n3 = -1;
        }
        if (n3 == -1) {
            return null;
        }
        if (this.f(this.flags, 2)) {
            while (n2 < 0) {
                n2 += n4;
            }
            while (n2 >= n4) {
                n2 -= n4;
            }
        } else if (n2 < 0 && n2 >= n4 + 1) {
            n2 = -1;
        }
        if (n2 < 0) {
            return null;
        }
        if (n2 >= this.pt.length) {
            return null;
        }
        if (n3 >= this.pt.length) {
            return null;
        }
        return this.pt[n2][n3];
    }

    public boolean isPole(GridPt gridPt) {
        int n2 = gridPt.getColNo();
        int n3 = gridPt.getRowNo();
        int n4 = this.getCol();
        int n5 = this.getRow();
        return this.f(this.flags, 4) && (n3 == 0 || n3 == n5);
    }

    @Override
    public void setDirty() {
        this.lastUpdated = System.currentTimeMillis();
    }

    @Override
    public boolean isUpdated(long l2) {
        return this.lastUpdated > l2;
    }

    private boolean f(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    @Override
    public void dump() {
        int n2 = this.getCol();
        int n3 = this.getRow();
        System.out.println("PointGrid");
        aj.a(4);
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                GridPt gridPt = this.pt[n5][n4];
                int n6 = 3;
                System.out.println("[" + n5 + "," + n4 + "] " + gridPt);
                ++n5;
            }
            ++n4;
        }
        aj.a(-4);
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.flags = g2.b(element, "flags");
        this.pt = (GridPt[][])g2.a(element, "pt");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1);
        l2.a(element, "flags", this.flags);
        l2.a(element, "pt", this.pt);
    }

    @Override
    public void readV1(jp.noids.e.a.a a2) {
        this.flags = a2.c();
        this.pt = (GridPt[][])a2.i();
    }

    @Override
    public void writeV1(jp.noids.e.a.b b2) {
        b2.a(this.flags);
        b2.c(this.pt);
    }

    public boolean verifyEquals(Object object) {
        if (!(object instanceof PointGrid)) {
            return false;
        }
        PointGrid pointGrid = this;
        PointGrid pointGrid2 = (PointGrid)object;
        if (this.flags != pointGrid2.flags) {
            throw new RuntimeException(a.b.a("CUBI-1149"));
        }
        int n2 = pointGrid.getCol();
        int n3 = pointGrid.getRow();
        int n4 = pointGrid2.getCol();
        int n5 = pointGrid2.getRow();
        if (n2 != n4) {
            throw new RuntimeException(a.b.a("CUBI-1150"));
        }
        if (n3 != n5) {
            throw new RuntimeException(a.b.a("CUBI-1151"));
        }
        int n6 = 0;
        while (n6 < n3 + 1) {
            int n7 = 0;
            while (n7 < n2 + 1) {
                GridPt gridPt = pointGrid.pt[n7][n6];
                GridPt gridPt2 = pointGrid2.pt[n7][n6];
                try {
                    gridPt.verifyEquals(gridPt2);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("x : " + n7);
                    System.err.println("y : " + n6);
                    runtimeException.printStackTrace();
                }
                ++n7;
            }
            ++n6;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            int n2 = 5;
            int n3 = 10;
            PointGrid pointGrid = new PointGrid(n2, n3, 6);
            File file = new File("./tmp/testpg.xml");
            jp.noids.xml.serialize.c.a(file, pointGrid);
            PointGrid pointGrid2 = (PointGrid)jp.noids.xml.serialize.c.a(file);
            int n4 = 0;
            while (n4 < n3 + 1) {
                GridPt gridPt;
                System.out.println("\n Line P1 : " + n4);
                int n5 = 0;
                while (n5 < n2 + 1) {
                    gridPt = pointGrid.pt[n5][n4];
                    System.out.print(az.b("" + gridPt.colNo, 2) + "," + az.b("" + gridPt.rowNo, 2) + gridPt + "   ");
                    ++n5;
                }
                System.out.println("\n Line P2 : " + n4);
                n5 = 0;
                while (n5 < n2 + 1) {
                    gridPt = pointGrid2.pt[n5][n4];
                    System.out.print(az.b("" + gridPt.colNo, 2) + "," + az.b("" + gridPt.rowNo, 2) + gridPt + "   ");
                    ++n5;
                }
                System.out.println("");
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public jp.noids.graphics.c.b[] getAllEditablePointRef(ITransform iTransform) {
        int n2 = this.getCol();
        int n3 = this.getRow();
        jp.noids.graphics.c.b[] bArray = new jp.noids.graphics.c.b[(n2 + 1) * (n3 + 1)];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3 + 1) {
            int n6 = 0;
            while (n6 < n2 + 1) {
                GridPt gridPt = this.pt[n6][n5];
                g g2 = new g();
                iTransform.transform(gridPt, g2);
                a a2 = new a(g2, gridPt);
                bArray[n4++] = a2;
                ++n6;
            }
            ++n5;
        }
        if (n4 != bArray.length) {
            throw new RuntimeException("Illegal state :_" + n4 + " / " + bArray.length);
        }
        return bArray;
    }

    @Override
    public c getNearestPointRef(g g2, ITransform iTransform, boolean bl2) {
        int n2 = this.getCol();
        int n3 = this.getRow();
        double d2 = Double.MAX_VALUE;
        GridPt gridPt = null;
        g g3 = null;
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                GridPt gridPt2 = this.pt[n5][n4];
                g g4 = new g();
                iTransform.transform(gridPt2, g4);
                double d3 = m.b(g2, g4);
                if (d3 < d2) {
                    d2 = d3;
                    gridPt = gridPt2;
                    g3 = g4;
                }
                ++n5;
            }
            ++n4;
        }
        if (gridPt != null && g3 != null) {
            a a2 = new a(g3, gridPt);
            return a2;
        }
        return null;
    }

    @Override
    public c[] getAllPointRef(ITransform iTransform, boolean bl2) {
        int n2 = this.getCol();
        int n3 = this.getRow();
        ArrayList<a> arrayList = new ArrayList<a>();
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = 0;
            while (n5 < n2 + 1) {
                GridPt gridPt = this.pt[n5][n4];
                g g2 = new g();
                iTransform.transform(gridPt, g2);
                a a2 = new a(g2, gridPt);
                arrayList.add(a2);
                ++n5;
            }
            ++n4;
        }
        return arrayList.toArray(new c[arrayList.size()]);
    }

    @Override
    public c getCompatiblePointRef(c c2, ITransform iTransform) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void drawGrid(Graphics graphics, ITransform iTransform, Map map, LDColor lDColor) {
        int n2;
        GridPt gridPt;
        GridPt gridPt2;
        int n3;
        boolean bl2;
        PointGrid pointGrid = this;
        GridPt gridPt3 = null;
        jp.noids.graphics.b b2 = jp.noids.graphics.i.d(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        g g2 = new g();
        g g3 = new g();
        g g4 = new g();
        LDColor lDColor2 = LDColor.RED;
        LDColor lDColor3 = LDColor.GRAY;
        LDColor lDColor4 = new LDColor(-1118482);
        int n4 = 1;
        int n5 = (this.flags & 2) != 0 ? pointGrid.getCol() / 2 : -9999;
        int n6 = (this.flags & 4) != 0 ? pointGrid.getRow() / 2 : -9999;
        boolean bl3 = bl2 = map != null && Boolean.TRUE.equals(map.get(KEY_SELECTED));
        if (!bl2) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        jp.noids.graphics.i.a(graphics2D);
        int n7 = pointGrid.getCol();
        int n8 = pointGrid.getRow();
        int n9 = 0;
        while (n9 < n8 + 1) {
            n3 = 0;
            while (n3 < n7) {
                gridPt2 = pointGrid.pt[n3][n9];
                gridPt = pointGrid.pt[n3 + 1][n9];
                iTransform.transform(gridPt2, g2);
                iTransform.transform(gridPt, g3);
                if (pointGrid.isFore(gridPt2) == 2) {
                    graphics2D.setColor(lDColor4);
                    PointGrid.drawLine(graphics2D, g2, g3);
                }
                ++n3;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n7 + 1) {
            graphics2D.setColor(n9 == n5 ? lDColor2 : lDColor3);
            n3 = 0;
            while (n3 < n8) {
                gridPt2 = pointGrid.pt[n9][n3];
                gridPt = pointGrid.pt[n9][n3 + 1];
                iTransform.transform(gridPt2, g2);
                iTransform.transform(gridPt, g4);
                if (pointGrid.isFore(gridPt2) == 2) {
                    graphics2D.setColor(lDColor4);
                    PointGrid.drawLine(graphics2D, g2, g4);
                }
                ++n3;
            }
            ++n9;
        }
        jp.noids.graphics.i.b(graphics2D);
        n9 = 0;
        while (n9 < n8 + 1) {
            n3 = 0;
            while (n3 < n7 + 1) {
                gridPt2 = pointGrid.pt[n3][n9];
                iTransform.transform(gridPt2, g2);
                int n10 = (int)g2.x;
                n2 = (int)g2.y;
                if (pointGrid.isFore(gridPt2) == 2) {
                    graphics2D.setColor(lDColor4);
                    graphics2D.fillRect(n10 - n4, n2 - n4, n4 * 2 + 1, n4 * 2 + 1);
                }
                ++n3;
            }
            ++n9;
        }
        jp.noids.graphics.i.a(graphics2D);
        n9 = 0;
        while (n9 < n8 + 1) {
            n3 = 0;
            while (n3 < n7) {
                gridPt2 = pointGrid.pt[n3][n9];
                GridPt gridPt4 = pointGrid.pt[n3 + 1][n9];
                iTransform.transform(gridPt2, g2);
                iTransform.transform(gridPt4, g3);
                graphics2D.setStroke(new BasicStroke(n9 == n6 ? 1.2f : 0.6f));
                if (gridPt3 != null && gridPt3.getRowNo() == n9) {
                    graphics2D.setColor(LDColor.PINK);
                    PointGrid.drawLine(graphics2D, g2, g3);
                } else if (pointGrid.isFore(gridPt2) != 2) {
                    graphics2D.setColor(n9 == n6 ? lDColor2 : lDColor3);
                    PointGrid.drawLine(graphics2D, g2, g3);
                }
                ++n3;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n7 + 1) {
            graphics2D.setColor(n9 == n5 ? lDColor2 : lDColor3);
            n3 = 0;
            while (n3 < n8) {
                gridPt2 = pointGrid.pt[n9][n3];
                GridPt gridPt5 = pointGrid.pt[n9][n3 + 1];
                iTransform.transform(gridPt2, g2);
                iTransform.transform(gridPt5, g4);
                graphics2D.setStroke(new BasicStroke(n9 == n5 ? 1.2f : 0.6f));
                if (gridPt3 != null && gridPt3.getColNo() == n9) {
                    graphics2D.setColor(LDColor.GREEN);
                    PointGrid.drawLine(graphics2D, g2, g4);
                } else if (pointGrid.isFore(gridPt2) != 2) {
                    graphics2D.setColor(n9 == n5 ? lDColor2 : lDColor3);
                    PointGrid.drawLine(graphics2D, g2, g4);
                }
                ++n3;
            }
            ++n9;
        }
        jp.noids.graphics.i.b(graphics2D);
        n9 = 0;
        while (n9 < n8 + 1) {
            n3 = 0;
            while (n3 < n7 + 1) {
                gridPt2 = pointGrid.pt[n3][n9];
                iTransform.transform(gridPt2, g2);
                int n11 = (int)g2.x;
                n2 = (int)g2.y;
                if (gridPt3 == gridPt2) {
                    graphics2D.setColor(LDColor.RED);
                    graphics2D.fillRect(n11 - n4, n2 - n4, n4 * 2 + 1, n4 * 2 + 1);
                } else if (pointGrid.isFore(gridPt2) != 2) {
                    graphics2D.setColor(LDColor.BLACK);
                    graphics2D.fillRect(n11 - n4, n2 - n4, n4 * 2 + 1, n4 * 2 + 1);
                }
                ++n3;
            }
            ++n9;
        }
        jp.noids.graphics.i.a((Graphics)graphics2D, b2);
    }

    public static void drawLine(Graphics graphics, g g2, g g3) {
        graphics.drawLine((int)g2.x, (int)g2.y, (int)g3.x, (int)g3.y);
    }

    public class a
    extends c {
        GridPt a;

        public a(g g2, GridPt gridPt) {
            this.x = g2.x;
            this.y = g2.y;
            this.a = gridPt;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.a.x = (float)d2;
            this.a.y = (float)d3;
            PointGrid.this.setDirty();
        }
    }
}

