/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.model3Dp.parts.draw.v2;

import java.awt.Container;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JFrame;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.geom.Vector2d;
import jp.noids.graphics.geom.c;
import jp.noids.graphics.interpolate.IInterpolatable;
import jp.noids.graphics.interpolate.b;
import jp.noids.graphics.m;
import jp.noids.graphics.transform.ITransform;
import jp.noids.model3Dp.parts.draw.v2.Patch;
import jp.noids.util.L;
import jp.noids.util.O;
import jp.noids.xml.serialize.f;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class BasicMorphV2
implements IInterpolatable {
    static boolean CHECK_ANGLE_DISABLED = false;
    static boolean DUMP = false;
    MoPoint[] points = new MoPoint[0];
    MoLine[] lines = new MoLine[0];
    int[][] polygons = new int[][]{new int[0]};
    BasicMorphV2 srcMorph;
    transient Patch[] patch = new Patch[0];
    transient boolean dirtyPatch = true;
    transient boolean dirtyPolygon = true;
    transient boolean dirtyBounds = true;
    transient i bounds = null;
    static final boolean CW_PATCH = true;
    static final double PI2 = Math.PI * 2;

    public BasicMorphV2() {
    }

    public BasicMorphV2(BasicMorphV2 basicMorphV2) {
        this.srcMorph = basicMorphV2;
    }

    public void dump() {
        System.out.println("points ------------");
        int n2 = 0;
        while (n2 < this.points.length) {
            System.out.println(L.a(this.points[n2]));
            ++n2;
        }
        System.out.println("lines ------------");
        n2 = 0;
        while (n2 < this.lines.length) {
            System.out.println(String.valueOf(this.lines[n2].index1) + "=>" + this.lines[n2].index2);
            ++n2;
        }
    }

    public int[][] getPolygons() {
        return this.polygons;
    }

    public BasicMorphV2 createTransformed(ITransform iTransform, int n2) {
        try {
            BasicMorphV2 basicMorphV2 = (BasicMorphV2)this.deepClone();
            if (!iTransform.isIdentity()) {
                basicMorphV2.transform(iTransform, n2);
            }
            return basicMorphV2;
        }
        catch (jp.noids.ui.l.f f2) {
            f2.printStackTrace();
            throw new jp.noids.graphics.transform.a(f2);
        }
    }

    public void transform(ITransform iTransform, int n2) {
        if (this.dirtyPolygon) {
            this.updatePolygon();
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        if (this.patch.length == 0) {
            return;
        }
        this.patch[0] = this.patch[0].createTransformed(iTransform, n2);
        int n3 = 1;
        while (n3 < this.patch.length) {
            this.patch[n3] = this.patch[n3].createTransformed(iTransform, n2);
            ++n3;
        }
        iTransform.transform(this.points, 0, this.points, 0, this.points.length);
        this.dirtyBounds = true;
    }

    public boolean contains(g g2) {
        Patch[] patchArray = this.getPatchListRef();
        int n2 = 0;
        while (n2 < patchArray.length) {
            if (patchArray[n2].contains(g2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object deepClone() {
        BasicMorphV2 basicMorphV2 = new BasicMorphV2();
        basicMorphV2.init(this);
        return basicMorphV2;
    }

    @Override
    public void init(Object object) {
        BasicMorphV2 basicMorphV2 = (BasicMorphV2)object;
        if (basicMorphV2.dirtyPolygon) {
            basicMorphV2.updatePolygon();
        }
        this.points = (MoPoint[])b.a(basicMorphV2.points, this);
        this.lines = (MoLine[])b.a(basicMorphV2.lines, this);
        if (this.polygons != null) {
            this.polygons = new int[basicMorphV2.polygons.length][];
            int n2 = 0;
            while (n2 < basicMorphV2.polygons.length) {
                this.polygons[n2] = jp.noids.util.c.a(basicMorphV2.polygons[n2]);
                ++n2;
            }
        } else {
            this.polygons = null;
        }
        this.dirtyPolygon = false;
        this.dirtyPatch = true;
        this.dirtyBounds = true;
    }

    public MoLine getNearestLineRef(g g2, g g3) {
        MoPoint moPoint;
        MoPoint moPoint2;
        if (this.points == null || this.lines == null) {
            return null;
        }
        double d2 = Double.MAX_VALUE;
        int n2 = -1;
        float[] fArray = new float[2];
        float[] fArray2 = new float[2];
        int n3 = 0;
        while (n3 < this.lines.length) {
            double d3;
            MoLine moLine = this.lines[n3];
            moPoint2 = this.points[moLine.index1];
            moPoint = this.points[moLine.index2];
            Vector2d vector2d = new Vector2d((g)moPoint2, (g)moPoint);
            Vector2d vector2d2 = vector2d.norm_new();
            c.a((double)((float)g2.x), (double)((float)g2.y), (g)moPoint2, vector2d, vector2d2, fArray2);
            if (0.0f <= fArray2[0] && fArray2[0] <= 1.0f) {
                d3 = vector2d2.getDistance() * (double)fArray2[1];
                d3 *= d3;
            } else {
                d3 = fArray2[0] < 0.0f ? m.b((g)moPoint2, g2) : m.b((g)moPoint, g2);
            }
            if (d3 < d2) {
                d2 = d3;
                n2 = n3;
                fArray[0] = fArray2[0];
                fArray[1] = fArray2[1];
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        double d4 = fArray[0];
        moPoint2 = this.points[this.lines[n2].index1];
        moPoint = this.points[this.lines[n2].index2];
        if (0.0 <= d4 && d4 <= 1.0) {
            g3.x = moPoint2.x + (moPoint.x - moPoint2.x) * d4;
            g3.y = moPoint2.y + (moPoint.y - moPoint2.y) * d4;
        } else if (d4 < 0.0) {
            g3.x = moPoint2.x;
            g3.y = moPoint2.y;
        } else {
            g3.x = moPoint.x;
            g3.y = moPoint.y;
        }
        return this.lines[n2];
    }

    public MoPoint getNearestPointRef(g g2) {
        if (this.points == null) {
            return null;
        }
        double d2 = Double.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.points.length) {
            MoPoint moPoint = this.points[n3];
            double d3 = (moPoint.x - g2.x) * (moPoint.x - g2.x) + (moPoint.y - g2.y) * (moPoint.y - g2.y);
            if (d3 < d2) {
                d2 = d3;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        return this.points[n2];
    }

    public MoPoint getCompatiblePointRef(jp.noids.graphics.c.b b2) {
        if (this.points == null) {
            return null;
        }
        if (!(b2 instanceof MoPoint)) {
            throw new RuntimeException("Illegal state :_");
        }
        MoPoint moPoint = (MoPoint)b2;
        return this.points[moPoint.getIndex()];
    }

    public MoLine getCompatibleLineRef(MoLine moLine) {
        int n2 = moLine.getIndex();
        return this.lines[n2];
    }

    void setupIndex() {
        int n2 = 0;
        while (n2 < this.points.length) {
            this.points[n2].selfIndex = n2;
            ++n2;
        }
    }

    public MoPoint[] getAllPointRef() {
        this.setupIndex();
        return this.points;
    }

    public MoLine[] getLineListRef() {
        return this.lines;
    }

    public MoPoint[] getPointListRef() {
        this.setupIndex();
        return this.points;
    }

    public int getPointCount() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length;
    }

    public MoLine addLine(MoPoint moPoint, MoPoint moPoint2) {
        int n2 = moPoint.getIndex();
        int n3 = moPoint2.getIndex();
        int n4 = 0;
        while (n4 < this.lines.length) {
            if (this.lines[n4].isUsing(n2) && this.lines[n4].isUsing(n3)) {
                return this.lines[n4];
            }
            ++n4;
        }
        MoLine moLine = new MoLine(n2, n3);
        this.lines = (MoLine[])jp.noids.util.c.c(this.lines, moLine);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
        return moLine;
    }

    public void removeLine(MoLine moLine) {
        int n2 = moLine.getIndex();
        this.lines = (MoLine[])jp.noids.util.c.a((Object[])this.lines, n2);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
    }

    public MoPoint addPoint(float f2, float f3) {
        MoPoint moPoint = new MoPoint(f2, f3);
        this.points = (MoPoint[])jp.noids.util.c.c(this.points, moPoint);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
        return moPoint;
    }

    public void removePoint(MoPoint moPoint) {
        int n2 = moPoint.getIndex();
        ArrayList<MoLine> arrayList = new ArrayList<MoLine>();
        int n3 = 0;
        while (n3 < this.lines.length) {
            if (!this.lines[n3].isUsing(n2)) {
                if (this.lines[n3].index1 > n2) {
                    --this.lines[n3].index1;
                }
                if (this.lines[n3].index2 > n2) {
                    --this.lines[n3].index2;
                }
                arrayList.add(this.lines[n3]);
            }
            ++n3;
        }
        this.lines = arrayList.toArray(new MoLine[arrayList.size()]);
        this.points = (MoPoint[])jp.noids.util.c.a((Object[])this.points, n2);
        this.dirtyPatch = true;
        this.dirtyPolygon = true;
        this.dirtyBounds = true;
    }

    public i getBoundsRect() {
        if (this.dirtyPolygon) {
            this.updatePolygon();
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        if (this.dirtyBounds) {
            this.updateBounds();
        }
        return this.bounds;
    }

    private void updateBounds() {
        this.bounds = new i();
        if (this.points.length < 1) {
            return;
        }
        this.bounds.setRect(this.points[0].x, this.points[0].y, 0.0, 0.0);
        int n2 = 1;
        while (n2 < this.points.length) {
            this.bounds.a(this.points[n2]);
            ++n2;
        }
        this.dirtyBounds = false;
    }

    public Patch[] getPatchListRef() {
        if (this.dirtyPolygon) {
            this.updatePolygon();
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        return this.patch;
    }

    public Patch getPatch(int n2) {
        if (this.dirtyPolygon) {
            this.updatePolygon();
        }
        if (this.dirtyPatch) {
            this.updatePatch();
        }
        return this.patch[n2];
    }

    void updatePolygon(BasicMorphV2 basicMorphV2) {
        this.polygons = basicMorphV2.polygons;
        this.dirtyPolygon = false;
        this.dirtyPatch = true;
        this.dirtyBounds = true;
    }

    void updatePolygon() {
        if (this.srcMorph != null) {
            if (this.srcMorph.dirtyPolygon) {
                this.srcMorph.updatePolygonNormal();
            }
            this.updatePolygon(this.srcMorph);
        } else {
            this.updatePolygonNormal();
        }
    }

    void updatePolygonNormal() {
        int n2;
        int n3;
        int n4 = this.lines.length;
        double[] dArray = new double[n4];
        boolean[] blArray = new boolean[n4 * 2];
        int[][] nArrayArray = new int[this.points.length][];
        int[] nArray = new int[this.lines.length];
        if (DUMP) {
            System.out.printf("-------------------------------------------\t\t\t\t\t@@BasicMorph\n", new Object[0]);
        }
        int n5 = 0;
        while (n5 < this.points.length) {
            if (DUMP) {
                System.out.printf("points[i] = ( %6.2f, %6.2f ) ;\t\t\t\t\t@@BasicMorph", n5, this.points[n5].x, this.points[n5].y);
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < n4) {
                if (this.lines[n7].index1 == n5 || this.lines[n7].index2 == n5) {
                    nArray[n6++] = n7;
                }
                ++n7;
            }
            nArrayArray[n5] = new int[n6];
            System.arraycopy(nArray, 0, nArrayArray[n5], 0, n6);
            ++n5;
        }
        if (DUMP) {
            System.out.printf("-------------------------------------------\t\t\t\t\t@@BasicMorph\n", new Object[0]);
            n5 = 0;
            while (n5 < this.lines.length) {
                System.out.printf("lines[i] = ( %2d, %2d ) ;\t\t\t\t\t@@BasicMorph", n5, this.lines[n5].index1, this.lines[n5].index2);
                ++n5;
            }
        }
        n5 = 0;
        while (n5 < n4) {
            MoLine moLine = this.lines[n5];
            MoPoint moPoint = this.points[moLine.index1];
            MoPoint moPoint2 = this.points[moLine.index2];
            dArray[n5] = jp.noids.h.a.a(moPoint2.y - moPoint.y, moPoint2.x - moPoint.x);
            blArray[n5 * 2] = false;
            blArray[n5 * 2 + 1] = false;
            ++n5;
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray2 = new int[this.points.length * 2];
        int n8 = 0;
        while (n8 < n4 * 2) {
            if (!blArray[n8]) {
                double d2;
                blArray[n8] = true;
                int n9 = n8 / 2;
                Object object = this.lines[n9];
                n3 = n8 % 2 == 0 ? 1 : 0;
                n2 = n3 != 0 ? object.index1 : object.index2;
                int n10 = 0;
                nArray2[n10++] = n2;
                int n11 = n3 != 0 ? object.index2 : object.index1;
                double d3 = 0.0;
                do {
                    if (nArray2.length <= n10) {
                        n10 = 0;
                        break;
                    }
                    nArray2[n10++] = n11;
                    d2 = n3 != 0 ? dArray[n9] + Math.PI : dArray[n9];
                    double d4 = Double.MAX_VALUE;
                    int n12 = -1;
                    int n13 = 0;
                    int[] nArray3 = nArrayArray[n11];
                    int n14 = 0;
                    while (n14 < nArray3.length) {
                        int n15 = nArray3[n14];
                        if (n9 != n15) {
                            MoLine moLine = this.lines[n15];
                            int n16 = moLine.index1 == n11 ? 1 : 0;
                            if (!blArray[n15 * 2 + (n16 != 0 ? 0 : 1)]) {
                                double d5 = n16 != 0 ? dArray[n15] : dArray[n15] + Math.PI;
                                double d6 = d2 - d5;
                                while (d6 < 0.0) {
                                    d6 += Math.PI * 2;
                                }
                                while (d6 > Math.PI * 2) {
                                    d6 -= Math.PI * 2;
                                }
                                if (d6 < d4) {
                                    d4 = d6;
                                    n12 = n15;
                                    n13 = n16;
                                }
                            }
                        }
                        ++n14;
                    }
                    if (n12 == -1) break;
                    blArray[n12 * 2 + (n13 != 0 ? 0 : 1)] = true;
                    d3 += d4;
                    n11 = n13 != 0 ? this.lines[n12].index2 : this.lines[n12].index1;
                    n9 = n12;
                    n3 = n13;
                } while (n11 != n2);
                d2 = 1.2;
                if (CHECK_ANGLE_DISABLED || d3 < (double)(n10 - 2) * Math.PI * d2) {
                    int[] nArray4 = new int[n10];
                    System.arraycopy(nArray2, 0, nArray4, 0, n10);
                    arrayList.add(nArray4);
                    if (DUMP) {
                        System.out.printf(">> add polygon { ", new Object[0]);
                        int n17 = 0;
                        while (n17 < nArray4.length) {
                            System.out.printf("%2d ,", nArray4[n17]);
                            ++n17;
                        }
                        System.out.printf("\n", new Object[0]);
                    }
                }
            }
            ++n8;
        }
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        for (Object object : arrayList) {
            n3 = object[0];
            if (((int[])object).length == 3) {
                arrayList2.add((int[])object);
                continue;
            }
            n2 = 0;
            while (n2 < ((int[])object).length - 2) {
                arrayList2.add(new int[]{n3, object[n2 + 1], object[n2 + 2]});
                ++n2;
            }
        }
        this.polygons = (int[][])arrayList2.toArray((T[])new int[arrayList2.size()][]);
        this.dirtyPolygon = false;
        this.dirtyPatch = true;
        this.dirtyBounds = true;
    }

    private void updatePatch() {
        if (this.lines == null) {
            return;
        }
        if (this.polygons == null) {
            throw new RuntimeException(a.b.a("CUBI-1276"));
        }
        this.patch = new Patch[this.polygons.length];
        int n2 = 0;
        while (n2 < this.polygons.length) {
            Patch patch;
            int[] nArray = this.polygons[n2];
            if (nArray.length != 3) {
                throw new RuntimeException("Illegal state :_" + nArray.length);
            }
            this.patch[n2] = patch = new Patch(this.points[nArray[0]], this.points[nArray[1]], this.points[nArray[2]]);
            ++n2;
        }
        this.dirtyPatch = false;
        this.dirtyBounds = true;
    }

    private static double normalizeTo2PI(double d2) {
        while (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        while (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    private static double normalizeToPI(double d2) {
        while (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        while (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    static int r360(double d2) {
        return (int)(180.0 * d2 / Math.PI);
    }

    public static BasicMorphV2 createSample(float f2) {
        BasicMorphV2 basicMorphV2 = new BasicMorphV2();
        f2 = (float)((double)f2 * 0.005);
        MoPoint[] moPointArray = new MoPoint[7];
        BasicMorphV2 basicMorphV22 = basicMorphV2;
        basicMorphV22.getClass();
        moPointArray[0] = basicMorphV22.new MoPoint(10.0f * f2, 10.0f * f2);
        BasicMorphV2 basicMorphV23 = basicMorphV2;
        basicMorphV23.getClass();
        moPointArray[1] = basicMorphV23.new MoPoint(100.0f * f2, 10.0f * f2);
        BasicMorphV2 basicMorphV24 = basicMorphV2;
        basicMorphV24.getClass();
        moPointArray[2] = basicMorphV24.new MoPoint(70.0f * f2, 70.0f * f2);
        BasicMorphV2 basicMorphV25 = basicMorphV2;
        basicMorphV25.getClass();
        moPointArray[3] = basicMorphV25.new MoPoint(150.0f * f2, 70.0f * f2);
        BasicMorphV2 basicMorphV26 = basicMorphV2;
        basicMorphV26.getClass();
        moPointArray[4] = basicMorphV26.new MoPoint(5.0f * f2, 110.0f * f2);
        BasicMorphV2 basicMorphV27 = basicMorphV2;
        basicMorphV27.getClass();
        moPointArray[5] = basicMorphV27.new MoPoint(60.0f * f2, 130.0f * f2);
        BasicMorphV2 basicMorphV28 = basicMorphV2;
        basicMorphV28.getClass();
        moPointArray[6] = basicMorphV28.new MoPoint(120.0f * f2, 120.0f * f2);
        basicMorphV2.points = moPointArray;
        MoLine[] moLineArray = new MoLine[12];
        BasicMorphV2 basicMorphV29 = basicMorphV2;
        basicMorphV29.getClass();
        moLineArray[0] = basicMorphV29.new MoLine(0, 1);
        BasicMorphV2 basicMorphV210 = basicMorphV2;
        basicMorphV210.getClass();
        moLineArray[1] = basicMorphV210.new MoLine(1, 3);
        BasicMorphV2 basicMorphV211 = basicMorphV2;
        basicMorphV211.getClass();
        moLineArray[2] = basicMorphV211.new MoLine(3, 6);
        BasicMorphV2 basicMorphV212 = basicMorphV2;
        basicMorphV212.getClass();
        moLineArray[3] = basicMorphV212.new MoLine(6, 5);
        BasicMorphV2 basicMorphV213 = basicMorphV2;
        basicMorphV213.getClass();
        moLineArray[4] = basicMorphV213.new MoLine(5, 4);
        BasicMorphV2 basicMorphV214 = basicMorphV2;
        basicMorphV214.getClass();
        moLineArray[5] = basicMorphV214.new MoLine(4, 0);
        BasicMorphV2 basicMorphV215 = basicMorphV2;
        basicMorphV215.getClass();
        moLineArray[6] = basicMorphV215.new MoLine(0, 2);
        BasicMorphV2 basicMorphV216 = basicMorphV2;
        basicMorphV216.getClass();
        moLineArray[7] = basicMorphV216.new MoLine(2, 4);
        BasicMorphV2 basicMorphV217 = basicMorphV2;
        basicMorphV217.getClass();
        moLineArray[8] = basicMorphV217.new MoLine(2, 3);
        BasicMorphV2 basicMorphV218 = basicMorphV2;
        basicMorphV218.getClass();
        moLineArray[9] = basicMorphV218.new MoLine(3, 5);
        BasicMorphV2 basicMorphV219 = basicMorphV2;
        basicMorphV219.getClass();
        moLineArray[10] = basicMorphV219.new MoLine(2, 5);
        BasicMorphV2 basicMorphV220 = basicMorphV2;
        basicMorphV220.getClass();
        moLineArray[11] = basicMorphV220.new MoLine(2, 1);
        basicMorphV2.lines = moLineArray;
        return basicMorphV2;
    }

    public static BasicMorphV2 createBoxMorph(i i2) {
        return BasicMorphV2.createBoxMorph(i2, false, false);
    }

    public static BasicMorphV2 createBoxMorph(i i2, boolean bl2, boolean bl3) {
        BasicMorphV2 basicMorphV2 = new BasicMorphV2();
        float f2 = (float)(bl2 ? i2.getMaxX() : i2.getMinX());
        float f3 = (float)(bl2 ? i2.getMinX() : i2.getMaxX());
        float f4 = (float)(bl3 ? i2.getMaxY() : i2.getMinY());
        float f5 = (float)(bl3 ? i2.getMinY() : i2.getMaxY());
        MoPoint[] moPointArray = new MoPoint[4];
        BasicMorphV2 basicMorphV22 = basicMorphV2;
        basicMorphV22.getClass();
        moPointArray[0] = basicMorphV22.new MoPoint(f2, f4);
        BasicMorphV2 basicMorphV23 = basicMorphV2;
        basicMorphV23.getClass();
        moPointArray[1] = basicMorphV23.new MoPoint(f3, f4);
        BasicMorphV2 basicMorphV24 = basicMorphV2;
        basicMorphV24.getClass();
        moPointArray[2] = basicMorphV24.new MoPoint(f3, f5);
        BasicMorphV2 basicMorphV25 = basicMorphV2;
        basicMorphV25.getClass();
        moPointArray[3] = basicMorphV25.new MoPoint(f2, f5);
        basicMorphV2.points = moPointArray;
        MoLine[] moLineArray = new MoLine[5];
        BasicMorphV2 basicMorphV26 = basicMorphV2;
        basicMorphV26.getClass();
        moLineArray[0] = basicMorphV26.new MoLine(0, 1);
        BasicMorphV2 basicMorphV27 = basicMorphV2;
        basicMorphV27.getClass();
        moLineArray[1] = basicMorphV27.new MoLine(1, 2);
        BasicMorphV2 basicMorphV28 = basicMorphV2;
        basicMorphV28.getClass();
        moLineArray[2] = basicMorphV28.new MoLine(2, 3);
        BasicMorphV2 basicMorphV29 = basicMorphV2;
        basicMorphV29.getClass();
        moLineArray[3] = basicMorphV29.new MoLine(3, 0);
        BasicMorphV2 basicMorphV210 = basicMorphV2;
        basicMorphV210.getClass();
        moLineArray[4] = basicMorphV210.new MoLine(0, 2);
        basicMorphV2.lines = moLineArray;
        return basicMorphV2;
    }

    public static void main(String[] stringArray) {
        BasicMorphV2 basicMorphV2 = BasicMorphV2.createSample(200.0f);
        JFrame jFrame = O.a("jp.noids.design.morph.simple.BasicMorph", a.b.a("CUBI-0249"), 800, 600, true);
        Container container = jFrame.getContentPane();
        jp.noids.model3Dp.parts.draw.v2.a a2 = new jp.noids.model3Dp.parts.draw.v2.a(basicMorphV2);
        container.add(a2);
        jFrame.setVisible(true);
        basicMorphV2.updatePolygon();
        basicMorphV2.updatePatch();
    }

    @Override
    public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
        BasicMorphV2 basicMorphV2 = (BasicMorphV2)iInterpolatable;
        BasicMorphV2 basicMorphV22 = new BasicMorphV2();
        basicMorphV22.points = (MoPoint[])b.a(this.points, basicMorphV2.points, d2);
        basicMorphV22.lines = (MoLine[])b.a(this.lines, basicMorphV2.lines, d2);
        basicMorphV22.polygons = new int[this.polygons.length][];
        int n2 = 0;
        while (n2 < this.polygons.length) {
            basicMorphV22.polygons[n2] = jp.noids.util.c.a(this.polygons[n2]);
            ++n2;
        }
        return basicMorphV22;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        this.points = (MoPoint[])g2.a(element, "points");
        this.lines = (MoLine[])g2.a(element, "lines");
        this.polygons = (int[][])g2.a(element, "polygons");
        this.dirtyPolygon = false;
        this.dirtyPatch = true;
    }

    @Override
    public void write(l l2, Element element) {
        if (this.dirtyPolygon) {
            this.updatePolygon();
        }
        l2.a(element, "points", this.points);
        l2.a(element, "lines", this.lines);
        l2.a(element, "polygons", this.polygons);
    }

    public a getTopologyDef(float f2, float f3) {
        g g2 = new g(f2, f3);
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        int n2 = 0;
        while (n2 < this.points.length) {
            double d2 = m.b((g)this.points[n2], g2);
            if (d2 > 0.0) {
                treeMap.put(d2, n2);
            }
            ++n2;
        }
        Integer[] integerArray = treeMap.values().toArray(new Integer[0]);
        if (integerArray.length > 0) {
            g g3;
            int n3 = integerArray[0];
            MoPoint moPoint = this.points[n3];
            int n4 = -1;
            g g4 = new g(0.0, 0.0);
            int n5 = 1;
            while (n5 < integerArray.length) {
                g3 = this.points[integerArray[n5]];
                if (g3.x != moPoint.x || g3.y != moPoint.y) {
                    n4 = n5;
                    g4 = this.points[n4];
                    break;
                }
                ++n5;
            }
            Vector2d vector2d = new Vector2d((g)moPoint, g4);
            g3 = vector2d.norm_new();
            double[] dArray = c.a(g2, moPoint, vector2d, (Vector2d)g3);
            if (dArray != null) {
                a a2 = new a(f2, f3, n3, n4, (float)dArray[0], (float)dArray[1]);
                return a2;
            }
            a a3 = new a(f2, f3);
            return a3;
        }
        a a4 = new a(f2, f3);
        return a4;
    }

    public g getPointByTopologyDef(a a2) {
        if (a2.c == -1) {
            return null;
        }
        MoPoint moPoint = this.points[a2.c];
        g g2 = a2.d == -1 ? new g(0.0, 0.0) : this.points[a2.d];
        Vector2d vector2d = new Vector2d((g)moPoint, g2);
        Vector2d vector2d2 = vector2d.norm_new();
        g g3 = new g(moPoint.x + vector2d.x * (double)a2.e + vector2d2.x * (double)a2.f, moPoint.y + vector2d.y * (double)a2.e + vector2d2.y * (double)a2.f);
        return g3;
    }

    public String toString() {
        return "Morphing [ " + this.points.length + " / " + this.lines.length + " ]";
    }

    public class MoLine
    implements IInterpolatable,
    f {
        public int index1;
        public int index2;

        public MoLine() {
        }

        public MoLine(int n2, int n3) {
            this.index1 = n2;
            this.index2 = n3;
        }

        public int getIndex() {
            MoLine[] moLineArray = BasicMorphV2.this.lines;
            int n2 = 0;
            while (n2 < moLineArray.length) {
                if (moLineArray[n2] == this) {
                    return n2;
                }
                ++n2;
            }
            throw new RuntimeException("Illegal state :_");
        }

        public boolean isUsing(int n2) {
            return this.index1 == n2 || this.index2 == n2;
        }

        @Override
        public Object deepClone() {
            MoLine moLine = new MoLine();
            moLine.index1 = this.index1;
            moLine.index2 = this.index2;
            return moLine;
        }

        @Override
        public void init(Object object) {
            MoLine moLine = (MoLine)object;
            this.index1 = moLine.index1;
            this.index2 = moLine.index2;
        }

        @Override
        public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
            MoLine moLine = (MoLine)iInterpolatable;
            MoLine moLine2 = new MoLine();
            moLine2.index1 = d2 <= 0.5 ? this.index1 : moLine.index1;
            moLine2.index2 = d2 <= 0.5 ? this.index2 : moLine.index2;
            return moLine2;
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            this.index1 = g2.g(element, "index1");
            this.index2 = g2.g(element, "index2");
        }

        @Override
        public void write(l l2, Element element) {
            l2.b(element, "index1", this.index1);
            l2.b(element, "index2", this.index2);
        }

        @Override
        public Object getOwner() {
            return BasicMorphV2.this;
        }
    }

    public class MoPoint
    extends jp.noids.graphics.c.a
    implements IInterpolatable,
    f {
        private static final long serialVersionUID = 1L;
        int selfIndex;

        public MoPoint() {
            this.selfIndex = -1;
        }

        public MoPoint(float f2, float f3) {
            super(f2, f3);
            this.selfIndex = -1;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.x = (float)d2;
            this.y = (float)d3;
            BasicMorphV2.this.dirtyPatch = true;
            BasicMorphV2.this.dirtyBounds = true;
        }

        @Override
        public void checkAndRollback(ITransform iTransform) {
        }

        public int getIndex() {
            if (this.selfIndex != -1) {
                return this.selfIndex;
            }
            MoPoint[] moPointArray = BasicMorphV2.this.points;
            int n2 = 0;
            while (n2 < moPointArray.length) {
                if (moPointArray[n2] == this) {
                    return n2;
                }
                ++n2;
            }
            moPointArray = BasicMorphV2.this.points;
            n2 = 0;
            while (n2 < moPointArray.length) {
                if (moPointArray[n2] == this) {
                    return n2;
                }
                ++n2;
            }
            return 0;
        }

        @Override
        public void read(jp.noids.xml.serialize.g g2, Element element) {
            this.x = g2.h(element, "x");
            this.y = g2.h(element, "y");
        }

        @Override
        public void write(l l2, Element element) {
            l2.b(element, "x", (float)this.x);
            l2.b(element, "y", (float)this.y);
        }

        @Override
        public MoPoint deepClone() {
            throw new RuntimeException(a.b.a("CUBI-1277"));
        }

        @Override
        public void init(Object object) {
            MoPoint moPoint = (MoPoint)object;
            this.x = moPoint.x;
            this.y = moPoint.y;
        }

        @Override
        public IInterpolatable interpolate(IInterpolatable iInterpolatable, double d2) {
            MoPoint moPoint = (MoPoint)iInterpolatable;
            MoPoint moPoint2 = new MoPoint();
            moPoint2.x = (float)(this.x + (moPoint.x - this.x) * d2);
            moPoint2.y = (float)(this.y + (moPoint.y - this.y) * d2);
            return moPoint2;
        }

        @Override
        public Object getOwner() {
            return BasicMorphV2.this;
        }
    }

    public class a {
        public float a;
        public float b;
        int c = -1;
        int d = -1;
        float e;
        float f;

        public a(float f2, float f3) {
            this.a = f2;
            this.b = f3;
        }

        public a(float f2, float f3, int n2, int n3, float f4, float f5) {
            this.a = f2;
            this.b = f3;
            this.c = n2;
            this.d = n3;
            this.e = f4;
            this.f = f5;
        }
    }
}

