/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.movie.effect.attr.value;

import a.h;
import java.awt.Container;
import javax.swing.JFrame;
import jp.noids.framework.property.H;
import jp.noids.framework.property.s;
import jp.noids.graphics.f.y;
import jp.noids.movie.effect.attr.MvAttrF;
import jp.noids.movie.effect.attr.c;
import jp.noids.movie.effect.attr.value.AbstractValueSequence;
import jp.noids.movie.effect.attr.value.MvBezierPt;
import jp.noids.movie.effect.attr.value.SeqPt;
import jp.noids.movie.effect.attr.value.a;
import jp.noids.movie.effect.attr.value.b;
import jp.noids.util.O;
import jp.noids.xml.serialize.g;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class OriginalSequence
extends AbstractValueSequence {
    private static final double GOSA_ = 0.05;
    static final double PI_H = 1.5707963267948966;
    static double CURVE_ERROR = 0.01;
    protected SeqPt[] points;
    MvBezierPt[] bezierPts = null;
    static final double V = 0.0;
    static double[][] SAMPLE_POINTS;

    static {
        H h2 = H.e();
        h2.a(new s(h.a("MOVI-0006"), CURVE_ERROR, 1.0E-6, 0.5, new a()));
        SAMPLE_POINTS = new double[][]{{0.0, 0.0, 30.0, 45.0, 45.0, 30.0, 50.0, 19.0, 60.0, 15.0, 70.0, 15.0, 90.0, 20.0, 110.0, 22.0, 120.0, 45.0}, {0.0, 0.0, 22.0, 450.0, 43.0, 205.0}, {0.0, 0.0, 12.0, 111.0, 25.0, 392.0}, {0.0, 0.0, 30.0, 100.0, 100.0, 0.0}, {0.0, 0.0, 50.0, 500.0, 100.0, 400.0}, {0.0, 0.0, 100.0, 50.0, 150.0, 500.0, 300.0, 500.0, 600.0, 400.0, 800.0, 900.0, 1000.0, 600.0}};
    }

    public OriginalSequence() {
        this(null, 0, 0.0);
    }

    public OriginalSequence(MvAttrF mvAttrF) {
        this(mvAttrF, 0, 0.0);
    }

    public OriginalSequence(int n2, double d2) {
        this(null, n2, d2);
    }

    public OriginalSequence(MvAttrF mvAttrF, int n2, double d2) {
        super(mvAttrF, d2);
        this.points = new SeqPt[0];
        this.setDirty_exe(true);
    }

    public OriginalSequence(MvAttrF mvAttrF, boolean[] blArray, double[] dArray) {
        super(mvAttrF, 0.0);
        assert (blArray.length == dArray.length);
        int n2 = blArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (blArray[n4]) {
                ++n3;
            }
            ++n4;
        }
        this.points = new SeqPt[n3];
        n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (blArray[n5]) {
                this.points[n4] = new SeqPt(n5, dArray[n5]);
                ++n4;
            }
            ++n5;
        }
        this.setDirty_exe(true);
    }

    @Override
    public void read(g g2, Element element) {
        int n2 = g2.a(element);
        if (n2 >= 1001) {
            super.read(g2, g2.b(element));
        }
        this.points = (SeqPt[])g2.a(element, "points");
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1001);
        super.write(l2, l2.a(element));
        l2.a(element, "points", this.points);
    }

    @Override
    public Object deepClone() {
        OriginalSequence originalSequence = new OriginalSequence();
        originalSequence.init(this);
        return originalSequence;
    }

    @Override
    public void init(Object object) {
        OriginalSequence originalSequence = (OriginalSequence)object;
        super.init(originalSequence);
        this.points = (SeqPt[])jp.noids.util.c.c(originalSequence.points);
        this.setDirty_exe(true);
    }

    @Override
    public void dump() {
        String string = "";
        int n2 = 0;
        while (n2 < this.points.length) {
            SeqPt seqPt = this.points[n2];
            string = String.valueOf(string) + String.format("%d ", seqPt.pos) + " , " + String.format("%6.1f ", seqPt.value) + " , ";
            ++n2;
        }
        System.out.printf("SNSPointData pos , v = { %s } \n", string);
    }

    @Override
    public void setDoubleValueAuto(int n2, double d2) {
        int n3 = 0;
        while (n3 < this.points.length) {
            if (this.points[n3].pos >= n2) break;
            ++n3;
        }
        SeqPt seqPt = new SeqPt(n2, d2);
        if (n3 >= this.points.length) {
            this.points = (SeqPt[])jp.noids.util.c.a((Object[])this.points, seqPt, n3);
        } else if (n3 == 0 && this.points[0].getPos() > n2) {
            this.points = (SeqPt[])jp.noids.util.c.a((Object[])this.points, seqPt, 0);
        } else if (this.points[n3].getPos() == n2) {
            this.points[n3].setValue(d2);
        } else {
            this.points = (SeqPt[])jp.noids.util.c.a((Object[])this.points, seqPt, n3);
        }
        this.setDirty_exe(true);
    }

    @Override
    public void removeDoubleValueAuto(int n2) {
        this.setDirty_exe(true);
        int n3 = 0;
        while (n3 < this.points.length) {
            if (this.points[n3].pos >= n2) break;
            ++n3;
        }
        if (n3 < this.points.length && this.points[n3].getPos() == n2) {
            this.points = (SeqPt[])jp.noids.util.c.a((Object[])this.points, n3);
        }
    }

    @Override
    public void clear() {
        this.setDirty_exe(true);
        this.points = new SeqPt[0];
    }

    public void getKeyRange(int[] nArray) {
        nArray[0] = this.keyMin;
        nArray[1] = this.keyMax;
    }

    @Override
    protected void update() {
        this.bezierPts = this.setupBezierPts();
        int n2 = this.bezierPts.length;
        if (this.keyPts2 == null || this.keyPts2.length < n2) {
            this.keyPts2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.keyPts2[n3] = this.bezierPts[n3].anchor.getPos();
            ++n3;
        }
        if (n2 == 0) {
            this.keyMin = Integer.MAX_VALUE;
            this.keyMax = Integer.MIN_VALUE;
        } else {
            this.keyMin = this.keyPts2[0];
            this.keyMax = this.keyPts2[n2 - 1];
        }
        this.curMin = Double.POSITIVE_INFINITY;
        this.curMax = Double.NEGATIVE_INFINITY;
        n3 = 0;
        while (n3 < n2) {
            double d2 = this.bezierPts[n3].anchor.value;
            if (d2 < this.curMin) {
                this.curMin = d2;
            }
            if (d2 > this.curMax) {
                this.curMax = d2;
            }
            ++n3;
        }
        this.setDirty_exe(false);
    }

    @Override
    public double getDoubleValue(int n2) {
        if (this.isDirty()) {
            this.update();
        }
        if (n2 == this.lastPos && !Double.isNaN(this.lastValue)) {
            return this.lastValue;
        }
        int n3 = this.bezierPts.length;
        double d2 = 0.0;
        if (n3 == 0) {
            d2 = this.baseValue;
        } else if (n3 == 1) {
            d2 = this.bezierPts[0].anchor.getDoubleValue();
        } else {
            int n4 = n2 - this.posStart;
            MvBezierPt mvBezierPt = this.bezierPts[0];
            int n5 = mvBezierPt.anchor.getPos();
            if (n4 <= n5) {
                d2 = mvBezierPt.anchor.value;
            } else {
                MvBezierPt mvBezierPt2 = mvBezierPt;
                boolean bl2 = false;
                int n6 = 1;
                while (n6 < n3) {
                    MvBezierPt mvBezierPt3 = this.bezierPts[n6];
                    if (n4 <= mvBezierPt3.anchor.pos) {
                        bl2 = true;
                        d2 = jp.live2d.type_editor.b.a(n4, CURVE_ERROR, mvBezierPt2.anchor.pos, mvBezierPt2.anchor.value, mvBezierPt2.next.pos, mvBezierPt2.next.value, mvBezierPt3.prev.pos, mvBezierPt3.prev.value, mvBezierPt3.anchor.pos, mvBezierPt3.anchor.value);
                        break;
                    }
                    mvBezierPt2 = mvBezierPt3;
                    ++n6;
                }
                if (!bl2) {
                    d2 = mvBezierPt2.anchor.value;
                }
            }
        }
        this.lastPos = n2;
        this.lastValue = d2;
        return d2;
    }

    private MvBezierPt[] setupBezierPts() {
        int n2 = this.points.length;
        if (n2 == 0) {
            return new MvBezierPt[0];
        }
        if (n2 == 1) {
            return new MvBezierPt[]{new MvBezierPt(this.points[0].getPos(), this.points[0].getDoubleValue())};
        }
        boolean[] blArray = new boolean[n2];
        blArray[0] = true;
        blArray[n2 - 1] = true;
        int n3 = 1;
        while (n3 < n2 - 1) {
            double d2 = this.points[n3 - 1].value;
            double d3 = this.points[n3].value;
            double d4 = this.points[n3 + 1].value;
            if (d3 == d2 || d3 == d4) {
                blArray[n3] = true;
            } else if (d3 < d2 && d3 < d4) {
                blArray[n3] = true;
            } else if (d3 > d2 && d3 > d4) {
                blArray[n3] = true;
            }
            ++n3;
        }
        MvBezierPt[] mvBezierPtArray = new MvBezierPt[n2];
        int n4 = 0;
        while (n4 < n2) {
            MvBezierPt mvBezierPt;
            SeqPt seqPt = this.points[n4];
            mvBezierPtArray[n4] = mvBezierPt = new MvBezierPt(seqPt.pos, seqPt.value);
            if (n4 > 0) {
                mvBezierPt.prev = new SeqPt();
                mvBezierPt.prev.pos = (2 * seqPt.pos + this.points[n4 - 1].pos) / 3;
            }
            if (n4 < n2 - 1) {
                mvBezierPt.next = new SeqPt();
                mvBezierPt.next.pos = (2 * seqPt.pos + this.points[n4 + 1].pos) / 3;
            }
            if (blArray[n4]) {
                if (n4 > 0) {
                    mvBezierPt.prev.value = seqPt.value;
                }
                if (n4 < n2 - 1) {
                    mvBezierPt.next.value = seqPt.value;
                }
            } else if (n4 > 0 && n4 < n2 - 1) {
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                double d11 = (double)(this.points[n4].pos - this.points[n4 - 1].pos) / 3.0;
                double d12 = (double)(this.points[n4 + 1].pos - this.points[n4].pos) / 3.0;
                double d13 = (this.points[n4].value - this.points[n4 - 1].value) * (blArray[n4 - 1] ? 0.6666666666666666 : 0.3333333333333333);
                double d14 = Math.atan2(d13, d11);
                double d15 = (d14 * (d10 = d11 / (1.0 - (d9 = 1.0 - (d14 > 0.0 ? d14 : -d14) / 1.5707963267948966))) + (d8 = Math.atan2(d7 = (this.points[n4 + 1].value - this.points[n4].value) * (blArray[n4 + 1] ? 0.6666666666666666 : 0.3333333333333333), d12)) * (d6 = d12 / (1.0 - (d5 = 1.0 - (d8 > 0.0 ? d8 : -d8) / 1.5707963267948966)))) / (d10 + d6);
                if (Double.isNaN(d15)) {
                    d15 = 0.0;
                }
                mvBezierPt.prev.value = mvBezierPt.anchor.value - d11 * Math.tan(d15);
                mvBezierPt.next.value = mvBezierPt.anchor.value + d12 * Math.tan(d15);
            }
            ++n4;
        }
        return mvBezierPtArray;
    }

    double[] getArray(double[] dArray, int n2) {
        return dArray != null && dArray.length == n2 ? dArray : new double[n2];
    }

    @Override
    public void setDirty() {
        super.setDirty_exe(true);
    }

    public static OriginalSequence createSample(int n2) {
        OriginalSequence originalSequence = new OriginalSequence();
        double[] dArray = SAMPLE_POINTS[n2 % SAMPLE_POINTS.length];
        return OriginalSequence.createSample(dArray);
    }

    public static OriginalSequence createSample(double[] dArray) {
        SeqPt seqPt;
        OriginalSequence originalSequence = new OriginalSequence();
        int n2 = dArray.length / 2;
        originalSequence.points = new SeqPt[n2];
        originalSequence.points[0] = seqPt = new SeqPt((int)dArray[0], dArray[1]);
        originalSequence.points[originalSequence.points.length - 1] = seqPt = new SeqPt((int)dArray[dArray.length - 2], dArray[dArray.length - 1]);
        int n3 = 0;
        while (n3 < n2 - 2) {
            SeqPt seqPt2;
            int n4 = 2 + n3 * 2;
            originalSequence.points[n3 + 1] = seqPt2 = new SeqPt((int)dArray[n4], dArray[n4 + 1]);
            ++n3;
        }
        return originalSequence;
    }

    public static void main(String[] stringArray) {
        int n2 = 0;
        double[] dArray = SAMPLE_POINTS[n2];
        OriginalSequence originalSequence = OriginalSequence.createSample(n2);
        int n3 = (int)dArray[0];
        int n4 = (int)dArray[dArray.length - 2];
        int n5 = 20;
        JFrame jFrame = O.a("OriginalSequence", h.a("MOVI-0007"), 800, 600, true);
        Container container = jFrame.getContentPane();
        int n6 = 5;
        int n7 = 5;
        b b2 = new b(n3, n4, originalSequence);
        b2.a((n4 - n3) * 5, 200.0);
        y y2 = new y(b2);
        container.add(y2);
        jFrame.setVisible(true);
        System.out.printf("%f\t\t\t\t\t@@OriginalSequence\n", Math.atan2(-0.1, 1.0));
    }

    @Override
    public void addFrame(int n2, int n3) {
        this.points = (SeqPt[])c.a(this.points, n2, n3);
        this.setDirty();
    }

    @Override
    public void removeFrame(int n2, int n3) {
        this.points = (SeqPt[])c.b(this.points, n2, n3);
        this.setDirty();
    }
}

