/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.movie.track;

import java.awt.Graphics2D;
import java.awt.geom.NoninvertibleTransformException;
import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.i;
import jp.noids.graphics.j;
import jp.noids.movie.core.MvDoc;
import jp.noids.movie.core.h;
import jp.noids.movie.effect.IMvEffect;
import jp.noids.movie.effect.MvEffect_SoundDefault;
import jp.noids.movie.effect.MvEffect_VisualDefault;
import jp.noids.movie.effect.attr.IMvAttr;
import jp.noids.movie.effect.attr.c;
import jp.noids.movie.effect.attr.xy.XY_TNSSequence;
import jp.noids.movie.scene.MvScene;
import jp.noids.movie.track.MvEffectManager;
import jp.noids.movie.track.MvTrack_Group;
import jp.noids.movie.track.TrackID;
import jp.noids.movie.track.TrackMarker;
import jp.noids.movie.track.resource.IResourceRef;
import jp.noids.movie.track.resource.a.b;
import jp.noids.movie.ui.f.b;
import jp.noids.movie.ui.track.e;
import jp.noids.ui.l.d;
import jp.noids.util.C;
import jp.noids.util.O;
import jp.noids.util.UtCache;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public abstract class IMvTrack
implements b,
jp.noids.ui.l.b,
d,
jp.noids.xml.serialize.h {
    protected String name;
    protected boolean userRenamed = false;
    protected TrackID id;
    protected int start = 0;
    protected int internalOffset = 0;
    protected int duration = 1;
    protected boolean editable = true;
    protected boolean visible = true;
    protected boolean mute = false;
    protected transient MvTrack_Group parentTrack = null;
    protected transient MvScene scene;
    protected g originPoint = new g();
    protected final jp.noids.movie.effect.d visualHandler = new jp.noids.movie.effect.d(this);
    protected final jp.noids.movie.effect.b soundHandler = new jp.noids.movie.effect.b(this);
    private MvEffect_SoundDefault soundEffect = null;
    private MvEffect_VisualDefault visualEffect = null;
    private MvEffectManager effectManager = new MvEffectManager();
    protected transient e trackLayoutManager = null;
    protected transient boolean expanded;
    private transient boolean dirty = true;
    private static int autoIdCount = 0;
    private b.d rowSet = null;
    private TrackMarker[] markerList = new TrackMarker[0];
    HashMap<Thread, a> transformCacheMap = new HashMap();
    HashMap<Thread, a> invTransformCacheMap = new HashMap();
    transient int[] keys;

    public IMvTrack() {
        this.id = new TrackID("no_id" + autoIdCount);
        this.name = "Untitled";
    }

    public IMvTrack(TrackID trackID, String string) {
        this.id = trackID;
        this.name = string;
    }

    public void dispose() {
        if (this.visualHandler != null) {
            this.visualHandler.a();
        }
        if (this.soundHandler != null) {
            this.soundHandler.a();
        }
        if (this.soundEffect != null) {
            this.soundEffect.dispose();
        }
        if (this.visualEffect != null) {
            this.visualEffect.dispose();
        }
        this.effectManager.dispose();
    }

    public String getTrackMarker(int n2) {
        int n3 = 0;
        while (n3 < this.markerList.length) {
            TrackMarker trackMarker = this.markerList[n3];
            if (trackMarker.localPos == n2) {
                return trackMarker.memo;
            }
            ++n3;
        }
        return null;
    }

    public void setTrackMarker(int n2, String string) {
        int n3 = 0;
        while (n3 < this.markerList.length) {
            TrackMarker trackMarker = this.markerList[n3];
            if (trackMarker.localPos == n2) {
                if (string == null || string.length() == 0) {
                    this.markerList = (TrackMarker[])jp.noids.util.c.a((Object[])this.markerList, n3);
                    return;
                }
                trackMarker.memo = string;
                return;
            }
            ++n3;
        }
        TrackMarker trackMarker = new TrackMarker(n2, string);
        this.markerList = (TrackMarker[])jp.noids.util.c.c(this.markerList, trackMarker);
    }

    public TrackMarker[] getMarkerList() {
        return this.markerList;
    }

    public void setRowSet(b.d d2) {
        this.rowSet = d2;
    }

    public b.d getRowSet() {
        return this.rowSet;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        int n2 = g2.a(element);
        this.name = (String)g2.a(element, "name");
        this.id = (TrackID)g2.a(element, "id");
        this.start = g2.b(element, "start");
        this.duration = g2.b(element, "duration");
        this.editable = g2.e(element, "editable");
        this.visible = g2.e(element, "visible");
        this.mute = g2.e(element, "mute");
        this.parentTrack = (MvTrack_Group)g2.a(element, "parentTrack");
        this.scene = (MvScene)g2.a(element, "scene");
        this.originPoint = (g)g2.a(element, "originPoint");
        this.effectManager = (MvEffectManager)g2.a(element, "effectManager");
        this.soundEffect = (MvEffect_SoundDefault)g2.a(element, "soundEffect");
        this.visualEffect = (MvEffect_VisualDefault)g2.a(element, "visualEffect");
        this.internalOffset = n2 >= 1001 ? g2.b(element, "internalOffset") : 0;
        this.markerList = n2 >= 1002 ? (TrackMarker[])g2.a(element, "markerList") : new TrackMarker[0];
        this.effectManager.setTrack(this);
    }

    @Override
    public void write(l l2, Element element) {
        l2.a(element, 1002);
        l2.a(element, "name", this.name);
        l2.a(element, "id", this.id);
        l2.a(element, "start", this.start);
        l2.a(element, "duration", this.duration);
        l2.a(element, "editable", this.editable);
        l2.a(element, "visible", this.visible);
        l2.a(element, "mute", this.mute);
        l2.a(element, "parentTrack", this.parentTrack);
        l2.a(element, "scene", this.scene);
        l2.a(element, "originPoint", this.originPoint);
        l2.a(element, "effectManager", this.effectManager);
        l2.a(element, "soundEffect", this.soundEffect);
        l2.a(element, "visualEffect", this.visualEffect);
        l2.a(element, "internalOffset", this.internalOffset);
        l2.a(element, "markerList", this.markerList);
    }

    @Override
    public abstract Object deepClone();

    public void init(Object object, boolean bl2) {
        IMvTrack iMvTrack = (IMvTrack)object;
        this.name = iMvTrack.name;
        this.id = iMvTrack.id;
        this.start = iMvTrack.start;
        this.duration = iMvTrack.duration;
        this.editable = iMvTrack.editable;
        this.visible = iMvTrack.visible;
        this.mute = iMvTrack.mute;
        this.parentTrack = iMvTrack.parentTrack;
        this.scene = iMvTrack.scene;
        this.originPoint.setLocation(iMvTrack.originPoint);
        this.effectManager = (MvEffectManager)iMvTrack.effectManager.deepClone();
        this.effectManager.setTrack(this);
        this.trackLayoutManager = null;
        this.expanded = false;
        this.visualEffect = (MvEffect_VisualDefault)this.get(iMvTrack.getVisualEffect());
        this.soundEffect = (MvEffect_SoundDefault)this.get(iMvTrack.getSoundEffect());
        this.internalOffset = iMvTrack.internalOffset;
        this.markerList = new TrackMarker[iMvTrack.markerList.length];
        int n2 = 0;
        while (n2 < iMvTrack.markerList.length) {
            TrackMarker trackMarker = iMvTrack.markerList[n2];
            this.markerList[n2] = new TrackMarker(trackMarker.localPos, trackMarker.memo);
            ++n2;
        }
        this.dirty = true;
    }

    private IMvEffect get(IMvEffect iMvEffect) {
        if (iMvEffect == null) {
            return null;
        }
        return this.effectManager.getEffect(iMvEffect.getID());
    }

    public void drawTrack(jp.noids.movie.ui.track.c.b b2) {
    }

    protected boolean readSetupResource(jp.noids.xml.serialize.g g2, IResourceRef iResourceRef) {
        boolean bl2;
        block11: {
            block10: {
                boolean bl3 = bl2 = !iResourceRef.isInitialized();
                if (bl2) {
                    try {
                        iResourceRef.init(jp.noids.movie.track.resource.b.b());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.printf("file not found :: %s\t\t\t\t\t@@MvTrack\n", fileNotFoundException.getLocalizedMessage());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    if (!iResourceRef.isValid()) break block10;
                    return true;
                }
                catch (Exception exception) {
                    throw new jp.noids.xml.serialize.e(String.valueOf(a.h.a("MOVI-0084")) + iResourceRef.getName(), exception);
                }
            }
            if (!iResourceRef.isRecoverSkipped()) break block11;
            return false;
        }
        if (!g2.f()) {
            throw new jp.noids.xml.serialize.e(String.valueOf(a.h.a("MOVI-0084")) + iResourceRef.getName());
        }
        if (bl2 && g2.e()) {
            JOptionPane.showMessageDialog(O.h(), String.valueOf(a.h.a("MOVI-0085")) + iResourceRef.getName());
        }
        return false;
    }

    public abstract i getBounds(h var1);

    public abstract i getBounds(h var1, jp.live2d.type_editor.a var2);

    public abstract boolean contains(h var1, g var2);

    public boolean isEditable() {
        if (this.dirty) {
            this.update();
        }
        return this.editable;
    }

    public void setEditable(boolean bl2) {
        this.editable = bl2;
    }

    public boolean isVisible() {
        if (this.dirty) {
            this.update();
        }
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    public boolean isVisualTrack() {
        if (this.dirty) {
            this.update();
        }
        return this.visualEffect != null;
    }

    public boolean isSoundTrack() {
        if (this.dirty) {
            this.update();
        }
        return this.soundEffect != null;
    }

    public boolean isAvailable(h h2) {
        return this.visible && this.editable && this.isInBound(h2);
    }

    public boolean isInBound(h h2) {
        if (this.dirty) {
            this.update();
        }
        int n2 = this.getLocalFramePos(h2);
        return this.isInBoundLocal(n2);
    }

    public boolean isInBoundLocal(int n2) {
        return n2 - this.internalOffset >= 0 && n2 - this.internalOffset < this.getDuration();
    }

    public jp.live2d.type_editor.a getTrackToParentTransform(h h2) {
        Thread thread;
        a a2;
        if (this.dirty) {
            this.update();
        }
        if ((a2 = this.transformCacheMap.get(thread = Thread.currentThread())) == null) {
            a2 = new a();
            this.transformCacheMap.put(thread, a2);
        }
        if (a2.a == null || a2.b != h2.a()) {
            jp.live2d.type_editor.a a3;
            a2.a = a3 = this.visualHandler.a(h2);
            a2.b = h2.a();
            return a3;
        }
        return a2.a;
    }

    public jp.live2d.type_editor.a getParentToTrackTransform(h h2) {
        Thread thread;
        a a2;
        if (this.dirty) {
            this.update();
        }
        if ((a2 = this.invTransformCacheMap.get(thread = Thread.currentThread())) == null) {
            a2 = new a();
            this.invTransformCacheMap.put(thread, a2);
        }
        if (a2.a == null || a2.b != h2.a()) {
            jp.live2d.type_editor.a a3;
            a2.a = a3 = this.getTrackToParentTransform(h2).b();
            a2.b = h2.a();
            return a3;
        }
        return a2.a;
    }

    public jp.live2d.type_editor.a getTrackToLogicalTransform(h h2) {
        MvTrack_Group mvTrack_Group;
        if (this.dirty) {
            this.update();
        }
        if ((mvTrack_Group = this.getParentTrack()) == null) {
            return new jp.live2d.type_editor.a();
        }
        try {
            jp.live2d.type_editor.a a2 = new jp.live2d.type_editor.a(mvTrack_Group.getTrackToLogicalTransform(h2));
            a2.concatenate(this.getParentToTrackTransform(h2).b());
            return a2;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            try {
                if (C.e()) {
                    System.err.printf("force converted Transform as invertable ,  \t\t\t\t\t@@IMvTrack\n", new Object[0]);
                }
                jp.live2d.type_editor.a a3 = new jp.live2d.type_editor.a(mvTrack_Group.getTrackToLogicalTransform(h2));
                jp.live2d.type_editor.a a4 = this.getParentToTrackTransform(h2);
                a4.setToScale(0.001, 0.001);
                a4.b();
                a3.concatenate(a4);
                return a3;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException2) {
                noninvertibleTransformException2.printStackTrace();
                if (C.e()) {
                    throw new RuntimeException("Illegal State");
                }
                return null;
            }
        }
    }

    public jp.live2d.type_editor.a getLogicalToTrackTransform(h h2) {
        MvTrack_Group mvTrack_Group;
        if (this.dirty) {
            this.update();
        }
        if ((mvTrack_Group = this.getParentTrack()) == null) {
            return new jp.live2d.type_editor.a();
        }
        jp.live2d.type_editor.a a2 = new jp.live2d.type_editor.a(mvTrack_Group.getLogicalToTrackTransform(h2));
        try {
            a2.preConcatenate(this.getParentToTrackTransform(h2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return a2;
    }

    public void dump() {
        System.out.printf("%s [%s] (%s)\n", this.name, this.id, this.getClass().getSimpleName());
    }

    public boolean isParent() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setRenameFlag(boolean bl2) {
        this.userRenamed = bl2;
    }

    public boolean isUserRenamed() {
        return this.userRenamed;
    }

    public TrackID getID() {
        return this.id;
    }

    public void setID(TrackID trackID) {
        this.id = trackID;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n2) {
        this.start = n2;
    }

    public int getInternalOffset() {
        return this.internalOffset;
    }

    public void setInternalOffset(int n2) {
        this.internalOffset = n2;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n2) {
        this.duration = n2;
    }

    public int getEnd() {
        return this.start + this.duration - 1;
    }

    public MvEffectManager getEffectManager() {
        if (this.dirty) {
            this.update();
        }
        return this.effectManager;
    }

    public e getTrackLayoutManager() {
        if (this.dirty) {
            this.update();
        }
        if (this.trackLayoutManager == null) {
            this.trackLayoutManager = new e(this);
        }
        return this.trackLayoutManager;
    }

    public abstract void draw(jp.noids.movie.scene.a var1);

    public void postPaint_forTrackHandler(Graphics2D graphics2D, h h2, jp.live2d.type_editor.a a2) {
    }

    public void setParent_callback(MvTrack_Group mvTrack_Group) {
        this.parentTrack = mvTrack_Group;
        if (mvTrack_Group.getScene() != null) {
            this.scene = mvTrack_Group.getScene();
        }
        this.setDirty();
    }

    public MvTrack_Group getParentTrack() {
        return this.parentTrack;
    }

    public IMvTrack getFrontSibling() {
        MvTrack_Group mvTrack_Group;
        if (this.dirty) {
            this.update();
        }
        if ((mvTrack_Group = this.getParentTrack()) == null) {
            return null;
        }
        int n2 = mvTrack_Group.getChildPos(this);
        if (n2 < 0) {
            throw new RuntimeException("Illegal State");
        }
        if (n2 + 1 < mvTrack_Group.getChildCount()) {
            return mvTrack_Group.getChildTrack(n2 + 1);
        }
        return null;
    }

    public IMvTrack getBackSibling() {
        MvTrack_Group mvTrack_Group;
        if (this.dirty) {
            this.update();
        }
        if ((mvTrack_Group = this.getParentTrack()) == null) {
            return null;
        }
        int n2 = mvTrack_Group.getChildPos(this);
        if (n2 < 0) {
            throw new RuntimeException("Illegal State");
        }
        if (n2 - 1 >= 0) {
            return mvTrack_Group.getChildTrack(n2 - 1);
        }
        return null;
    }

    public int getLocalFramePos(h h2) {
        if (this.dirty) {
            this.update();
        }
        return h2.a() - this.start + this.internalOffset;
    }

    public h getGlobalTime(int n2) {
        if (this.dirty) {
            this.update();
        }
        return new h(n2 + this.start - this.internalOffset);
    }

    public jp.noids.movie.effect.d getVisualHandler() {
        if (this.dirty) {
            this.update();
        }
        return this.visualHandler;
    }

    public jp.noids.movie.effect.b getSoundHandler() {
        if (this.dirty) {
            this.update();
        }
        return this.soundHandler;
    }

    public MvScene getScene() {
        if (this.dirty) {
            this.update();
        }
        return this.scene;
    }

    public void setScene_callback(MvScene mvScene) {
        this.scene = mvScene;
        this.setDirty();
    }

    public MvDoc getDoc() {
        if (this.dirty) {
            this.update();
        }
        return this.scene == null ? null : this.scene.getDoc();
    }

    public jp.noids.ui.l.c getUndoManager() {
        MvDoc mvDoc = this.getDoc();
        return mvDoc == null ? null : mvDoc.getUndoManager();
    }

    public void setExpanded(boolean bl2) {
        this.expanded = bl2;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public MvEffect_SoundDefault getSoundEffect() {
        return this.soundEffect;
    }

    public MvEffect_VisualDefault getVisualEffect() {
        return this.visualEffect;
    }

    protected void setupSoundHandler() {
        this.soundEffect = new MvEffect_SoundDefault(this);
        this.getEffectManager().addEffect(this.soundEffect);
    }

    protected void setupVisualHandler(g g2, g g3, g g4) {
        this.visualEffect = new MvEffect_VisualDefault(this);
        this.getEffectManager().addEffect(this.visualEffect);
        this.originPoint.x = g2.x;
        this.originPoint.y = g2.y;
        XY_TNSSequence xY_TNSSequence = new XY_TNSSequence(g4.x, g4.y, 0);
        this.visualEffect.attrXY.setValueData(xY_TNSSequence);
        this.visualEffect.attrScaleX.setValueData(c.a(0, 100.0));
        this.visualEffect.attrScaleY.setValueData(c.a(0, 100.0));
        XY_TNSSequence xY_TNSSequence2 = new XY_TNSSequence(g3.x, g3.y, 0);
        this.visualEffect.attrAnchorXY.setValueData(xY_TNSSequence2);
        this.visualEffect.attrRotate.setValueData(c.a(0, 0.0));
        this.visualEffect.attrShear.setValueData(c.a(0, 0.0));
        this.setDirty();
    }

    public String toString() {
        return "IMvTrack[ " + this.name + "/" + this.id + " ]";
    }

    public int[] getKeyFrames() {
        if (this.dirty) {
            this.update();
        }
        if (this.keys == null) {
            IMvAttr[] iMvAttrArray;
            int n2;
            Object[] objectArray;
            int n3 = 0;
            IMvEffect[] iMvEffectArray = this.getEffectManager().getEffectList();
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            int[] nArray = new int[2];
            int n6 = 0;
            while (n6 < iMvEffectArray.length) {
                objectArray = iMvEffectArray[n6].getAttrList();
                n2 = 0;
                while (n2 < objectArray.length) {
                    iMvAttrArray = objectArray[n2];
                    if (n4 > iMvAttrArray.getKeyMin()) {
                        n4 = iMvAttrArray.getKeyMin();
                    }
                    if (n5 < iMvAttrArray.getKeyMax()) {
                        n5 = iMvAttrArray.getKeyMax();
                    }
                    ++n2;
                }
                ++n6;
            }
            if (n4 > n5) {
                this.keys = new int[0];
            } else {
                int n7;
                n6 = n5 - n4 + 1;
                objectArray = UtCache.getIntArray((int)Math.ceil((double)n6 / 32.0));
                n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    objectArray[n2] = (IMvAttr)false;
                    --n2;
                }
                n2 = 0;
                while (n2 < iMvEffectArray.length) {
                    iMvAttrArray = iMvEffectArray[n2].getAttrList();
                    n7 = 0;
                    while (n7 < iMvAttrArray.length) {
                        IMvAttr iMvAttr = iMvAttrArray[n7];
                        int[] nArray2 = iMvAttr.getKeyFrames();
                        int n8 = 0;
                        while (n8 < nArray2.length) {
                            int n9 = nArray2[n8] - n4;
                            int n10 = n9 / 32;
                            if (n10 < 0 || n10 >= objectArray.length) {
                                if (C.e()) {
                                    throw new RuntimeException("Illegal State : ");
                                }
                            } else if ((objectArray[n10] >>> 31 - n9 % 32 & 1) == 0) {
                                ++n3;
                                int n11 = n9 / 32;
                                objectArray[n11] = (IMvAttr)(objectArray[n11] | 1 << 31 - n9 % 32);
                            }
                            ++n8;
                        }
                        ++n7;
                    }
                    ++n2;
                }
                this.keys = new int[n3];
                n2 = 0;
                int n12 = 0;
                while (n12 <= n6) {
                    int n13 = n7 = (objectArray[n12 / 32] >>> 31 - n12 % 32 & 1) != 0 ? 1 : 0;
                    if (n7 != 0) {
                        this.keys[n2++] = n12 + n4;
                        if (n3 == n2) break;
                    }
                    ++n12;
                }
                UtCache.release(objectArray);
            }
        }
        return this.keys;
    }

    protected abstract void update();

    public abstract void setDirty();

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty_exe(boolean bl2) {
        this.dirty = bl2;
        if (bl2) {
            this.keys = null;
            this.effectManager.setDirty();
            Thread thread = Thread.currentThread();
            a a2 = this.transformCacheMap.get(thread);
            if (a2 == null) {
                a2 = new a();
                this.transformCacheMap.put(thread, a2);
            } else {
                a2.a = null;
            }
            a2 = this.invTransformCacheMap.get(thread);
            if (a2 == null) {
                a2 = new a();
                this.invTransformCacheMap.put(thread, a2);
            } else {
                a2.a = null;
            }
        }
    }

    public Icon getIcon(int n2) {
        return j.a(j.o(), n2);
    }

    protected abstract void resetName();

    @Override
    public void reloadPerformed(jp.noids.movie.track.resource.a.a a2) {
        try {
            System.out.printf("reload\t\t\t\t\t@@IMvTrack\n", new Object[0]);
            this.resetName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class a {
        jp.live2d.type_editor.a a;
        int b;

        a() {
        }
    }
}

