/*
 * Decompiled with CFR 0.152.
 */
package jp.noids.movie.track;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jp.live2d.type_editor.g;
import jp.live2d.type_editor.k;
import jp.noids.graphics.UtImage;
import jp.noids.graphics.f;
import jp.noids.graphics.i;
import jp.noids.graphics.j;
import jp.noids.graphics.m;
import jp.noids.movie.core.MvMovieInfo;
import jp.noids.movie.core.h;
import jp.noids.movie.track.IMvTrack_Linked;
import jp.noids.movie.track.TrackID;
import jp.noids.movie.track.resource.ARes_File;
import jp.noids.movie.track.resource.IResourceRef;
import jp.noids.movie.track.resource.Res_Linked_QTClone;
import jp.noids.movie.track.resource.a;
import jp.noids.movie.track.resource.b;
import jp.noids.util.aP;
import jp.noids.xml.serialize.e;
import jp.noids.xml.serialize.l;
import org.jdom.Element;

public class MvTrack_Image
extends IMvTrack_Linked<BufferedImage> {
    protected transient k imageSize = new k();
    transient int lastPos = -1;
    transient BufferedImage preview;
    transient jp.live2d.type_editor.a atPreview;
    BufferedImage cachedImage_dontUseDirect;
    transient a cacheInfo;
    static Random rand = new Random(1L);
    static int autoIdCount = 0;
    Icon icon;

    public MvTrack_Image() {
    }

    public MvTrack_Image(IResourceRef<BufferedImage> iResourceRef, MvMovieInfo mvMovieInfo, g g2) {
        this.setImage(iResourceRef, mvMovieInfo, g2);
    }

    @Override
    public void dispose() {
        if (this.preview != null) {
            this.preview.flush();
        }
        if (this.getResourceRef() != null) {
            this.getResourceRef().dispose();
        }
    }

    @Override
    public Object deepClone() {
        MvTrack_Image mvTrack_Image = new MvTrack_Image();
        mvTrack_Image.init(this);
        return mvTrack_Image;
    }

    @Override
    public void init(Object object) {
        MvTrack_Image mvTrack_Image = (MvTrack_Image)object;
        super.init(mvTrack_Image, false);
        this.setRes(mvTrack_Image.getResourceRef());
        this.checkAndUpdateImageCache(true);
        try {
            this.getResourceRef().init(b.b());
            if (!this.getResourceRef().isValid()) {
                throw new jp.noids.ui.l.f("Failed to init ");
            }
            this.setupImage(this.getImage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new jp.noids.ui.l.f(exception);
        }
    }

    @Override
    public MvTrack_Image duplicate() {
        return (MvTrack_Image)this.deepClone();
    }

    public void setImage(IResourceRef<BufferedImage> iResourceRef, MvMovieInfo mvMovieInfo, g g2) {
        iResourceRef.init(b.b());
        if (!iResourceRef.isValid()) {
            throw new Exception("Invalid movie Resource ");
        }
        this.setRes(iResourceRef);
        this.checkAndUpdateImageCache(true);
        BufferedImage bufferedImage = this.getImage();
        this.setupImage(bufferedImage);
        g g3 = new g(0.0, 0.0);
        g g4 = new g(this.imageSize.getWidth() / 2.0, this.imageSize.getHeight() / 2.0);
        this.setupVisualHandler(g3, g4, g2);
        this.duration = (int)mvMovieInfo.getFps();
    }

    private void setupImage(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        this.imageSize.setSize(n2, n3);
        int n4 = 360000;
        if (n2 * n3 > n4) {
            int n5 = n2 / 2;
            int n6 = n3 / 2;
            while (n5 * n6 > n4) {
                n5 /= 2;
                n6 /= 2;
            }
            this.preview = new BufferedImage(n5, n6, 2);
            this.atPreview = aP.a(new jp.live2d.type_editor.i(0.0, 0.0, n5, n6), new jp.live2d.type_editor.i(0.0, 0.0, n2, n3));
            jp.live2d.type_editor.a a2 = aP.a(new jp.live2d.type_editor.i(0.0, 0.0, n2, n3), new jp.live2d.type_editor.i(0.0, 0.0, n5, n6));
            Graphics2D graphics2D = this.preview.createGraphics();
            graphics2D.transform(a2);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        }
        this.icon = null;
    }

    @Override
    public void read(jp.noids.xml.serialize.g g2, Element element) {
        super.read(g2, g2.b(element));
        IResourceRef iResourceRef = (IResourceRef)g2.a(element, "imageRef");
        this.setRes(iResourceRef);
        try {
            if (this.readSetupResource(g2, iResourceRef)) {
                boolean bl2 = iResourceRef instanceof ARes_File ? ((ARes_File)iResourceRef).isSrcFileUpdatedOnRead() : false;
                this.checkAndUpdateImageCache(!bl2);
                BufferedImage bufferedImage = this.getImage();
                this.setupImage(bufferedImage);
            }
        }
        catch (Exception exception) {
            if (g2.f()) {
                exception.printStackTrace();
            }
            throw new e(String.valueOf(a.b.a("CUBI-1362")) + iResourceRef.getName(), exception);
        }
        this.updateRenamedFlag_xsRead();
    }

    private BufferedImage getImage() {
        try {
            this.checkAndUpdate();
            if (this.cachedImage_dontUseDirect != null) {
                return this.cachedImage_dontUseDirect;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return UtImage.createTextImage(400, 400, Color.RED, "NO IMAGE");
    }

    private void checkAndUpdate() {
        this.checkAndUpdateImageCache(false);
        if (this.isDirty()) {
            this.update();
        }
    }

    private void checkAndUpdateImageCache(boolean bl2) {
        if (this.cachedImage_dontUseDirect == null || this.getResourceRef().isCacheUpdated(this.cacheInfo)) {
            if (this.getResourceRef().isValid()) {
                this.cachedImage_dontUseDirect = (BufferedImage)this.getResourceRef().getData();
                this.cacheInfo = this.getResourceRef().getCacheInfo();
                this.icon = null;
            } else {
                this.cachedImage_dontUseDirect = UtImage.createTextImage(400, 400, Color.RED, "NO IMAGE");
            }
            this.setDirty();
        }
    }

    @Override
    public void write(l l2, Element element) {
        this.checkAndUpdate();
        super.write(l2, l2.a(element));
        l2.a(element, "imageRef", this.getResourceRef());
    }

    public k getSize() {
        this.checkAndUpdate();
        return this.imageSize;
    }

    @Override
    public void draw(jp.noids.movie.scene.a a2) {
        this.checkAndUpdate();
        if (this.visualHandler == null) {
            return;
        }
        if (this.getResourceRef().isValid()) {
            this.draw_exe(a2);
        }
    }

    public void draw_exe(jp.noids.movie.scene.a a2) {
        try {
            h h2 = a2.u();
            int n2 = this.getLocalFramePos(h2);
            BufferedImage bufferedImage = this.getImage();
            if (!this.isInBound(h2)) {
                return;
            }
            double d2 = 0.01 * this.visualHandler.c(h2);
            jp.live2d.type_editor.a a3 = this.getTrackToParentTransform(h2);
            jp.noids.graphics.a a4 = a2.k();
            AffineTransform affineTransform = ((Graphics2D)a4).getTransform();
            Composite composite = i.a((Graphics)a4, d2);
            this.lastPos = n2;
            ((Graphics2D)a4).transform(a3);
            ((Graphics2D)a4).translate(-this.originPoint.x, -this.originPoint.y);
            if (a2.p() >= 3) {
                ((Graphics2D)a4).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                UtImage.drawImageWithMargin(a4, bufferedImage, 0, 0);
            } else if (a2.p() >= 2) {
                ((Graphics2D)a4).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                UtImage.drawImageWithMargin(a4, bufferedImage, 0, 0);
            } else if (a2.p() >= 1) {
                ((Graphics2D)a4).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics)a4).drawImage(bufferedImage, 0, 0, null);
            } else {
                ((Graphics2D)a4).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                if (this.preview != null) {
                    ((Graphics2D)a4).transform(this.atPreview);
                    ((Graphics)a4).drawImage(this.preview, 0, 0, null);
                } else {
                    ((Graphics)a4).drawImage(bufferedImage, 0, 0, null);
                }
            }
            ((Graphics2D)a4).setTransform(affineTransform);
            if (composite != null) {
                ((Graphics2D)a4).setComposite(composite);
            }
            ((Graphics2D)a4).setTransform(affineTransform);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean contains(h h2, g g2) {
        this.checkAndUpdate();
        int n2 = this.getLocalFramePos(h2);
        if (!this.isInBound(h2)) {
            return false;
        }
        return this.getBounds(h2).contains(g2);
    }

    @Override
    public jp.live2d.type_editor.i getBounds(h h2, jp.live2d.type_editor.a a2) {
        this.checkAndUpdate();
        jp.live2d.type_editor.i i2 = m.a(this.getBounds(h2), a2);
        return i2;
    }

    @Override
    public jp.live2d.type_editor.i getBounds(h h2) {
        this.checkAndUpdate();
        jp.live2d.type_editor.i i2 = new jp.live2d.type_editor.i(-this.originPoint.x, -this.originPoint.y, this.imageSize.getWidth(), this.imageSize.getHeight());
        return i2;
    }

    public static MvTrack_Image createSample() {
        MvTrack_Image mvTrack_Image = new MvTrack_Image();
        mvTrack_Image.setName(String.valueOf(a.b.a("CUBI-1363")) + autoIdCount);
        mvTrack_Image.setID(new TrackID("sample_qt" + autoIdCount++));
        mvTrack_Image.setStart(0);
        File file = UtImage.getSampleImageFile();
        Res_Linked_QTClone res_Linked_QTClone = new Res_Linked_QTClone(file, null);
        mvTrack_Image.setImage(res_Linked_QTClone, MvMovieInfo.createSample(), new g(320.0, 240.0));
        return mvTrack_Image;
    }

    @Override
    public void setDirty() {
        super.setDirty_exe(true);
    }

    @Override
    protected void update() {
        super.setDirty_exe(false);
    }

    @Override
    public Icon getIcon(int n2) {
        this.checkAndUpdate();
        if (this.icon == null || this.icon.getIconWidth() != n2 || this.icon.getIconHeight() != n2) {
            this.getIcon_exe(n2);
        }
        return new j.e(this.icon, n2);
    }

    private void getIcon_exe(int n2) {
        try {
            if (!this.getResourceRef().isValid()) {
                this.icon = j.o();
                return;
            }
            BufferedImage bufferedImage = this.preview != null ? this.preview : this.getImage();
            Dimension dimension = aP.a(bufferedImage.getWidth(), bufferedImage.getHeight(), n2, n2);
            BufferedImage bufferedImage2 = f.a(bufferedImage, dimension.width, dimension.height);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(4, 0.8f));
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n2, n2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, 0, n2 - 1, n2 - 1);
            graphics2D.dispose();
            bufferedImage2.flush();
            this.icon = new ImageIcon(bufferedImage2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.icon = j.o();
        }
    }
}

